/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout;

import com.ibm.icu.util.ULocale;
import ilog.views.util.IlvResourceUtil;
import java.io.Serializable;

public class IlvGraphLayoutReport
implements Serializable {
    public static final int INITIAL_CODE = 0;
    public static final int EMPTY_GRAPHER = 1;
    public static final int NO_MOVEABLE_NODE = 2;
    public static final int NO_RESHAPEABLE_LINK = 3;
    public static final int NOT_NEEDED = 4;
    public static final int LAYOUT_DONE = 5;
    public static final int STOPPED_AND_VALID = 6;
    public static final int STOPPED_AND_INVALID = 7;
    public static final int LAYOUT_STARTED = 8;
    public static final int LAYOUT_FINISHED = 9;
    public static final int EXCEPTION_DURING_LAYOUT = 10;
    public static final int GREATEST_CODE = 10;
    private int a = 0;
    private long b = 0L;
    private long c = 0L;
    private int d = 0;

    protected IlvGraphLayoutReport() {
    }

    final void a(long l) {
        this.b = l;
    }

    final long a() {
        return this.b;
    }

    final void b(long l) {
        this.c = l;
    }

    public long getLayoutTime() {
        return this.c - this.b;
    }

    final void a(int n) {
        this.d = n;
    }

    public int getPercentageComplete() {
        return this.d;
    }

    public void setCode(int n) {
        this.a = n;
    }

    public int getCode() {
        return this.a;
    }

    public String codeToString(int n) {
        switch (n) {
            case 0: {
                return "layout not yet called";
            }
            case 5: {
                return "layout done";
            }
            case 6: {
                return "layout stopped with valid result";
            }
            case 7: {
                return "layout stopped with invalid result";
            }
            case 4: {
                return "layout not needed";
            }
            case 1: {
                return "layout not done (empty graph)";
            }
            case 2: {
                return "layout not done (no movable node)";
            }
            case 3: {
                return "layout not done (no reshapeable link)";
            }
            case 8: {
                return "layout started";
            }
            case 9: {
                return "layout finished";
            }
            case 10: {
                return "exception during layout";
            }
        }
        return "unknown code " + n;
    }

    public String codeToString(int n, ULocale uLocale) {
        String string = "UNKNOWN";
        switch (n) {
            case 0: {
                string = "INITIAL_CODE";
                break;
            }
            case 5: {
                string = "LAYOUT_DONE";
                break;
            }
            case 6: {
                string = "STOPPED_AND_VALID";
                break;
            }
            case 7: {
                string = "STOPPED_AND_INVALID";
                break;
            }
            case 4: {
                string = "NOT_NEEDED";
                break;
            }
            case 1: {
                string = "EMPTY_GRAPHER";
                break;
            }
            case 2: {
                string = "NO_MOVEABLE_NODE";
                break;
            }
            case 3: {
                string = "NO_RESHAPEABLE_LINK";
                break;
            }
            case 8: {
                string = "LAYOUT_STARTED";
                break;
            }
            case 9: {
                string = "LAYOUT_FINISHED";
                break;
            }
            case 10: {
                string = "EXCEPTION_DURING_LAYOUT";
            }
        }
        return IlvResourceUtil.getSafeString((String)("IlvGraphLayoutReportCode." + string), IlvGraphLayoutReport.class, (ULocale)uLocale);
    }
}

