/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.diagrammer.internal;

import ilog.views.IlvManagerViewInteractor;
import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.print.IlvManagerPrintableDocument;
import ilog.views.print.IlvManagerPrintingController;
import ilog.views.print.IlvPrintAreaInteractor;
import ilog.views.util.image.PNGImageEncoder;
import ilog.views.util.internal.IlvURLUtil;
import ilog.views.util.print.IlvPrintPreviewPanel;
import ilog.views.util.print.IlvPrintableDocument;
import ilog.views.util.print.IlvPrintingController;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class DiagrammerPrintingHelper {
    private IlvDiagrammer a;
    private boolean b;
    private Thread c;
    private IlvDiagrammer.PrinterExceptionHandler d;
    private static final String e = "DiagrammerPrintingHelper";

    private DiagrammerPrintingHelper(IlvDiagrammer ilvDiagrammer) {
        this.a = ilvDiagrammer;
    }

    protected Window createPrintPreviewWindow(Window window) {
        return new PreviewFrame(IlvPrintPreviewPanel.getPrintPreviewTitle(), window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(File file) throws PrinterException, IOException {
        String string = file.getPath();
        Graphics2D graphics2D = null;
        IlvPrintableDocument ilvPrintableDocument = this.a().getDocument();
        int n = ilvPrintableDocument.getNumberOfPages();
        boolean bl = string.endsWith(".jpg");
        for (int i = 0; i < n; ++i) {
            BufferedImage bufferedImage = new BufferedImage((int)ilvPrintableDocument.getPageFormat(i).getWidth(), (int)ilvPrintableDocument.getPageFormat(i).getHeight(), bl ? 1 : 2);
            try {
                graphics2D = bufferedImage.createGraphics();
                if (bl) {
                    graphics2D.setColor(((Component)((Object)this.a.getView())).getBackground());
                    graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                }
                ilvPrintableDocument.print((Graphics)graphics2D, ilvPrintableDocument.getPageFormat(i), i);
            }
            finally {
                graphics2D.dispose();
            }
            String string2 = string;
            if (n > 1) {
                int n2 = string2.lastIndexOf(46);
                string2 = n2 > 0 ? string2.substring(0, n2) + i + string2.substring(n2) : string2 + i;
            }
            if (bl) {
                ImageIO.write((RenderedImage)bufferedImage, "JPEG", new File(string2));
                continue;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PNGImageEncoder pNGImageEncoder = new PNGImageEncoder((OutputStream)fileOutputStream, null);
            pNGImageEncoder.encode((RenderedImage)bufferedImage);
            ((OutputStream)fileOutputStream).close();
        }
    }

    public void setThreaded(boolean bl, IlvDiagrammer.PrinterExceptionHandler printerExceptionHandler) {
        this.b = bl;
        this.d = printerExceptionHandler;
    }

    public void print(boolean bl) throws PrinterException {
        if (this.b) {
            try {
                if (this.c != null) {
                    this.c.join(0L);
                }
                this.c = new Thread(new RegularPrint(bl));
                this.c.start();
            }
            catch (InterruptedException interruptedException) {
                this.c = null;
            }
        } else {
            this.a(bl);
        }
    }

    private void a(boolean bl) throws PrinterException {
        boolean bl2 = this.a.isEditingAllowed();
        if (bl2) {
            this.a.setEditingAllowed(false);
        }
        try {
            this.a().print(bl);
        }
        finally {
            if (bl2) {
                this.a.setEditingAllowed(true);
            }
        }
    }

    private IlvManagerPrintingController a() {
        return this.a.getPrintingController();
    }

    public static void initializeController(IlvDiagrammer ilvDiagrammer, IlvManagerPrintingController ilvManagerPrintingController) {
        ((IlvManagerPrintableDocument)ilvManagerPrintingController.getDocument()).setZoomLevelModificationEnabled(true);
        URL uRL = ilvDiagrammer.getDataFile();
        String string = uRL != null && uRL.getPath() != null ? IlvURLUtil.lastPathComponent((URL)uRL) : "Diagrammer";
        ilvManagerPrintingController.getDocument().setName(string);
    }

    private static synchronized DiagrammerPrintingHelper a(IlvDiagrammer ilvDiagrammer) {
        DiagrammerPrintingHelper diagrammerPrintingHelper = (DiagrammerPrintingHelper)ilvDiagrammer.getClientProperty(e);
        if (diagrammerPrintingHelper == null) {
            diagrammerPrintingHelper = new DiagrammerPrintingHelper(ilvDiagrammer);
            ilvDiagrammer.putClientProperty(e, diagrammerPrintingHelper);
        }
        ((IlvManagerPrintableDocument)diagrammerPrintingHelper.a().getDocument()).setZoomLevel(ilvDiagrammer.getView().getTransformer().zoomFactor());
        return diagrammerPrintingHelper;
    }

    private static Window b(IlvDiagrammer ilvDiagrammer) {
        return (Window)SwingUtilities.getAncestorOfClass(Window.class, ilvDiagrammer);
    }

    public static void pageSetup(IlvDiagrammer ilvDiagrammer) {
        DiagrammerPrintingHelper diagrammerPrintingHelper = DiagrammerPrintingHelper.a(ilvDiagrammer);
        diagrammerPrintingHelper.a().setupDialog(DiagrammerPrintingHelper.b(ilvDiagrammer), true, true);
    }

    public static void printPreview(IlvDiagrammer ilvDiagrammer) {
        DiagrammerPrintingHelper diagrammerPrintingHelper = DiagrammerPrintingHelper.a(ilvDiagrammer);
        diagrammerPrintingHelper.a().printPreview(DiagrammerPrintingHelper.b(ilvDiagrammer));
    }

    public static void setPrintArea(IlvDiagrammer ilvDiagrammer) {
        DiagrammerPrintingHelper diagrammerPrintingHelper = DiagrammerPrintingHelper.a(ilvDiagrammer);
        IlvPrintAreaInteractor ilvPrintAreaInteractor = new IlvPrintAreaInteractor(diagrammerPrintingHelper.a());
        float[] fArray = new float[2];
        fArray[0] = 8.0f;
        fArray[1] = 1.0f;
        ilvPrintAreaInteractor.setLineStyle(fArray);
        ilvDiagrammer.getView().pushInteractor((IlvManagerViewInteractor)ilvPrintAreaInteractor);
    }

    public static void clearPrintArea(IlvDiagrammer ilvDiagrammer) {
        DiagrammerPrintingHelper diagrammerPrintingHelper = DiagrammerPrintingHelper.a(ilvDiagrammer);
        ((IlvManagerPrintableDocument)diagrammerPrintingHelper.a().getDocument()).setPrintArea(null);
    }

    public static void print(IlvDiagrammer ilvDiagrammer, boolean bl, boolean bl2, IlvDiagrammer.PrinterExceptionHandler printerExceptionHandler) throws PrinterException {
        DiagrammerPrintingHelper diagrammerPrintingHelper = DiagrammerPrintingHelper.a(ilvDiagrammer);
        diagrammerPrintingHelper.setThreaded(bl2, printerExceptionHandler);
        diagrammerPrintingHelper.print(bl);
    }

    public static void exportToBitmap(IlvDiagrammer ilvDiagrammer, File file) throws IOException, PrinterException {
        DiagrammerPrintingHelper diagrammerPrintingHelper = DiagrammerPrintingHelper.a(ilvDiagrammer);
        diagrammerPrintingHelper.a(file);
    }

    private class RegularPrint
    implements Runnable {
        boolean a;

        public RegularPrint(boolean bl) {
            this.a = bl;
        }

        @Override
        public void run() {
            try {
                DiagrammerPrintingHelper.this.a(this.a);
            }
            catch (PrinterException printerException) {
                if (DiagrammerPrintingHelper.this.d != null) {
                    DiagrammerPrintingHelper.this.d.exceptionThrown(printerException, DiagrammerPrintingHelper.this.a);
                }
                throw new RuntimeException(printerException.getMessage(), printerException);
            }
        }
    }

    private class PreviewFrame
    extends JFrame {
        private Window a;

        public PreviewFrame(String string, Window window) {
            super(string);
            this.setDefaultCloseOperation(1);
            IlvPrintPreviewPanel ilvPrintPreviewPanel = new IlvPrintPreviewPanel((IlvPrintingController)DiagrammerPrintingHelper.this.a(), DiagrammerPrintingHelper.this.a().getPreviewMode());
            this.getContentPane().add((Component)ilvPrintPreviewPanel);
            if (window instanceof JFrame) {
                this.setIconImage(((JFrame)window).getIconImage());
            }
            this.a = window;
        }

        @Override
        public void setVisible(boolean bl) {
            if (bl) {
                this.setBounds(this.a.getBounds());
            } else {
                this.a.setBounds(this.getBounds());
            }
            if (!bl) {
                this.a.setVisible(!bl);
                super.setVisible(bl);
            } else {
                super.setVisible(bl);
                this.a.setVisible(!bl);
            }
        }
    }
}

