/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.diagrammer.datasource;

import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.diagrammer.IlvDiagrammerException;
import ilog.views.diagrammer.datasource.IlvDiagrammerDataSource;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.model.IlvBasicSDMModel;
import ilog.views.sdm.model.IlvFilterSDMModel;
import ilog.views.sdm.model.IlvMultipleSDMModel;
import ilog.views.sdm.model.IlvTableSDMModel;
import ilog.views.util.data.IlvJDBCConnectionParameters;
import ilog.views.util.data.IlvJDBCQueryParameters;
import ilog.views.util.data.IlvJDBCTableModel;
import ilog.views.util.data.IlvTableModelMapper;
import ilog.views.util.internal.IlvURLUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.table.TableModel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IlvJDBCDataSource
extends IlvDiagrammerDataSource {
    private ArrayList a = new ArrayList();

    public void addQuery(QueryParameters queryParameters) {
        this.a.add(queryParameters);
    }

    public void removeQuery(QueryParameters queryParameters) {
        this.a.remove((Object)queryParameters);
    }

    public Collection getQueries() {
        return this.a;
    }

    public void removeAllQueries() {
        this.a.clear();
    }

    @Override
    public void read(IlvDiagrammer ilvDiagrammer) throws IlvDiagrammerException {
        IlvJDBCConnectionParameters ilvJDBCConnectionParameters = null;
        try {
            IlvMultipleSDMModel ilvMultipleSDMModel = new IlvMultipleSDMModel();
            HashMap hashMap = new HashMap();
            for (int i = 0; i < this.a.size(); ++i) {
                QueryParameters queryParameters = (QueryParameters)((Object)this.a.get(i));
                ilvJDBCConnectionParameters = queryParameters.getConnection();
                Connection connection = this.a(hashMap, ilvJDBCConnectionParameters);
                IlvJDBCTableModel ilvJDBCTableModel = new IlvJDBCTableModel(connection, queryParameters.getQuery(), queryParameters.getQueryParameters());
                queryParameters.getMapper().setTableModel((TableModel)ilvJDBCTableModel);
                IlvTableSDMModel ilvTableSDMModel = new IlvTableSDMModel(queryParameters.getMapper(), queryParameters.getDefaultTag(), queryParameters.getDefaultIsLinks(), queryParameters.isMapAllColumns());
                ilvMultipleSDMModel.addModel(ilvTableSDMModel);
            }
            this.a(ilvDiagrammer.getEngine(), ilvMultipleSDMModel);
        }
        catch (Exception exception) {
            throw new IlvDiagrammerException(exception);
        }
    }

    private Connection a(HashMap hashMap, IlvJDBCConnectionParameters ilvJDBCConnectionParameters) throws Exception {
        Connection connection = (Connection)hashMap.get(ilvJDBCConnectionParameters);
        if (connection == null) {
            connection = ilvJDBCConnectionParameters.getConnection();
            hashMap.put(ilvJDBCConnectionParameters, connection);
        }
        return connection;
    }

    @Override
    public void write(IlvDiagrammer ilvDiagrammer) throws IlvDiagrammerException {
        throw new IlvDiagrammerException("Writing not supported by JDBC data sources.");
    }

    @Override
    public String getDescription() {
        if (this.a.size() > 0) {
            return ((QueryParameters)((Object)this.a.get(0))).getConnection().getURL();
        }
        return super.getDescription();
    }

    @Override
    protected void serializeImpl(Element element) throws IlvDiagrammerException {
        try {
            for (int i = 0; i < this.a.size(); ++i) {
                QueryParameters queryParameters = PathUtil.d((QueryParameters)((Object)this.a.get(i)), this.getBaseURL());
                Element element2 = queryParameters.serialize(element);
                element.appendChild(element2);
            }
        }
        catch (Exception exception) {
            throw new IlvDiagrammerException(exception);
        }
    }

    @Override
    protected void deserializeImpl(Element element) throws IlvDiagrammerException {
        try {
            NodeList nodeList = element.getElementsByTagName("query");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                QueryParameters queryParameters = new QueryParameters(element, element2);
                this.addQuery(PathUtil.c(queryParameters, this.getBaseURL()));
            }
        }
        catch (Exception exception) {
            throw new IlvDiagrammerException(exception);
        }
    }

    private void a(IlvSDMEngine ilvSDMEngine, IlvSDMModel ilvSDMModel) {
        ilvSDMEngine.setMetadataEnabled(true);
        IlvFilterSDMModel ilvFilterSDMModel = null;
        IlvSDMModel ilvSDMModel2 = ilvSDMEngine.getModel();
        while (ilvSDMModel2 != null) {
            if (!(ilvSDMModel2 instanceof IlvFilterSDMModel)) {
                if (ilvFilterSDMModel != null) {
                    ilvFilterSDMModel.setFilteredModel(ilvSDMModel);
                } else {
                    ilvSDMEngine.setModel(ilvSDMModel, false);
                }
                ilvSDMEngine.loadData();
                ((IlvBasicSDMModel)ilvSDMEngine.getModel()).fireDataChanged(null);
                break;
            }
            ilvFilterSDMModel = (IlvFilterSDMModel)ilvSDMModel2;
            ilvSDMModel2 = ilvSDMModel2 instanceof IlvFilterSDMModel ? ((IlvFilterSDMModel)ilvSDMModel2).getFilteredModel() : null;
        }
    }

    private static class PathUtil {
        private PathUtil() {
        }

        private static QueryParameters c(QueryParameters queryParameters, URL uRL) {
            QueryParameters queryParameters2 = queryParameters;
            if (uRL != null) {
                String string = queryParameters.getConnection().getURL();
                int n = string.lastIndexOf("DBQ=");
                if (n != -1) {
                    String string2 = string.substring(n += 4);
                    boolean bl = false;
                    if (string2.startsWith("/") && string2.charAt(2) == ':') {
                        bl = true;
                    }
                    File file = new File(string2);
                    if (bl || !file.isAbsolute()) {
                        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
                        String string3 = IlvURLUtil.convertFileURLToFilename((URL)uRL);
                        int n2 = string3.lastIndexOf(File.separatorChar);
                        if (n2 < string3.length()) {
                            string3 = string3.substring(0, n2 + 1);
                        }
                        file = new File(string3 + string2);
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (bl) {
                            stringBuffer.append(string2.substring(1).replace(File.separatorChar, '/'));
                        } else {
                            stringBuffer.append(file.toString().replace(File.separatorChar, '/'));
                        }
                        string = stringBuffer.toString();
                        IlvJDBCConnectionParameters ilvJDBCConnectionParameters = queryParameters.getConnection();
                        IlvJDBCConnectionParameters ilvJDBCConnectionParameters2 = new IlvJDBCConnectionParameters(string, ilvJDBCConnectionParameters.getUserName(), ilvJDBCConnectionParameters.getUserPassword(), ilvJDBCConnectionParameters.getDriverClassName(), ilvJDBCConnectionParameters.getDriverURL());
                        queryParameters2 = new QueryParameters(queryParameters.getQuery(), queryParameters.getQueryParameters(), ilvJDBCConnectionParameters2, queryParameters.getMapper(), queryParameters.getDefaultTag(), queryParameters.getDefaultIsLinks(), queryParameters.isMapAllColumns());
                    }
                }
            }
            return queryParameters2;
        }

        private static QueryParameters d(QueryParameters queryParameters, URL uRL) {
            QueryParameters queryParameters2 = queryParameters;
            if (uRL != null) {
                String string = queryParameters.getConnection().getURL();
                int n = string.lastIndexOf("DBQ=");
                if (n != -1) {
                    URL uRL2;
                    String string2 = string.substring(n += 4);
                    File file = new File(string2);
                    try {
                        uRL2 = IlvURLUtil.convertFileToAbsoluteURL((File)file);
                    }
                    catch (MalformedURLException malformedURLException) {
                        uRL2 = null;
                    }
                    if (uRL2 != null) {
                        String string3 = PathUtil.a(uRL2, uRL);
                        string = string.substring(0, n) + string3;
                        IlvJDBCConnectionParameters ilvJDBCConnectionParameters = queryParameters.getConnection();
                        IlvJDBCConnectionParameters ilvJDBCConnectionParameters2 = new IlvJDBCConnectionParameters(string, ilvJDBCConnectionParameters.getUserName(), ilvJDBCConnectionParameters.getUserPassword(), ilvJDBCConnectionParameters.getDriverClassName(), ilvJDBCConnectionParameters.getDriverURL());
                        queryParameters2 = new QueryParameters(queryParameters.getQuery(), queryParameters.getQueryParameters(), ilvJDBCConnectionParameters2, queryParameters.getMapper(), queryParameters.getDefaultTag(), queryParameters.getDefaultIsLinks(), queryParameters.isMapAllColumns());
                    }
                }
            }
            return queryParameters2;
        }

        private static String a(URL uRL, URL uRL2) {
            int n;
            int n2;
            String string = IlvURLUtil.convertFileURLToFilename((URL)uRL).replace(File.separatorChar, '/');
            if (!PathUtil.b(uRL, uRL2)) {
                return string;
            }
            String string2 = IlvURLUtil.convertFileURLToFilename((URL)uRL2).replace(File.separatorChar, '/');
            String string3 = uRL.getQuery();
            String string4 = uRL.getRef();
            List<String> list = PathUtil.a(string);
            if (string.equals(string2)) {
                return list.get(list.size() - 1);
            }
            List<String> list2 = PathUtil.a(string2);
            if (!string2.endsWith("/")) {
                list2.remove(list2.size() - 1);
            }
            if ((n2 = PathUtil.a(list, list2)) == 0) {
                return string;
            }
            if (n2 == list.size()) {
                --n2;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = list2.size(); n > n2; --n) {
                arrayList.add("..");
            }
            for (n = n2; n < list.size(); ++n) {
                arrayList.add(list.get(n));
            }
            return PathUtil.a(arrayList, string4, string3);
        }

        private static boolean b(URL uRL, URL uRL2) {
            if (!uRL.getProtocol().equals(uRL2.getProtocol())) {
                return false;
            }
            if (!uRL.getHost().equals(uRL2.getHost())) {
                return false;
            }
            return uRL.getPort() == uRL2.getPort();
        }

        private static List<String> a(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                if (string2.length() == 0) continue;
                arrayList.add(string2);
            }
            return arrayList;
        }

        private static int a(List list, List list2) {
            int n = Math.min(list2.size(), list.size());
            for (int i = 0; i < n; ++i) {
                String string;
                String string2 = (String)list.get(i);
                if (string2.equals(string = (String)list2.get(i))) continue;
                return i;
            }
            return n;
        }

        private static String a(List list, String string, String string2) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append("/");
            }
            if (string != null) {
                stringBuffer.append('#');
                stringBuffer.append(string);
            }
            if (string2 != null) {
                stringBuffer.append('?');
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
    }

    public static class QueryParameters
    extends IlvJDBCQueryParameters {
        private String a;
        private boolean b;
        private boolean c;

        public QueryParameters(String string, IlvJDBCConnectionParameters ilvJDBCConnectionParameters, IlvTableModelMapper ilvTableModelMapper, String string2, boolean bl) {
            this(string, ilvJDBCConnectionParameters, ilvTableModelMapper, string2, bl, true);
        }

        public QueryParameters(String string, IlvJDBCConnectionParameters ilvJDBCConnectionParameters, IlvTableModelMapper ilvTableModelMapper, String string2, boolean bl, boolean bl2) {
            this(string, null, ilvJDBCConnectionParameters, ilvTableModelMapper, string2, bl, bl2);
        }

        public QueryParameters(String string, Object[] objectArray, IlvJDBCConnectionParameters ilvJDBCConnectionParameters, IlvTableModelMapper ilvTableModelMapper, String string2, boolean bl, boolean bl2) {
            super(string, objectArray, ilvJDBCConnectionParameters, ilvTableModelMapper);
            this.a = string2;
            this.b = bl;
            this.c = bl2;
        }

        public String getDefaultTag() {
            return this.a;
        }

        public boolean getDefaultIsLinks() {
            return this.b;
        }

        public boolean isMapAllColumns() {
            return this.c;
        }

        public QueryParameters(Element element, Element element2) throws Exception {
            super(element, element2);
            this.a = element2.getAttribute("tag");
            if (this.a != null && this.a.length() == 0) {
                this.a = null;
            }
            this.b = element2.getAttribute("links").equals("true");
            this.c = !element2.getAttribute("mapAllColumns").equals("false");
        }

        public Element serialize(Element element) throws SQLException {
            Element element2 = super.serialize(element);
            if (this.a != null) {
                element2.setAttribute("tag", this.a);
            }
            element2.setAttribute("links", this.b ? "true" : "false");
            element2.setAttribute("mapAllColumns", this.c ? "true" : "false");
            return element2;
        }
    }
}

