/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import oracle.javatools.xml.bind.BindingUtil;
import oracle.javatools.xml.bind.DOMBindingRuntime;
import oracle.javatools.xml.bind.ElementFilter;
import oracle.javatools.xml.bind.ElementProxy;
import oracle.javatools.xml.bind.NodeListImpl;
import oracle.javatools.xml.bind.XMLBindingInfo;
import oracle.javatools.xml.bind.XMLName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Deprecated
class BindingContext
extends BindingUtil {
    final DOMBindingRuntime _rt;
    final Class _contextIntf;
    final Element _contextElem;
    final int _indentDepth;
    final int _type;

    BindingContext(DOMBindingRuntime rt, Class contextIntf, Element contextElem, int indentDepth) {
        this(rt, contextIntf, contextElem, indentDepth, 0);
    }

    BindingContext(DOMBindingRuntime rt, Class contextIntf, Element contextElem, int indentDepth, int type) {
        if (indentDepth < 0) {
            throw new IllegalArgumentException();
        }
        this._rt = rt;
        this._contextIntf = contextIntf;
        this._contextElem = contextElem;
        this._indentDepth = indentDepth;
        this._type = type;
    }

    BindingContext(BindingContext bc) {
        this._rt = bc._rt;
        this._contextIntf = bc._contextIntf;
        this._contextElem = bc._contextElem;
        this._indentDepth = bc._indentDepth;
        this._type = bc._type;
    }

    void setElement(Element newElem, Element curElem, XMLBindingInfo info) {
        if (curElem != null) {
            if (newElem == null) {
                BindingContext.deleteElement(curElem);
            } else if (this._contextElem != null && newElem != curElem) {
                this._contextElem.replaceChild(newElem, curElem);
            }
        } else if (newElem != null) {
            this.insertElem(info, newElem);
        }
    }

    void insertElem(XMLBindingInfo info, Element newElem) {
        int i;
        if (this._contextElem == null) {
            return;
        }
        NodeList nodeList = this._contextElem.getChildNodes();
        int n = nodeList.getLength();
        Element child1 = null;
        Element child2 = null;
        for (i = 0; i < n; ++i) {
            Node child;
            if (child2 == null && (child = nodeList.item(i)).getNodeType() == 1) {
                child2 = (Element)child;
            }
            if (child2 == null) continue;
            if (this.insertNewElement(newElem, child1, child2, info)) break;
            child1 = child2;
            child2 = null;
        }
        if (i == n) {
            this.insertNewElement(newElem, child1, child2, info);
        }
    }

    private boolean insertNewElement(Element newElem, Element child1, Element child2, XMLBindingInfo info) {
        String lname2;
        String nsURI2;
        String lname1;
        String nsURI1 = BindingContext.getNamespaceURI(child1);
        if (this._rt._binding.insertBetween(this._contextIntf, nsURI1, lname1 = BindingContext.getLocalName(child1), nsURI2 = BindingContext.getNamespaceURI(child2), lname2 = BindingContext.getLocalName(child2), info._nsURI, info._localName)) {
            this.insertElement(newElem, child2);
            return true;
        }
        return false;
    }

    void insertElement(Element newElem, Node beforeThisElem) {
        boolean needTrailingWS = this._contextElem.getChildNodes().getLength() == 0;
        Node beforeThisNode = BindingContext.findInsertionNode(this._contextElem, beforeThisElem);
        String wsBefore = this.whitespace(true, false);
        if (wsBefore != null && wsBefore.length() > 0) {
            this._contextElem.insertBefore(this._rt._document.createTextNode(wsBefore), beforeThisNode);
        }
        this._contextElem.insertBefore(newElem, beforeThisNode);
        if (needTrailingWS) {
            if (beforeThisNode != null) {
                throw new RuntimeException("Assertion failed -- beforeThisNode is non-null.");
            }
            String wsAfter = this.whitespace(true, true);
            if (wsAfter != null && wsAfter.length() > 0) {
                this._contextElem.insertBefore(this._rt._document.createTextNode(wsAfter), beforeThisNode);
            }
        }
    }

    Object createProxy(Element elem, Class propertyType, int userDefinedType) {
        BindingContext bc = new BindingContext(this._rt, propertyType, elem, this._indentDepth + 1, userDefinedType);
        ElementProxy handler = new ElementProxy(bc);
        return BindingContext.createProxy(propertyType, handler);
    }

    Object callCreate(XMLBindingInfo info, Method method) {
        Class<?> propertyType = method.getReturnType();
        if (propertyType != Void.TYPE) {
            return this.callCreateImpl(info, propertyType);
        }
        throw new IllegalStateException("Create method must return a non-void proxy type");
    }

    Object callCreateImpl(XMLBindingInfo info, Class propertyType) {
        Element newElem = this.createElement(info);
        return this.createProxy(newElem, propertyType, info.getType());
    }

    Element createElement(XMLName elemName) {
        String preferredPrefix = this.findPrefix(elemName._nsURI);
        return this._rt._document.createElementNS(elemName._nsURI, elemName.getQname(preferredPrefix));
    }

    String findPrefix(String namespaceURI) {
        if (this._contextElem == null || namespaceURI == null) {
            return null;
        }
        if (XMLName.isDefaultNamespace(this._contextElem, namespaceURI)) {
            return "";
        }
        return XMLName.lookupPrefix(this._contextElem, namespaceURI);
    }

    static NodeListImpl getChildrenByQName(Element parent, String nsURI, String locName) {
        return BindingContext.getChildrenByQName(parent, nsURI, locName, new ElementFilter());
    }

    static NodeListImpl getChildrenByQName(Element parent, String nsURI, String locName, ElementFilter filter) {
        assert (filter != null);
        NodeListImpl nodeList = new NodeListImpl();
        if (parent != null) {
            for (Node curNode = parent.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
                Element curElem;
                if (curNode.getNodeType() != 1 || !BindingContext.matches(curElem = (Element)curNode, nsURI, locName) || !filter.accept(curElem)) continue;
                nodeList.add(curElem);
            }
        }
        return nodeList;
    }

    static boolean matches(Element elem, String nsURI, String lname) {
        if (elem != null) {
            return BindingContext.areEqual(nsURI, elem.getNamespaceURI()) && BindingContext.areEqual(lname, elem.getLocalName());
        }
        return false;
    }

    static Element extractElementFromProxy(Object proxy) {
        InvocationHandler handler;
        InvocationHandler invocationHandler = handler = proxy != null ? Proxy.getInvocationHandler(proxy) : null;
        if (handler != null) {
            try {
                return ((ElementProxy)handler)._bc._contextElem;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Values must be created by the binding runtime.");
            }
        }
        return null;
    }

    static Object createProxy(Class propertyType, InvocationHandler handler) {
        return Proxy.newProxyInstance(propertyType.getClassLoader(), new Class[]{propertyType}, handler);
    }

    static Text findFirstTextNodeInChildElement(Element element, XMLBindingInfo info, boolean createTextNode) {
        NodeListImpl nodeList = BindingContext.getChildrenByQName(element, info._nsURI, info._localName);
        if (nodeList.getLength() > 0) {
            Element elem = (Element)nodeList.item(0);
            return BindingContext.findFirstTextNode(elem, createTextNode);
        }
        return null;
    }

    static Text findFirstTextNode(Element elem, boolean createTextNode) {
        NodeList childNodes = elem.getChildNodes();
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = childNodes.item(0);
            if (node.getNodeType() != 3) continue;
            return (Text)node;
        }
        if (createTextNode) {
            Text text = elem.getOwnerDocument().createTextNode("");
            elem.appendChild(text);
            return text;
        }
        return null;
    }

    static void deleteElement(Element elem) {
        Node parentNode = elem.getParentNode();
        BindingContext.deleteIfWhitespaceTextNode(parentNode, elem.getPreviousSibling());
        parentNode.removeChild(elem);
        NodeList remainingSiblings = parentNode.getChildNodes();
        if (remainingSiblings.getLength() == 1) {
            BindingContext.deleteIfWhitespaceTextNode(parentNode, remainingSiblings.item(0));
        }
    }

    static String obj2String(Object o) {
        return o != null ? o.toString() : null;
    }

    private String whitespace(boolean newline, boolean minusOne) {
        if (!this._rt._enableWhitespace) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (newline) {
            buf.append(this._rt._eol);
        }
        int depth = this._indentDepth;
        if (minusOne) {
            --depth;
        }
        if (depth > 0) {
            buf.append(this._rt.getIndent(depth));
        }
        return buf.toString();
    }

    private static boolean isWhitespaceTextNode(Node node) {
        return node != null && node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0;
    }

    private static void deleteIfWhitespaceTextNode(Node parentNode, Node node) {
        if (BindingContext.isWhitespaceTextNode(node)) {
            parentNode.removeChild(node);
        }
    }

    private static Node findInsertionNode(Element parentElem, Node insertionPoint) {
        Node prevSibling1;
        Node node = prevSibling1 = insertionPoint != null ? insertionPoint.getPreviousSibling() : parentElem.getLastChild();
        if (BindingContext.isWhitespaceTextNode(prevSibling1)) {
            String text;
            Node prevSibling3;
            Node prevSibling2 = prevSibling1.getPreviousSibling();
            if (BindingContext.isCommentNode(prevSibling2) && BindingContext.isWhitespaceTextNode(prevSibling3 = prevSibling2.getPreviousSibling()) && ((text = prevSibling3.getNodeValue()).indexOf(13) >= 0 || text.indexOf(10) >= 0)) {
                return prevSibling3;
            }
            return prevSibling1;
        }
        return insertionPoint;
    }

    private static boolean isCommentNode(Node node) {
        return node != null && node.getNodeType() == 8;
    }

    private static String getNamespaceURI(Element elem) {
        return elem != null ? elem.getNamespaceURI() : null;
    }

    private static String getLocalName(Element elem) {
        return elem != null ? elem.getLocalName() : null;
    }
}

