/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.Arrays;
import java.util.Collection;

public interface Filter<T> {
    public boolean matches(T var1);

    public static class Instances {
        public static <Q> Filter<Q> nonNull(Filter<Q> base) {
            if (base == null) {
                return Instances.acceptsAll();
            }
            return base;
        }

        public static <Q> Filter<Q> acceptsAll() {
            return Instances._all(true);
        }

        public static <Q> Filter<Q> acceptsNone() {
            return Instances._all(false);
        }

        private static <Q> Filter<Q> _all(final boolean result) {
            return new Filter<Q>(){

                @Override
                public boolean matches(Object value) {
                    return result;
                }
            };
        }

        public static <Q> Filter<Q> or(Filter<Q> ... filters) {
            return new Or<Q>(Arrays.asList(filters));
        }

        public static <Q> Filter<Q> or(Collection<Filter<Q>> filters) {
            return new Or<Q>(filters);
        }

        public static <Q> Filter<Q> and(Filter<Q> ... filters) {
            return new And<Q>(Arrays.asList(filters));
        }

        public static <Q> Filter<Q> and(Collection<Filter<Q>> filters) {
            return new And<Q>(filters);
        }

        public static <Q> Filter<Q> not(Filter<Q> filter) {
            return new Not<Q>(filter);
        }

        private static class Not<Q>
        implements Filter<Q> {
            private final Filter<Q> _filter;

            Not(Filter<Q> filter) {
                this._filter = filter;
            }

            @Override
            public boolean matches(Q value) {
                return !this._filter.matches(value);
            }
        }

        private static class And<Q>
        implements Filter<Q> {
            private Collection<Filter<Q>> _filters;

            And(Collection<Filter<Q>> filters) {
                this._filters = filters;
            }

            @Override
            public boolean matches(Q value) {
                for (Filter<Q> filter : this._filters) {
                    if (filter.matches(value)) continue;
                    return false;
                }
                return true;
            }
        }

        private static class Or<Q>
        implements Filter<Q> {
            private Collection<Filter<Q>> _filters;

            Or(Collection<Filter<Q>> filters) {
                this._filters = filters;
            }

            @Override
            public boolean matches(Q value) {
                for (Filter<Q> filter : this._filters) {
                    if (!filter.matches(value)) continue;
                    return true;
                }
                return false;
            }
        }
    }
}

