/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.AbstractBraceProvider;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.generic.BraceHelper;
import oracle.javatools.parser.generic.GenericLexer;
import oracle.javatools.parser.generic.Language;

public class GenericBraceProvider
extends AbstractBraceProvider
implements BraceProvider {
    protected TextBuffer textBuffer;
    protected BraceHelper braceHelper;
    protected GenericLexer lexer;
    protected LexerToken lexerToken;
    protected String braceCharacters;

    public GenericBraceProvider(LanguageSupport support, Language language) {
        this(support, language, new GenericLexer(language));
    }

    public GenericBraceProvider(LanguageSupport support, Language language, GenericLexer lexerToUse) {
        BasicDocument document = support.getDocument();
        this.textBuffer = document.getTextBuffer();
        this.braceHelper = language.getBraceHelper();
        this.lexer = lexerToUse;
        this.lexer.setSkipComments(true);
        StringBuffer sb = new StringBuffer();
        String[][] bracePairs = language.getBraces();
        int numPairs = bracePairs != null ? bracePairs.length : 0;
        for (int i = 0; i < numPairs; ++i) {
            try {
                String[] bracePair = bracePairs[i];
                if (bracePair[0] != null) {
                    sb.append(bracePair[0]);
                }
                if (bracePair[1] == null) continue;
                sb.append(bracePair[1]);
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.braceCharacters = sb.toString();
    }

    @Override
    protected TextBuffer getTextBuffer() {
        return this.textBuffer;
    }

    @Override
    protected BraceHelper getBraceHelper() {
        return this.braceHelper;
    }

    @Override
    protected Lexer getLexer() {
        return this.lexer;
    }

    @Override
    protected boolean isBraceToken(int token) {
        return false;
    }

    @Override
    protected String getBraceCharacters() {
        return this.braceCharacters;
    }
}

