/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.find;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.BadLocationException;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorOverview;
import oracle.javatools.editor.BasicEditorOverviewMark;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.find.Find;
import oracle.javatools.editor.find.FindBundle;
import oracle.javatools.editor.find.FindCriteria;
import oracle.javatools.editor.find.FindResult;
import oracle.javatools.editor.find.FindUtils;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.ui.internal.UICUtils;

public final class Finder {
    private static final int HIGHLIGH_LIMIT = 250;
    private static final String EDITOR_PROPERTY_FIND_RESULT = "find-result";
    public static final String HIGHLIGHT_FIND_RESULT = "find-results-highlight";
    private static final String PROPERTY_FIND_HIGHLIGHT_LAYER = "find-highlight-layer";
    private static final int DEFAULT_FIND_PRIORITY = 77;
    private static final Color HIGHLIGHT_COLOR = new Color(255, 220, 255);
    private static final Object FIND_OVERVIEW_GROUP = new Object();
    private static HighlightStyle findStyle;

    public static void dispose(BasicEditorPane editor) {
        FindResult result = (FindResult)editor.getProperty(EDITOR_PROPERTY_FIND_RESULT);
        if (result != null) {
            result.dispose();
        }
    }

    public static HighlightStyle getFindStyle() {
        if (findStyle == null) {
            EditorProperties properties = EditorProperties.getProperties();
            HighlightRegistry registry = properties.getHighlightRegistry();
            findStyle = registry.lookupStyle(HIGHLIGHT_FIND_RESULT);
        }
        return findStyle;
    }

    public static void highlight(BasicEditorPane editor, List<Find> finds) {
        HighlightLayer highlightLayer = (HighlightLayer)editor.getProperty(PROPERTY_FIND_HIGHLIGHT_LAYER);
        if (highlightLayer == null) {
            highlightLayer = editor.createHighlightLayer();
            editor.putProperty(PROPERTY_FIND_HIGHLIGHT_LAYER, highlightLayer);
        }
        BasicEditorOverview overview = (BasicEditorOverview)((Object)editor.getProperty("overview"));
        for (Find find : finds) {
            highlightLayer.addHighlight(Finder.getFindStyle(), find.getStartOffset(), find.getEndOffset());
            if (overview == null) continue;
            overview.addMark(new BasicEditorOverviewMark(editor, find.getStartOffset(), find.getEndOffset(), 77.0f, HIGHLIGHT_COLOR, false, true), FIND_OVERVIEW_GROUP);
        }
    }

    public static boolean hasHighlights(BasicEditorPane editor) {
        HighlightLayer highlightLayer = (HighlightLayer)editor.getProperty(PROPERTY_FIND_HIGHLIGHT_LAYER);
        if (highlightLayer != null) {
            return highlightLayer.hasHighlights();
        }
        return false;
    }

    public static void clearHighlights(BasicEditorPane editor) {
        BasicEditorOverview overview;
        HighlightLayer highlightLayer = (HighlightLayer)editor.getProperty(PROPERTY_FIND_HIGHLIGHT_LAYER);
        if (highlightLayer != null) {
            highlightLayer.removeAllHighlights();
        }
        if ((overview = (BasicEditorOverview)((Object)editor.getProperty("overview"))) != null) {
            overview.removeMarks(FIND_OVERVIEW_GROUP);
        }
    }

    public static FindResult find(BasicEditorPane editor, FindCriteria criteria) {
        Finder.clearHighlights(editor);
        FindResult previousResult = Finder.getLatestFindResult(editor);
        if (previousResult != null) {
            previousResult.dispose();
            editor.putProperty(EDITOR_PROPERTY_FIND_RESULT, null);
        }
        if (criteria.getUpperBound() > 0 && criteria.getUpperBound() == criteria.getLowerBound()) {
            return null;
        }
        List<Find> finds = Finder.findAll(editor, criteria);
        if (finds.isEmpty()) {
            return null;
        }
        Find find = null;
        switch (criteria.getDirection()) {
            case FORWARD: {
                int pos = criteria.getLocation();
                if (pos < 0) {
                    pos = Math.max(editor.getSelectionStart(), editor.getSelectionEnd());
                }
                for (Find f : finds) {
                    if (f.getStartOffset() < pos && f.getEndOffset() <= pos) continue;
                    find = f;
                    break;
                }
                if (find != null || !criteria.isWrap()) break;
                find = finds.get(0);
                break;
            }
            case BACKWARD: {
                int pos = criteria.getLocation();
                if (pos < 0) {
                    pos = Math.min(editor.getSelectionStart(), editor.getSelectionEnd());
                }
                Find prevFind = null;
                for (Find f : finds) {
                    if (f.getStartOffset() >= pos) {
                        find = prevFind;
                        break;
                    }
                    prevFind = f;
                }
                Find lastFind = finds.get(finds.size() - 1);
                if ((find != null || !criteria.isWrap()) && lastFind.getEndOffset() > pos) break;
                find = lastFind;
                break;
            }
        }
        Finder.clearHighlights(editor);
        if (criteria.isHighlight()) {
            if (finds.size() > 250) {
                FeedbackManager fm = editor.getFeedbackManager();
                if (fm != null) {
                    fm.showFeedback(editor, FindBundle.format("FEEDBACK_FIND_HIGHLIGHT_TOO_MANY", 250), 3000);
                }
            } else {
                Finder.highlight(editor, finds);
            }
        }
        FindResult result = new FindResult(finds, find, editor.getTextBuffer().getChangeId(), criteria);
        assert (editor.getProperty(EDITOR_PROPERTY_FIND_RESULT) == null);
        editor.putProperty(EDITOR_PROPERTY_FIND_RESULT, result);
        return result;
    }

    private Finder() {
    }

    public static FindResult getLatestFindResult(BasicEditorPane editor) {
        return (FindResult)editor.getProperty(EDITOR_PROPERTY_FIND_RESULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Find> findAll(BasicEditorPane editor, FindCriteria criteria) {
        assert (criteria != null);
        if (editor == null || editor.getDocument() == null || editor.getDocument().getLength() == 0 || criteria.getText() == null || criteria.getText().length() == 0) {
            return Collections.emptyList();
        }
        if (criteria.getUpperBound() > 0 && criteria.getUpperBound() <= criteria.getLowerBound()) {
            throw new IllegalStateException("End offset (" + criteria.getUpperBound() + ")," + " is less than start offset (" + criteria.getLowerBound() + ")");
        }
        List<Find> finds = null;
        BasicDocument document = (BasicDocument)editor.getDocument();
        document.readLock();
        try {
            finds = Finder.findRegEx(editor, criteria);
        }
        finally {
            document.readUnlock();
        }
        finds = Finder.trim(editor, finds);
        return finds;
    }

    private static List<Find> findRegEx(BasicEditorPane editor, FindCriteria criteria) {
        ArrayList<Find> finds = new ArrayList<Find>();
        Pattern pattern = null;
        try {
            pattern = FindUtils.getRegExPattern(criteria);
        }
        catch (PatternSyntaxException pse) {
            return Collections.emptyList();
        }
        String text = "";
        try {
            BasicDocument document = (BasicDocument)editor.getDocument();
            text = document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            throw new IllegalStateException("Bad document size", e);
        }
        int startLocation = 0;
        int endLocation = text.length();
        Matcher matcher = pattern.matcher(text);
        boolean match = matcher.find(Math.max(0, startLocation));
        while (match) {
            MatchResult result = matcher.toMatchResult();
            int start = result.start();
            int length = result.end() - result.start();
            if (start >= endLocation) break;
            boolean isOK = true;
            if (criteria.isWholeWord() && !Finder.isWholeWordMatch(editor, start, length)) {
                isOK = false;
            }
            if (criteria.getLowerBound() >= 0 && start < criteria.getLowerBound()) {
                isOK = false;
            }
            if (criteria.getUpperBound() >= 0 && start + length > criteria.getUpperBound()) {
                isOK = false;
            }
            if (isOK) {
                Find find = new Find(editor.getTextBuffer(), start, matcher.end());
                finds.add(find);
                if (criteria.isRegEx()) {
                    for (int i = 0; i <= matcher.groupCount(); ++i) {
                        find.addGroup(matcher.group(i), matcher.start(i), matcher.end(i));
                    }
                }
            }
            match = matcher.find();
        }
        return finds;
    }

    private static List<Find> trim(BasicEditorPane editor, List<Find> finds) {
        int vStart = editor.getValidOffsetStart();
        int vEnd = editor.getValidOffsetEnd();
        if (vStart > 0 || vEnd > -1) {
            ArrayList<Find> validFinds = new ArrayList<Find>();
            for (Find f : finds) {
                if (vStart > 0 && f.getStartOffset() < vStart || vEnd > 0 && f.getEndOffset() > vEnd) continue;
                validFinds.add(f);
            }
            finds = validFinds;
        }
        return finds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isWholeWordMatch(BasicEditorPane editor, int startOffset, int length) {
        Boolean b = EditorProperties.getProperties().getBooleanProperty("word-boundary-use-case");
        try {
            EditorProperties.getProperties().putBooleanProperty("word-boundary-use-case", Boolean.FALSE);
            BasicDocument document = (BasicDocument)editor.getDocument();
            int endOffset = startOffset + length;
            int wordStart = Utilities.getWordStart(document, startOffset + 1);
            int wordEnd = Utilities.getWordEnd(document, endOffset);
            boolean bl = wordStart == startOffset && wordEnd == endOffset;
            return bl;
        }
        finally {
            EditorProperties.getProperties().putBooleanProperty("word-boundary-use-case", b);
        }
    }

    static void showErrorDialog(BasicEditorPane editor, String searchText) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        String notFoundText = FindBundle.format("FD_NOTFOUND", searchText);
        String errorTitle = FindBundle.get("FD_RESULT_TITLE");
        MessageDialog.information(editor, notFoundText, errorTitle, "f1_idedfindreplacenotfound_html");
    }

    public static void main(String[] args) {
        new FinderTester();
    }

    private static class FinderTester {
        private JTextField tf;
        private JLabel feedback = new JLabel();
        private BasicEditorPane editor;
        private HighlightLayer highlightLayer;
        private HighlightStyle highlightStyle;
        private JCheckBox caseCheck = new JCheckBox("Match Case");
        private JCheckBox wordCheck = new JCheckBox("Whole Word");
        private JCheckBox startCheck = new JCheckBox("Start at Caret");
        private JCheckBox markCheck = new JCheckBox("End at Mark");
        private JCheckBox regExCheck = new JCheckBox("RegEx");

        public FinderTester() {
            this.startCheck.setSelected(false);
            try {
                UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                // empty catch block
            }
            this.editor = new BasicEditorPane();
            this.highlightLayer = this.editor.createHighlightLayer();
            this.highlightStyle = this.editor.getHighlightRegistry().createStyle("HIGHLOIGHT", "hi", 1000, null, Color.YELLOW);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (Locale l : Locale.getAvailableLocales()) {
                sb.append(l.getDisplayCountry());
                sb.append(" ");
                if (i++ % 5 != 0) continue;
                sb.append("\n");
            }
            this.editor.setText(sb.toString());
            JPanel findPanel = new JPanel(new FlowLayout());
            findPanel.setOpaque(false);
            this.tf = new JTextField(14);
            this.tf.setHorizontalAlignment(2);
            String ENTER = "enter";
            this.tf.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), ENTER);
            this.tf.getActionMap().put(ENTER, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.find();
                }
            });
            findPanel.add(this.tf);
            findPanel.add(this.feedback);
            Box controlPanel = new Box(1);
            controlPanel.add(this.caseCheck);
            controlPanel.add(this.wordCheck);
            controlPanel.add(this.startCheck);
            controlPanel.add(this.markCheck);
            controlPanel.add(this.regExCheck);
            JPanel testPanel = new JPanel(new BorderLayout(2, 2));
            testPanel.add((Component)findPanel, "North");
            testPanel.add((Component)controlPanel, "West");
            testPanel.add(new JScrollPane(this.editor));
            UICUtils.runComponent((JComponent)testPanel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void find() {
            FindCriteria criteria = new FindCriteria(this.tf.getText());
            criteria.setMatchCase(this.caseCheck.isSelected());
            criteria.setWholeWord(this.wordCheck.isSelected());
            criteria.setRegEx(this.regExCheck.isSelected());
            if (this.startCheck.isSelected()) {
                criteria.setLowerBound(this.editor.getCaretPosition());
            }
            if (this.markCheck.isSelected()) {
                criteria.setUpperBound(this.editor.getCaret().getMark());
            }
            List finds = Finder.findAll(this.editor, criteria);
            this.highlightLayer.removeAllHighlights();
            this.highlightLayer.beginBlockUpdate();
            try {
                this.feedback.setText("" + finds.size());
                for (Find find : finds) {
                    this.highlightLayer.addHighlight(this.highlightStyle, find.getStartOffset(), find.getEndOffset());
                }
            }
            finally {
                this.highlightLayer.endBlockUpdate();
            }
        }
    }
}

