/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.find;

import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.javatools.editor.find.Find;
import oracle.javatools.editor.find.FindCriteria;
import oracle.javatools.editor.find.ReplaceCriteria;

public final class FindUtils {
    public static Pattern getRegExPattern(FindCriteria criteria) throws PatternSyntaxException {
        Pattern pattern = null;
        int matchFlags = 8;
        if (!criteria.isMatchCase()) {
            matchFlags |= 0x42;
        }
        if (!criteria.isRegEx()) {
            matchFlags |= 0x10;
        }
        pattern = Pattern.compile(criteria.getText(), matchFlags);
        return pattern;
    }

    public static String substituteSpecial(String replaceText) {
        StringBuffer buffer = new StringBuffer();
        int offset = 0;
        int length = replaceText.length();
        while (offset < length) {
            int index = replaceText.indexOf(92, offset);
            if (index == -1) {
                buffer.append(replaceText.substring(offset));
                break;
            }
            buffer.append(replaceText.substring(offset, index));
            offset = index;
            int indexDigit = index + 1;
            if (indexDigit < length) {
                char c = replaceText.charAt(indexDigit);
                switch (c) {
                    case '\\': {
                        buffer.append('\\');
                        break;
                    }
                    case 'n': 
                    case 'r': {
                        buffer.append('\n');
                        break;
                    }
                    case 't': {
                        buffer.append('\t');
                        break;
                    }
                    default: {
                        buffer.append(replaceText.substring(offset, offset + 2));
                    }
                }
                offset += 2;
                continue;
            }
            buffer.append(replaceText.substring(offset, offset + 1));
            ++offset;
        }
        String substituteText = buffer.toString();
        return substituteText;
    }

    static String substituteRegExGroups(ReplaceCriteria criteria, Find find, String replaceText) {
        List<Find.Group> groups = find.getGroups();
        int cursor = 0;
        StringBuilder newString = new StringBuilder();
        String text = criteria.getReplaceText();
        while (cursor < text.length()) {
            char nextChar = text.charAt(cursor);
            if (nextChar == '\\') {
                nextChar = text.charAt(++cursor);
                newString.append(nextChar);
                ++cursor;
                continue;
            }
            if (nextChar == '$') {
                int nextDigit;
                nextChar = text.charAt(++cursor);
                int refNum = -1;
                refNum = nextChar - 48;
                if (refNum < 0 || refNum > 9) {
                    return null;
                }
                ++cursor;
                boolean done = false;
                while (!done && cursor < text.length() && (nextDigit = text.charAt(cursor) - 48) >= 0 && nextDigit <= 9) {
                    int newRefNum = refNum * 10 + nextDigit;
                    if (groups.size() < newRefNum) {
                        done = true;
                        continue;
                    }
                    refNum = newRefNum;
                    ++cursor;
                }
                if (refNum >= groups.size()) continue;
                Find.Group group = groups.get(refNum);
                if (group.start == -1 || group.end == -1) continue;
                newString.append(group.text);
                continue;
            }
            newString.append(nextChar);
            ++cursor;
        }
        replaceText = newString.toString();
        return replaceText;
    }

    static final class ASCII {
        static final int UPPER = 256;
        static final int LOWER = 512;
        static final int DIGIT = 1024;
        static final int SPACE = 2048;
        static final int PUNCT = 4096;
        static final int CNTRL = 8192;
        static final int BLANK = 16384;
        static final int HEX = 32768;
        static final int UNDER = 65536;
        static final int ASCII = 65280;
        static final int ALPHA = 768;
        static final int ALNUM = 1792;
        static final int GRAPH = 5888;
        static final int WORD = 67328;
        static final int XDIGIT = 32768;
        private static final int[] ctype = new int[]{8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 26624, 10240, 10240, 10240, 10240, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 18432, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 33792, 33793, 33794, 33795, 33796, 33797, 33798, 33799, 33800, 33801, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 33034, 33035, 33036, 33037, 33038, 33039, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 4096, 4096, 4096, 4096, 69632, 4096, 33290, 33291, 33292, 33293, 33294, 33295, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 539, 540, 541, 542, 543, 544, 545, 546, 547, 4096, 4096, 4096, 4096, 8192};

        ASCII() {
        }

        static int getType(int ch) {
            return (ch & 0xFFFFFF80) == 0 ? ctype[ch] : 0;
        }

        static boolean isType(int ch, int type) {
            return (oracle.javatools.editor.find.FindUtils$ASCII.getType(ch) & type) != 0;
        }

        static boolean isAscii(int ch) {
            return (ch & 0xFFFFFF80) == 0;
        }

        static boolean isAlpha(int ch) {
            return oracle.javatools.editor.find.FindUtils$ASCII.isType(ch, 768);
        }

        static boolean isDigit(int ch) {
            return (ch - 48 | 57 - ch) >= 0;
        }

        static boolean isAlnum(int ch) {
            return oracle.javatools.editor.find.FindUtils$ASCII.isType(ch, 1792);
        }

        static boolean isGraph(int ch) {
            return oracle.javatools.editor.find.FindUtils$ASCII.isType(ch, 5888);
        }

        static boolean isPrint(int ch) {
            return (ch - 32 | 126 - ch) >= 0;
        }

        static boolean isPunct(int ch) {
            return oracle.javatools.editor.find.FindUtils$ASCII.isType(ch, 4096);
        }

        static boolean isSpace(int ch) {
            return oracle.javatools.editor.find.FindUtils$ASCII.isType(ch, 2048);
        }

        static boolean isHexDigit(int ch) {
            return oracle.javatools.editor.find.FindUtils$ASCII.isType(ch, 32768);
        }

        static boolean isOctDigit(int ch) {
            return (ch - 48 | 55 - ch) >= 0;
        }

        static boolean isCntrl(int ch) {
            return oracle.javatools.editor.find.FindUtils$ASCII.isType(ch, 8192);
        }

        static boolean isLower(int ch) {
            return (ch - 97 | 122 - ch) >= 0;
        }

        static boolean isUpper(int ch) {
            return (ch - 65 | 90 - ch) >= 0;
        }

        static boolean isWord(int ch) {
            return oracle.javatools.editor.find.FindUtils$ASCII.isType(ch, 67328);
        }

        static int toDigit(int ch) {
            return ctype[ch & 0x7F] & 0x3F;
        }

        static int toLower(int ch) {
            return oracle.javatools.editor.find.FindUtils$ASCII.isUpper(ch) ? ch + 32 : ch;
        }

        static int toUpper(int ch) {
            return oracle.javatools.editor.find.FindUtils$ASCII.isLower(ch) ? ch - 32 : ch;
        }
    }
}

