/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.SimpleTextRange;

public class TextRange
extends SimpleTextRange
implements Comparable {
    private TextBuffer buffer;
    private OffsetMark startOffset;
    private OffsetMark endOffset;

    public TextRange(TextBuffer buffer, int startOffset, int endOffset) {
        super(buffer, startOffset, endOffset);
        this.buffer = buffer;
        this.startOffset = buffer.addOffsetMark(startOffset, false);
        this.endOffset = buffer.addOffsetMark(endOffset, true);
    }

    public void dispose() {
        if (this.buffer != null) {
            this.buffer.removeOffsetMark(this.startOffset);
            this.buffer.removeOffsetMark(this.endOffset);
        }
        this.buffer = null;
        this.startOffset = null;
        this.endOffset = null;
    }

    @Override
    public int compareTo(Object o) {
        TextRange compareRange = (TextRange)o;
        if (this.startOffset.getOffset() < compareRange.startOffset.getOffset()) {
            return -1;
        }
        if (this.startOffset.getOffset() > compareRange.startOffset.getOffset()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset.getOffset();
    }

    @Override
    public int getEndOffset() {
        return this.endOffset.getOffset();
    }

    @Override
    public int getLength() {
        return this.getEndOffset() - this.getStartOffset() + 1;
    }

    @Override
    public boolean contains(int offset) {
        if (this.startOffset == null || this.endOffset == null) {
            return false;
        }
        if (offset < this.startOffset.getOffset()) {
            return false;
        }
        return offset <= this.endOffset.getOffset();
    }

    @Override
    public String getText() throws IndexOutOfBoundsException {
        int start = this.startOffset.getOffset();
        int len = this.getEndOffset() - this.getStartOffset();
        return this.buffer.getString(start, len);
    }

    @Override
    public String toString() {
        try {
            return "[" + this.getStartOffset() + "," + this.getEndOffset() + "] : " + this.getText();
        }
        catch (Exception e) {
            return "[]";
        }
    }
}

