/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import oracle.javatools.buffer.TextBuffer;

public class SimpleTextRange
implements Comparable {
    private final String text;
    private int start;
    private int end;
    private int changeId;

    public SimpleTextRange(TextBuffer buffer, int startOffset, int endOffset) {
        if (endOffset < startOffset) {
            throw new IllegalArgumentException("endoffset not before startffset. start: " + startOffset + " end: " + endOffset);
        }
        this.start = startOffset;
        this.end = endOffset;
        this.text = buffer.getString(this.start, endOffset - startOffset);
    }

    public int compareTo(Object obj) {
        SimpleTextRange compareRange = (SimpleTextRange)obj;
        if (this.start < compareRange.getStartOffset()) {
            return -1;
        }
        if (this.start > compareRange.getEndOffset()) {
            return 1;
        }
        return 0;
    }

    public int getStartOffset() {
        return this.start;
    }

    public int getEndOffset() {
        return this.end;
    }

    public int getLength() {
        return this.getEndOffset() - this.getStartOffset() + 1;
    }

    public boolean contains(int offset) {
        if (offset < this.start) {
            return false;
        }
        return offset <= this.end;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        try {
            return "[" + this.getStartOffset() + "," + this.getEndOffset() + "] : " + this.getText();
        }
        catch (Exception e) {
            return "[]";
        }
    }
}

