/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Caret;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.Selection;

final class NavigationEdit
extends AbstractUndoableEdit {
    private int mergeCount = 1;
    private List<Selection> startSels = new ArrayList<Selection>();
    private List<Selection> endSels = new ArrayList<Selection>();
    private Reference editorReference = null;
    private EditDescriptor editDescriptor = null;

    NavigationEdit() {
    }

    void recordCaretStart(BasicEditorPane editorPane, EditDescriptor editDescriptor) {
        Caret caret = editorPane.getCaret();
        this.startSels.clear();
        this.startSels.add(new Selection(caret.getDot(), caret.getMark()));
        this.startSels.addAll(editorPane.getMultiSelections());
        this.editorReference = editorPane.getReference();
        this.editDescriptor = editDescriptor;
    }

    void recordCaretEnd(BasicEditorPane editorPane) {
        Caret caret = editorPane.getCaret();
        this.endSels.clear();
        this.endSels.add(new Selection(caret.getDot(), caret.getMark()));
        this.endSels.addAll(editorPane.getMultiSelections());
        if (this.endSels.equals(this.startSels)) {
            this.die();
        }
    }

    @Override
    public boolean canUndo() {
        Object editor;
        boolean canUndo = super.canUndo();
        if (canUndo && (editor = this.editorReference.get()) == null) {
            canUndo = false;
        }
        return canUndo;
    }

    @Override
    public void undo() throws CannotUndoException {
        BasicEditorPane editorPane = (BasicEditorPane)this.editorReference.get();
        editorPane.setUndoInProgress(true);
        try {
            super.undo();
            this.mergeCount = -1;
            if (editorPane != null) {
                editorPane.requestFocus();
                Selection mainSel = this.startSels.get(0);
                editorPane.setCaretPositionCenter(mainSel.getMark());
                editorPane.moveCaretPositionCenter(mainSel.getDot());
                if (this.startSels.size() > 1) {
                    editorPane.setMultiSelections(this.startSels.subList(1, this.startSels.size()));
                }
            }
        }
        finally {
            editorPane.setUndoInProgress(false);
        }
    }

    @Override
    public boolean canRedo() {
        Object editor;
        boolean canRedo = super.canRedo();
        if (canRedo && (editor = this.editorReference.get()) == null) {
            canRedo = false;
        }
        return canRedo;
    }

    @Override
    public void redo() throws CannotRedoException {
        BasicEditorPane editorPane = (BasicEditorPane)this.editorReference.get();
        editorPane.setUndoInProgress(true);
        try {
            super.redo();
            if (editorPane != null) {
                editorPane.requestFocus();
                Selection mainSel = this.endSels.get(0);
                editorPane.setCaretPositionCenter(mainSel.getMark());
                editorPane.moveCaretPositionCenter(mainSel.getDot());
                if (this.endSels.size() > 1) {
                    editorPane.setMultiSelections(this.endSels.subList(1, this.endSels.size()));
                }
            }
        }
        finally {
            editorPane.setUndoInProgress(false);
        }
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof NavigationEdit) {
            NavigationEdit secondEdit = (NavigationEdit)anEdit;
            if (this.editDescriptor.canMergeWith(secondEdit.editDescriptor)) {
                int maxCount;
                EditorProperties properties = EditorProperties.getProperties();
                Integer value = (Integer)properties.getProperty("navigation-merge-count");
                int n = maxCount = value != null ? value : 1;
                if (this.mergeCount != -1 && this.mergeCount < maxCount) {
                    this.endSels = secondEdit.endSels;
                    secondEdit.die();
                    ++this.mergeCount;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean replaceEdit(UndoableEdit anEdit) {
        return false;
    }

    @Override
    public void die() {
        super.die();
        this.editorReference = null;
    }

    @Override
    public String getPresentationName() {
        return this.editDescriptor.getEditName();
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Start: ");
        for (Selection sel : this.startSels) {
            s.append(sel.getDot()).append(", ").append(sel.getMark()).append(" | ");
        }
        s.append("\nEnd: ");
        for (Selection sel : this.endSels) {
            s.append(sel.getDot()).append(", ").append(sel.getMark()).append(" | ");
        }
        return s.toString();
    }

    @Override
    public boolean isSignificant() {
        return false;
    }
}

