/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import oracle.javatools.editor.BasicView;
import oracle.javatools.editor.highlight.HighlightFragment;
import oracle.javatools.editor.highlight.HighlightFragmentsList;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.StyledFragment;
import oracle.javatools.editor.language.StyledFragmentsList;

final class LineRenderFragmentGenerator
implements BasicView.RenderFragmentGenerator {
    private int _nextRenderOffset;
    private int _nextSyntaxIndex;
    private StyledFragment _syntaxFragment;
    private int _nextHighlightIndex;
    private HighlightFragment _highlightFragment;
    private StyledFragmentsList _syntaxFragmentsList;
    private HighlightFragmentsList _highlightFragmentsList;
    protected BasicView.RenderFragment _currentFragment = new BasicView.RenderFragment();
    protected BasicView _view;

    public LineRenderFragmentGenerator(StyledFragmentsList styledList, HighlightFragmentsList highlightList, BasicView basicView) {
        this._view = basicView;
        this._syntaxFragmentsList = styledList;
        this._highlightFragmentsList = highlightList;
        if (this._syntaxFragmentsList == null || this._highlightFragmentsList == null || this._syntaxFragmentsList.size() == 0) {
            this._currentFragment = null;
            return;
        }
        this._syntaxFragment = this._syntaxFragmentsList.get(this._nextSyntaxIndex++);
        this._nextRenderOffset = this._syntaxFragment.startOffset;
        if (this._nextHighlightIndex < this._highlightFragmentsList.size()) {
            this._highlightFragment = this._highlightFragmentsList.get(this._nextHighlightIndex++);
        }
        this.next();
    }

    @Override
    public BasicView.RenderFragment current() {
        return this._currentFragment;
    }

    @Override
    public BasicView.RenderFragment next() {
        if (this._currentFragment == null) {
            return null;
        }
        try {
            return this.nextImpl();
        }
        catch (IndexOutOfBoundsException e) {
            this._currentFragment = null;
            return this._currentFragment;
        }
    }

    protected BasicView.RenderFragment nextImpl() {
        String syntaxStyleName;
        BaseStyle syntaxStyle;
        if (this._syntaxFragment.endOffset <= this._nextRenderOffset) {
            this._syntaxFragment = this._syntaxFragmentsList.get(this._nextSyntaxIndex++);
        }
        if (this._syntaxFragment.startOffset > this._nextRenderOffset) {
            throw new IllegalStateException("gap in style fragments");
        }
        while (this._highlightFragment == null || this._highlightFragment.endOffset <= this._nextRenderOffset) {
            this._highlightFragment = null;
            int highlightFragmentsCount = this._highlightFragmentsList.size();
            if (this._nextHighlightIndex >= highlightFragmentsCount) break;
            this._highlightFragment = this._highlightFragmentsList.get(this._nextHighlightIndex++);
        }
        int processStart = Math.max(this._nextRenderOffset, this._syntaxFragment.startOffset);
        int processEnd = this._syntaxFragment.endOffset;
        HighlightFragment highlightFragmentToInclude = null;
        if (this._highlightFragment != null) {
            int highlightStart = this._highlightFragment.startOffset;
            int highlightEnd = this._highlightFragment.endOffset;
            if (processStart < highlightStart) {
                processEnd = Math.min(processEnd, highlightStart);
            } else {
                processEnd = Math.min(processEnd, highlightEnd);
                highlightFragmentToInclude = this._highlightFragment;
            }
        }
        if ((syntaxStyle = this._view.lookupStyle(syntaxStyleName = this._syntaxFragment.styleName)) == null) {
            throw new IllegalStateException("style not found: " + syntaxStyleName);
        }
        this._currentFragment.syntaxStyle = syntaxStyle;
        if (highlightFragmentToInclude != null) {
            this._currentFragment.backgroundHighlight = highlightFragmentToInclude.backgroundStyle;
            this._currentFragment.foregroundHighlight = highlightFragmentToInclude.foregroundStyle;
            this._currentFragment.fontHighlight = highlightFragmentToInclude.fontStyle;
        } else {
            this._currentFragment.backgroundHighlight = null;
            this._currentFragment.foregroundHighlight = null;
            this._currentFragment.fontHighlight = null;
        }
        this._currentFragment.startOffset = processStart;
        this._currentFragment.endOffset = processEnd;
        this._currentFragment.textToUse = null;
        this._nextRenderOffset = processEnd;
        return this._currentFragment;
    }
}

