/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPainter;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.Log;

public class BasicEditorUI
extends BasicEditorPaneUI {
    private static final Log LOG = new Log("expiration");
    private List<BasicEditorPainter> painterList = new CopyOnWriteArrayList<BasicEditorPainter>();

    private BasicEditorUI() {
    }

    List<BasicEditorPainter> getPainters() {
        return this.painterList;
    }

    public static ComponentUI createUI(JComponent component) {
        return new BasicEditorUI();
    }

    @Override
    public void installUI(JComponent component) {
        JTextComponent editor;
        super.installUI(component);
        if (component instanceof JTextComponent && (editor = (JTextComponent)component) instanceof BasicEditorPane) {
            Color caretColor;
            BasicEditorPane editorPane = (BasicEditorPane)editor;
            boolean enableBlink = editorPane.getBooleanProperty("caret-enable-blink");
            int blinkRate = enableBlink ? editorPane.getIntegerProperty("caret-blink-rate") : 0;
            Caret caret = editorPane.getCaret();
            if (caret != null) {
                caret.setBlinkRate(blinkRate);
            }
            if ((caretColor = (Color)editorPane.getProperty("caret-color")) != null) {
                editor.setCaretColor(caretColor);
            } else {
                editor.setCaretColor(Color.black);
            }
        }
    }

    @Override
    protected Caret createCaret() {
        BasicCaret caret = new BasicCaret();
        return caret;
    }

    @Override
    protected void paintBackground(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintSafely(Graphics g) {
        BasicEditorPane editor = (BasicEditorPane)this.getComponent();
        BasicDocument document = (BasicDocument)editor.getDocument();
        document.readLock();
        try {
            if (editor.isOpaque()) {
                g.setColor(editor.isEnabled() ? editor.getBackground() : editor.getDisabledBackgroundColor());
                Rectangle vRect = editor.getVisibleRect();
                g.fillRect(vRect.x, vRect.y, vRect.width, vRect.height);
            }
            super.paintSafely(g);
        }
        finally {
            document.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize(JComponent component) {
        BasicEditorPane editorPane = (BasicEditorPane)this.getComponent();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        Dimension size = null;
        document.readLock();
        try {
            size = super.getPreferredSize(component);
        }
        finally {
            document.readUnlock();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMinimumSize(JComponent component) {
        BasicEditorPane editorPane = (BasicEditorPane)this.getComponent();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        Dimension size = null;
        document.readLock();
        try {
            size = super.getMinimumSize(component);
        }
        finally {
            document.readUnlock();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMaximumSize(JComponent component) {
        BasicEditorPane editorPane = (BasicEditorPane)this.getComponent();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        Dimension size = null;
        document.readLock();
        try {
            size = super.getMaximumSize(component);
        }
        finally {
            document.readUnlock();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle modelToView(JTextComponent component, int offset, Position.Bias bias) throws BadLocationException {
        BasicEditorPane editorPane = (BasicEditorPane)this.getComponent();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        Rectangle locationRect = null;
        try {
            document.readLock();
            try {
                locationRect = super.modelToView(component, offset, bias);
            }
            finally {
                document.readUnlock();
            }
        }
        catch (ExpiredTextBufferException e) {
            LOG.trace("handled expiration in BasicEditoUI.modelToView: {0}", (Object)e);
            throw new BadLocationException(e.getMessage(), offset);
        }
        return locationRect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int viewToModel(JTextComponent component, Point point, Position.Bias[] biasReturn) {
        BasicEditorPane editorPane = (BasicEditorPane)this.getComponent();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        int offset = -1;
        document.readLock();
        try {
            offset = super.viewToModel(component, point, biasReturn);
        }
        finally {
            document.readUnlock();
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNextVisualPositionFrom(JTextComponent component, int offset, Position.Bias bias, int direction, Position.Bias[] biasRet) throws BadLocationException {
        BasicEditorPane editorPane = (BasicEditorPane)this.getComponent();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        int nextOffset = offset;
        document.readLock();
        try {
            nextOffset = super.getNextVisualPositionFrom(component, offset, bias, direction, biasRet);
        }
        finally {
            document.readUnlock();
        }
        return nextOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void damageRange(JTextComponent component, int startOffset, int endOffset, Position.Bias startOffsetBias, Position.Bias endOffsetBias) {
        BasicEditorPane editorPane = (BasicEditorPane)this.getComponent();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        document.readLock();
        try {
            super.damageRange(component, startOffset, endOffset, startOffsetBias, endOffsetBias);
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            document.readUnlock();
        }
    }

    public void addPainter(BasicEditorPainter painter) {
        if (!this.painterList.contains(painter)) {
            for (int i = 0; i < this.painterList.size(); ++i) {
                BasicEditorPainter p = this.painterList.get(i);
                if (p.getPriority() <= painter.getPriority()) continue;
                this.painterList.add(i, painter);
                return;
            }
            this.painterList.add(painter);
        }
    }

    public void removePainter(BasicEditorPainter painter) {
        this.painterList.remove(painter);
    }
}

