/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import oracle.ide.hover.Hover;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.overview.OverviewMark;
import oracle.javatools.ui.overview.OverviewMarkRenderingHints;
import oracle.javatools.util.Disposable;

public class BasicEditorOverviewMark
implements OverviewMark<Integer>,
Disposable,
OverviewMarkRenderingHints {
    private final int originalStartOffset;
    private final int originalEndOffset;
    private final OffsetMark startOffset;
    private final OffsetMark endOffset;
    private final Color color;
    private final float priority;
    private final BasicEditorPane editor;
    private final boolean isStationary;
    private final boolean autoRemove;
    private final Map<OverviewMarkRenderingHints.Hint, Object> hints = new HashMap<OverviewMarkRenderingHints.Hint, Object>();

    public BasicEditorOverviewMark(BasicEditorPane editor, Integer startOffset, Integer endOffset, float priority, Color color) {
        this(editor, startOffset, endOffset, priority, color, false);
    }

    public BasicEditorOverviewMark(BasicEditorPane editor, Integer startOffset, Integer endOffset, float priority, Color color, boolean isStationary) {
        this(editor, startOffset, endOffset, priority, color, isStationary, false);
    }

    public BasicEditorOverviewMark(BasicEditorPane editor, Integer startOffset, Integer endOffset, float priority, Color color, boolean isStationary, boolean autoRemove) {
        this.color = color;
        this.editor = editor;
        this.priority = priority;
        this.originalStartOffset = startOffset;
        this.originalEndOffset = endOffset;
        this.isStationary = isStationary;
        if (!isStationary) {
            this.startOffset = editor.getTextBuffer().addOffsetMark(startOffset.intValue());
            this.endOffset = editor.getTextBuffer().addOffsetMark(endOffset.intValue());
        } else {
            this.startOffset = null;
            this.endOffset = null;
        }
        this.autoRemove = autoRemove;
    }

    private Integer getRow(int offset) {
        int line = this.editor.getLineFromOffset(offset);
        int row = this.editor.getRowForLine(line);
        return row;
    }

    public Integer getStart() {
        Integer location = this.getRow(this.getStartOffset());
        return location;
    }

    public Integer getEnd() {
        Integer location = this.getRow(this.getEndOffset());
        return location;
    }

    public Integer getStartOffset() {
        return this.isStationary ? this.originalStartOffset : this.startOffset.getOffset();
    }

    public Integer getEndOffset() {
        return this.isStationary ? this.originalEndOffset : this.endOffset.getOffset();
    }

    public Color getColor() {
        return this.color;
    }

    public float getPriority() {
        return this.priority;
    }

    public void dispose() {
        if (!this.isStationary) {
            this.editor.getTextBuffer().removeOffsetMark(this.startOffset);
            this.editor.getTextBuffer().removeOffsetMark(this.endOffset);
        }
    }

    boolean isAutoRemove() {
        return this.autoRemove;
    }

    protected JComponent getTipComponent(Hover hover) {
        return null;
    }

    public int compareTo(OverviewMark o) {
        BasicEditorOverviewMark mark = (BasicEditorOverviewMark)o;
        if (this.getPriority() > o.getPriority()) {
            return 1;
        }
        if (this.getPriority() < o.getPriority()) {
            return -1;
        }
        if (this.getStartOffset().doubleValue() == mark.getStartOffset().doubleValue()) {
            return 0;
        }
        if (this.getStartOffset().doubleValue() < mark.getStartOffset().doubleValue()) {
            return -1;
        }
        return 1;
    }

    public Object getValue(OverviewMarkRenderingHints.Hint hint) {
        return this.hints.get(hint);
    }

    public void putValue(OverviewMarkRenderingHints.Hint hint, Object value) {
        this.hints.put(hint, value);
    }
}

