/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs.progress;

import java.awt.Component;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import oracle.javatools.dialogs.progress.AbstractProgressMonitor;

public class IndeterminateProgressMonitor
extends AbstractProgressMonitor {
    private final Lock _threadLock = new ReentrantLock();
    private boolean _started;
    private DelayThread _delayThread;

    public IndeterminateProgressMonitor(Component parent, String title) {
        this(parent, title, null, null);
    }

    public IndeterminateProgressMonitor(Component parent, String title, Object message, String note) {
        super(parent, title, message, note);
    }

    @Override
    public void startImpl() {
        if (this._started) {
            return;
        }
        this._started = true;
        int millisToPopup = this.getMillisToPopup();
        if (millisToPopup <= 0) {
            this.display();
            return;
        }
        this._delayThread = new DelayThread(millisToPopup){

            @Override
            protected final void runDelayed() {
                IndeterminateProgressMonitor.this.display();
            }
        };
        this._delayThread.start();
    }

    @Override
    protected JProgressBar createProgressBar() {
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        return progressBar;
    }

    @Override
    protected void displayImpl() {
        super.displayImpl();
        this.stop();
    }

    @Override
    protected void finishImpl(JProgressBar progressBar) {
        super.finishImpl(progressBar);
        this.stop();
        if (progressBar == null) {
            return;
        }
        progressBar.setIndeterminate(false);
        progressBar.setValue(progressBar.getMaximum());
    }

    @Override
    protected void closeImpl() {
        super.closeImpl();
        this.stop();
    }

    private void stop() {
        this._threadLock.lock();
        try {
            if (this._delayThread == null) {
                return;
            }
            this._delayThread.exit();
            this._delayThread = null;
        }
        finally {
            this._threadLock.unlock();
        }
    }

    public static void main(String[] argv) throws Exception {
        JFrame frame = new JFrame();
        frame.setSize(0, 0);
        frame.setVisible(true);
        IndeterminateProgressMonitor monitor = new IndeterminateProgressMonitor(frame, "IndeterminateProgressMonitor");
        monitor.setMillisToPopup(0);
        monitor.start();
        monitor.setCloseOnFinish(false);
        Thread.sleep(2000L);
        monitor.finish();
    }

    private static abstract class DelayThread
    extends Thread {
        private final int _millisToPopup;
        private boolean _exit;

        DelayThread(int millisToPopup) {
            this._millisToPopup = millisToPopup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                DelayThread delayThread = this;
                synchronized (delayThread) {
                    this.wait(this._millisToPopup);
                }
                Thread.yield();
                delayThread = this;
                synchronized (delayThread) {
                    if (this._exit) {
                        return;
                    }
                }
                this.runDelayed();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void exit() {
            DelayThread delayThread = this;
            synchronized (delayThread) {
                this._exit = true;
                this.notify();
            }
        }

        protected abstract void runDelayed();
    }
}

