/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.javatools.controls.HyperlinkButton;

public class MessagePanel
extends JComponent
implements Accessible {
    private JLabel m_icon;
    private JPanel m_msgArea;
    private JTextArea m_text;
    private MultiLineLabel m_titleLabel;
    public static final int TYPE_APPLICATION_ERROR = 1;
    public static final int TYPE_INFORMATION = 2;
    public static final int TYPE_ALERT = 3;
    public static final int TYPE_CONFIRMATION = 4;
    private static final int BORDER_INSET = 5;
    private static final int ICON_TEXT_GAP = 20;
    private static final int HORIZONTAL_STRUT = 350;
    private boolean m_hasComponents = false;
    private JPanel m_componentPanel;

    public MessagePanel() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.m_icon = new JLabel();
        this.m_text = new JTextArea(){

            @Override
            public void addNotify() {
                super.addNotify();
                Timer t = new Timer(500, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if (MessagePanel.this.m_text != null && MessagePanel.this.m_text.isShowing()) {
                            MessagePanel.this.m_text.setFocusable(true);
                        }
                    }
                });
                t.setRepeats(false);
                t.start();
            }
        };
        this.m_text.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                MessagePanel.this.m_text.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                MessagePanel.this.m_text.select(0, 0);
            }
        });
        this.m_text.setBorder(null);
        this.m_text.setEditable(false);
        this.m_text.setFocusable(false);
        this.m_text.setOpaque(false);
        this.m_text.setWrapStyleWord(true);
        this.m_text.setFont(UIManager.getFont("Label.font"));
        this.m_text.setForeground(UIManager.getColor("Label.foreground"));
        this.m_msgArea = new JPanel();
        this.m_msgArea.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        this.m_msgArea.setOpaque(false);
        this.m_titleLabel = new MultiLineLabel();
        this.m_titleLabel.setTextWrapper(WordWrapper.getTextWrapper());
        this.m_titleLabel.setPreferredAspectRatio(5.0f);
        this.m_titleLabel.setVisible(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_icon, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 20), 0, 0));
        this.add((Component)this.m_titleLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.m_msgArea, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)panel, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 350, 0));
        this.setName("MessagePanel");
        this.m_icon.setName("MessagePanelIcon");
        this.m_msgArea.setName("MessageArea");
        this.m_text.setName("MessageText");
        this.m_titleLabel.setName("MessageTitleLabel");
    }

    public void setTitle(String title) {
        this.m_titleLabel.setVisible(true);
        Font f = this.m_titleLabel.getFont();
        f = f.deriveFont(1);
        this.m_titleLabel.setFont(f);
        this.m_titleLabel.setText(title);
        this.validate();
    }

    public void addMessageComponent(Component component) {
        if (component == null) {
            throw new NullPointerException("component is null");
        }
        if (!this.m_hasComponents) {
            this.m_componentPanel = new JPanel();
            this.m_componentPanel.setOpaque(false);
            this.m_componentPanel.setLayout(new BoxLayout(this.m_componentPanel, 1));
            JPanel padding = new JPanel();
            padding.setOpaque(false);
            padding.setPreferredSize(new Dimension(5, 5));
            this.m_componentPanel.add(padding);
            this.m_msgArea.add((Component)this.m_componentPanel, "South");
            this.m_hasComponents = true;
        }
        Box mybox = Box.createHorizontalBox();
        mybox.add(component);
        mybox.add(Box.createHorizontalGlue());
        this.m_componentPanel.add(mybox);
    }

    public void addHyperAction(Action action) {
        if (action == null) {
            throw new NullPointerException("action is null");
        }
        this.addMessageComponent((Component)((Object)new HyperlinkButton(action)));
    }

    public void setMessage(Object message) {
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        if (message instanceof Component) {
            this.m_msgArea.add((Component)message, "Center");
        } else {
            this.setMessageText(message.toString());
        }
    }

    public void setMessageText(String message) {
        int width;
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        this.getAccessibleContext().setAccessibleName(message);
        if (message.startsWith("<html>")) {
            JLabel l = new JLabel(message);
            l.setMaximumSize(new Dimension(20, 0));
            this.setMessage(l);
            return;
        }
        this.m_msgArea.add((Component)this.m_text, "Center");
        this.m_text.setText(message);
        this.m_text.setPreferredSize(null);
        this.m_text.setLineWrap(false);
        Dimension d = this.m_text.getPreferredSize();
        this.m_text.setLineWrap(true);
        d.width = width = (int)Math.sqrt(d.getHeight() * d.getWidth() * 5.0) + 1;
        d.height = 100000;
        this.m_text.setSize(d);
        d = this.m_text.getPreferredSize();
        this.m_text.setPreferredSize(d);
    }

    public void setMessageType(int type) {
        this.m_icon.setVisible(true);
        switch (type) {
            case 1: {
                this.m_icon.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
                break;
            }
            case 2: {
                this.m_icon.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
                break;
            }
            case 3: {
                this.m_icon.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
                break;
            }
            case 4: {
                this.m_icon.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
                break;
            }
            default: {
                this.m_icon.setVisible(false);
            }
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMessagePane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleMessagePane
    extends JComponent.AccessibleJComponent {
        protected AccessibleMessagePane() {
            super(MessagePanel.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ALERT;
        }
    }
}

