/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.DataTransferPlugin;

public abstract class AbstractTransformingDataTransferPlugin
extends DataTransferPlugin {
    private final Set _sourceInfosAlreadySeen = new HashSet(13);

    @Override
    public final boolean augmentIfDesired(AugmentableTransferable trans) {
        ArrayList origSourceInfos = trans.getDataInfos(this.getSourceFlavor());
        int numUnseenSourceInfos = origSourceInfos.size() - this._sourceInfosAlreadySeen.size();
        assert (numUnseenSourceInfos >= 0);
        if (numUnseenSourceInfos > 0) {
            ArrayList newSourceInfos;
            if (this._sourceInfosAlreadySeen.isEmpty()) {
                newSourceInfos = origSourceInfos;
            } else {
                newSourceInfos = new ArrayList(numUnseenSourceInfos);
                for (Object next : origSourceInfos) {
                    if (this._sourceInfosAlreadySeen.contains(next)) continue;
                    newSourceInfos.add(next);
                }
            }
            this.augmentImpl(trans, newSourceInfos);
            this._sourceInfosAlreadySeen.addAll(newSourceInfos);
        }
        return false;
    }

    protected abstract void augmentImpl(AugmentableTransferable var1, Collection var2);

    protected abstract DataFlavor getSourceFlavor();

    protected AbstractTransformingDataTransferPlugin() {
    }
}

