/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.nicelist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.imageCanvas.ImageCanvas;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.resource.ControlsBundle;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.ui.themes.LinearGradientPainter;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.ModelUtil;

public abstract class NiceListRenderer<T>
extends JPanel
implements ListCellRenderer {
    private Color _gradientLightColor;
    private Color _gradientDarkColor;
    private Color _selectedForegroundColor = null;
    private Color _unselectedForegroundColor = Color.BLACK;
    private Painter _selectedPainter = this.createSelectionPainter();
    private JToggleButton _checkBox = new JCheckBox();
    private final JLabel _titleLabel = new JLabel();
    private final RichHintLabel _descriptionLabel = new RichHintLabel();
    private final RichHintLabel _descriptionLabel2 = new RichHintLabel();
    private final JPanel _indicatorsPanel = new JPanel();
    private final JLabel _indicatorLabel = new JLabel();
    private final ImageCanvas _imageLabel = new MinImageCanvas();
    private final HyperlinkButton _hyperlink = new HyperlinkButton();
    private final HyperlinkButton _secondaryHyperlink = new HyperlinkButton();
    private boolean _selected;
    private T _currentValueT;
    private static final Color BACKGROUND_COLOR = new Color(251, 251, 251);
    private static final Color _BANDING_BG_COLOR = new Color(250, 250, 250);
    private StyleSheet _sNiceStyle;
    private boolean _twoLineDescription = false;
    private AccessibleContext _accessibleContext;
    private final Border _itemBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 0, 1), BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(200, 200, 200)));
    private final Border _selectedItemBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("Tree.selectionBorderColor"));
    private boolean _layoutDone;

    private void layoutComponents() {
        if (!this._layoutDone) {
            this._layoutDone = true;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(5, 5, 5, 0);
            this.add((Component)this._checkBox, gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 5, 0);
            this.add((Component)this._titleLabel, gbc);
            ++gbc.gridx;
            gbc.weightx = 0.0;
            gbc.anchor = 13;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this._indicatorsPanel, gbc);
            this._indicatorsPanel.setOpaque(false);
            ++gbc.gridx;
            gbc.gridheight = 0;
            gbc.anchor = 12;
            gbc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this._imageLabel, gbc);
            ++gbc.gridy;
            gbc.gridx = 1;
            gbc.gridheight = 1;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 2, 5);
            this.add((Component)this._descriptionLabel, gbc);
            ++gbc.gridx;
            gbc.anchor = 12;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.insets = new Insets(0, 5, 2, 0);
            this.add((Component)((Object)this._hyperlink), gbc);
            ++gbc.gridy;
            gbc.gridx = 1;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(0, 5, 2, 5);
            this.add((Component)this._descriptionLabel2, gbc);
            this._descriptionLabel2.setVisible(this._twoLineDescription);
            ++gbc.gridx;
            gbc.anchor = 12;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.insets = new Insets(0, 5, 2, 5);
            this.add((Component)((Object)this._secondaryHyperlink), gbc);
            this._titleLabel.setFont(this._titleLabel.getFont().deriveFont(1));
            this._checkBox.setOpaque(false);
            this._checkBox.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(this._itemBorder);
            this.setOpaque(false);
            this.updateUI();
            this._indicatorsPanel.setLayout(new BoxLayout(this._indicatorsPanel, 0));
            this._indicatorsPanel.add(this._indicatorLabel);
            StyleSheet styles = ((HTMLEditorKit)this._descriptionLabel.getEditorKit()).getStyleSheet();
            styles.addStyleSheet(this._sGetNiceStyles());
            styles = ((HTMLEditorKit)this._descriptionLabel2.getEditorKit()).getStyleSheet();
            styles.addStyleSheet(this._sGetNiceStyles());
        }
    }

    public final void setRadioButtonStyle(boolean radioButtonStyle) {
        if (this.isRadioButtonStyle() != radioButtonStyle) {
            JToggleButton jToggleButton = this._checkBox = radioButtonStyle ? new JRadioButton() : new JCheckBox();
            if (this._layoutDone) {
                this._layoutDone = false;
                this.removeAll();
            }
        }
    }

    private Painter createSelectionPainter() {
        if (this._gradientLightColor == null) {
            if (Themes.isThemed()) {
                this._gradientLightColor = Colors.GRADIENT_SELECTION_LIGHT;
                this._gradientDarkColor = Colors.GRADIENT_SELECTION_DARK;
            } else {
                this._gradientDarkColor = this._gradientLightColor = UIManager.getColor("List.selectionBackground");
            }
        }
        return new LinearGradientPainter(this._gradientLightColor, this._gradientDarkColor, 1);
    }

    public final boolean isRadioButtonStyle() {
        return this._checkBox instanceof JRadioButton;
    }

    public final void setGradientColor(Color light, Color dark) {
        if (light == null) {
            throw new NullPointerException("light is null");
        }
        if (dark == null) {
            throw new NullPointerException("dark is null");
        }
        this._gradientLightColor = light;
        this._gradientDarkColor = dark;
        this._selectedPainter = this.createSelectionPainter();
    }

    public final void setSelectedForeground(Color color) {
        if (color == null) {
            throw new NullPointerException("color must not be null");
        }
        this._selectedForegroundColor = color;
    }

    public final void setUnselectedForeground(Color color) {
        if (color == null) {
            throw new NullPointerException("color must not be null");
        }
        this._unselectedForegroundColor = color;
    }

    public final void setTwoLineDescription(boolean twoLine) {
        this._twoLineDescription = twoLine;
        this._descriptionLabel2.setVisible(twoLine);
        this.invalidate();
        this.validate();
    }

    final int testCheckBoxHit(JList list, Point mousePoint) {
        return this.getRendererRow(list, mousePoint, this._checkBox);
    }

    final int testHyperLinkHit(JList list, Point mousePoint) {
        return this.getRendererRow(list, mousePoint, (Component)((Object)this._hyperlink));
    }

    final int testSecondaryHyperLinkHit(JList list, Point mousePoint) {
        return this.getRendererRow(list, mousePoint, (Component)((Object)this._secondaryHyperlink));
    }

    private int getRendererRow(JList list, Point mousePoint, Component c) {
        int row = list.locationToIndex(mousePoint);
        if (row >= 0) {
            Point rowOrigin = list.indexToLocation(row);
            Point rendererPoint = new Point(mousePoint.x - rowOrigin.x, mousePoint.y - rowOrigin.y);
            this.getListCellRendererComponent(list, list.getModel().getElementAt(row), row, false, true);
            if (c.getBounds().contains(rendererPoint)) {
                return row;
            }
        }
        return -1;
    }

    @Override
    public final void paintComponent(Graphics g) {
        if (this._selected) {
            this._selectedPainter.paint(g, 0, 0, this.getWidth(), this.getHeight());
        } else {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g);
    }

    public final Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Insets inset;
        int preferredWidth;
        Color fg;
        this._currentValueT = value;
        if (!SwingUtilities.isEventDispatchThread()) {
            return this;
        }
        this.layoutComponents();
        this._selected = list.isEnabled() && isSelected;
        this.setBorder(this._selected && cellHasFocus ? this._selectedItemBorder : this._itemBorder);
        if (list.isEnabled()) {
            if (this._selected) {
                if (this._selectedForegroundColor == null) {
                    this._selectedForegroundColor = Themes.isThemed() ? Color.BLACK : UIManager.getColor("List.selectionForeground");
                }
                fg = this._selectedForegroundColor;
            } else {
                fg = this._unselectedForegroundColor;
            }
        } else {
            fg = UIManager.getColor("textInactiveText");
        }
        this._titleLabel.setForeground(fg);
        Object valueT = value;
        this._titleLabel.setText(this.getTitle(valueT));
        String para = "<p>";
        if (this._selected) {
            para = "<p class=niceselected>";
        } else if (!list.isEnabled()) {
            para = "<p class=nicedisabled>";
        }
        String description = this.getDescription(valueT);
        if (description == null || description.length() == 0) {
            this._descriptionLabel.setVisible(false);
        } else {
            this._descriptionLabel.setText(para + description);
            this._descriptionLabel.setVisible(true);
        }
        String seconDaryDes = this.getSecondDescription(valueT);
        if (seconDaryDes == null || seconDaryDes.length() == 0) {
            this._descriptionLabel2.setVisible(false);
        } else {
            this._descriptionLabel2.setText(para + seconDaryDes);
            this._descriptionLabel2.setVisible(this._twoLineDescription);
        }
        this._checkBox.setSelected(this.isItemSelected(valueT));
        this._checkBox.setEnabled(list.isEnabled());
        this._checkBox.setVisible(this.isCheckable(valueT));
        String link = this.getHyperLinkText(valueT);
        if (link != null && link.length() > 0) {
            this._hyperlink.setVisible(true);
            this._hyperlink.setText(link);
        } else {
            this._hyperlink.setVisible(false);
        }
        String secondaryLink = this.getSecondaryHyperLinkText(valueT);
        if (secondaryLink != null && secondaryLink.length() > 0) {
            this._secondaryHyperlink.setVisible(true);
            this._secondaryHyperlink.setText(secondaryLink);
        } else {
            this._secondaryHyperlink.setVisible(false);
        }
        Icon indicator = this.getIndicator(valueT);
        this._indicatorLabel.setIcon(indicator);
        Image image = this.getImage(valueT);
        this._imageLabel.setVisible(image != null);
        this._imageLabel.setImage(image);
        if (list.isEnabled()) {
            Color bgcolor = this.getBackgroundColor(valueT);
            if (BACKGROUND_COLOR.equals(bgcolor)) {
                bgcolor = index % 2 == 0 ? SystemColor.WHITE : _BANDING_BG_COLOR;
            }
            this.setBackground(bgcolor);
        } else {
            this.setBackground(UIManager.getColor("control"));
        }
        this._descriptionLabel.setSize(0, 0);
        this._descriptionLabel2.setSize(0, 0);
        this.setPreferredSize(null);
        Container parent = list.getParent();
        if (parent != null && parent instanceof JViewport) {
            preferredWidth = ((JViewport)parent).getExtentSize().width;
            inset = ((JViewport)parent).getInsets();
            preferredWidth -= inset.left + inset.right;
        } else {
            preferredWidth = list.getWidth();
            inset = list.getInsets();
            preferredWidth -= inset.left + inset.right;
        }
        if (preferredWidth > 0) {
            int originalDescWidth;
            int minWidth = this._calculateMinimumWidth();
            int descWidth = this._calculateDescriptionWidth(preferredWidth);
            if (descWidth < (originalDescWidth = Math.max(this._descriptionLabel.getPreferredSize().width, this._descriptionLabel2.getPreferredSize().width))) {
                descWidth = Math.max(descWidth, 100);
                this._descriptionLabel.setSize(descWidth, this._descriptionLabel.getPreferredSize().height);
                this._descriptionLabel2.setSize(descWidth, this._descriptionLabel2.getPreferredSize().height);
            }
            this.setPreferredSize(new Dimension(preferredWidth, this.getPreferredSize().height));
            preferredWidth = Math.max(preferredWidth, minWidth);
            if (list.getFixedCellWidth() != preferredWidth) {
                list.setFixedCellWidth(preferredWidth);
            }
        }
        return this;
    }

    protected Color getBackgroundColor(T listItem) {
        return BACKGROUND_COLOR;
    }

    public final String getText() {
        return this._titleLabel.getText();
    }

    protected abstract String getTitle(T var1);

    protected abstract String getDescription(T var1);

    protected String getSecondDescription(T listItem) {
        return null;
    }

    protected abstract boolean isItemSelected(T var1);

    protected String getHyperLinkText(T listItem) {
        return "";
    }

    protected String getSecondaryHyperLinkText(T listItem) {
        return "";
    }

    protected Icon getIndicator(T listItem) {
        return null;
    }

    protected Image getImage(T listItem) {
        return null;
    }

    protected boolean isCheckable(T listItem) {
        return true;
    }

    private StyleSheet _sGetNiceStyles() {
        if (this._sNiceStyle == null) {
            this._sNiceStyle = new StyleSheet();
            String s = "p.niceselected { color: " + ColorUtils.colorToHTML((Color)(Themes.isThemed() ? Color.BLACK : UIManager.getColor("List.selectionForeground"))) + ";}";
            this._sNiceStyle.addRule(s);
            s = "p.nicedisabled { color: " + ColorUtils.colorToHTML((Color)UIManager.getColor("textInactiveText")) + ";}";
            this._sNiceStyle.addRule(s);
        }
        return this._sNiceStyle;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = new AccessibleNiceListRenderer();
        }
        return this._accessibleContext;
    }

    private int _calculateDescriptionWidth(int width) {
        int remainingWidth = this.getPreferredSize().width;
        return width -= (remainingWidth -= Math.max(this._descriptionLabel.getPreferredSize().width, this._descriptionLabel2.getPreferredSize().width));
    }

    private int _calculateMinimumWidth() {
        int width = this.getPreferredSize().width;
        int remainingWidth = Math.max(this._descriptionLabel.getPreferredSize().width, this._descriptionLabel2.getPreferredSize().width);
        width -= remainingWidth;
        return width += Math.min(100, remainingWidth);
    }

    private class AccessibleNiceListRenderer
    extends JComponent.AccessibleJComponent {
        private AccessibleNiceListRenderer() {
            super(NiceListRenderer.this);
        }

        @Override
        public String getAccessibleName() {
            StringBuffer sb = new StringBuffer();
            String str = NiceListRenderer.this.getTitle(NiceListRenderer.this._currentValueT);
            if (ModelUtil.hasLength((String)str)) {
                sb.append(str);
            }
            if (ModelUtil.hasLength((String)(str = NiceListRenderer.this.getDescription(NiceListRenderer.this._currentValueT)))) {
                sb.append(" ");
                sb.append(str);
            }
            if (ModelUtil.hasLength((String)(str = NiceListRenderer.this.getSecondDescription(NiceListRenderer.this._currentValueT)))) {
                sb.append(" ");
                sb.append(str);
            }
            if (NiceListRenderer.this.isCheckable(NiceListRenderer.this._currentValueT)) {
                boolean ischecked = NiceListRenderer.this.isItemSelected(NiceListRenderer.this._currentValueT);
                sb.append(" ");
                sb.append(AccessibleRole.CHECK_BOX.toDisplayString());
                sb.append(" ");
                sb.append(ischecked ? ControlsBundle.get("CHECKED_STATE") : ControlsBundle.get("UNCHECKED_STATE"));
            }
            return sb.toString();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (NiceListRenderer.this.isFocusOwner()) {
                states.add(AccessibleState.FOCUSED);
            }
            if (NiceListRenderer.this.isItemSelected(NiceListRenderer.this._currentValueT)) {
                if (!states.contains(AccessibleState.CHECKED)) {
                    states.add(AccessibleState.CHECKED);
                }
            } else if (states.contains(AccessibleState.CHECKED)) {
                states.remove(AccessibleState.CHECKED);
            }
            return states;
        }
    }

    private class MinImageCanvas
    extends ImageCanvas {
        private MinImageCanvas() {
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }
}

