/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.VolatileImage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import oracle.javatools.editor.BasicEditorPane;

public class EditorPeekPopup {
    private static EditorPeekPopup _diffPop;
    private static JPanel _popComponent;
    private static Color[] _markColor;
    private static Color _backgroundColor;
    private static Color _foregroundColor;
    private static String[] _text;
    private static BufferedImage _renderImage;
    private static boolean _isLeft;
    private static Point _topPoint;
    private static Point _bottomPoint;
    private static final int BORDER_SIZE = 1;
    private static final int CONNECTOR_WIDTH = 25;
    private static final int SHADOW_SIZE = 5;
    private static Dimension _textSize;
    public static boolean editorPeek;
    private static WeakReference _keyRef;

    private EditorPeekPopup() {
        _popComponent = new PopupPanel();
        _popComponent.setFont(UIManager.getFont("TitledBorder.font").deriveFont(2));
        _popComponent.setLayout(new BorderLayout());
        _popComponent.setBorder(BorderFactory.createEmptyBorder(1, 6, 6, 1));
    }

    public static void showPopup(Object key, BasicEditorPane editorPane, String[] text, Rectangle sourceRect, int startLine, int endLine, int lineHeight, Color[] backgroundColors, int fadeAmount, int minimumSize) {
        Window window = SwingUtilities.getWindowAncestor(editorPane);
        if (window == null) {
            throw new IllegalArgumentException("DiffPopup.showPop(...) must be passed an editor pane contained in a window");
        }
        if (!(window instanceof RootPaneContainer)) {
            throw new IllegalArgumentException("DiffPopup.showPop(...) must be passed an editor pane contained in a window type that extends RootPaneContainer");
        }
        EditorPeekPopup.showPopup(key, (RootPaneContainer)((Object)window), editorPane, text, sourceRect, startLine, endLine, lineHeight, backgroundColors, fadeAmount, minimumSize);
    }

    public static void showPopup(Object key, RootPaneContainer window, BasicEditorPane editorPane, String[] text, Rectangle sourceRect, int startLine, int endLine, int lineHeight, Color[] backgroundColors, int fadeAmount, int minimumSize) {
        if (_keyRef != null && _keyRef.get() == key) {
            return;
        }
        _keyRef = new WeakReference<Object>(key);
        EditorPeekPopup.showPopup(window.getLayeredPane(), text, sourceRect, editorPane, startLine, endLine, lineHeight, backgroundColors, fadeAmount, minimumSize);
    }

    public static void showPopup(Object key, BasicEditorPane editorPane, String text, Rectangle sourceRect, int startLine, int endLine, int lineHeight, Color backgroundColor, int fadeAmount, int minimumSize) {
        String[] stringArray;
        if (text == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = text;
        }
        String[] textArray = stringArray;
        EditorPeekPopup.showPopup(key, editorPane, textArray, sourceRect, startLine, endLine, lineHeight, new Color[]{backgroundColor}, fadeAmount, minimumSize);
    }

    private static void showPopup(JLayeredPane layerPane, String[] text, Rectangle sourceRect, BasicEditorPane editorPane, int startLine, int endLine, int lineHeight, Color[] markColors, int fadeAmount, int minSize) {
        int windowx;
        if (_diffPop == null) {
            _diffPop = new EditorPeekPopup();
        }
        _isLeft = sourceRect.x - (windowx = layerPane.getLocationOnScreen().x) < windowx + layerPane.getWidth() - (sourceRect.x + sourceRect.width);
        _topPoint = !_isLeft ? new Point(sourceRect.x, sourceRect.y) : new Point(sourceRect.x + sourceRect.width, sourceRect.y);
        _bottomPoint = !_isLeft ? new Point(sourceRect.x, sourceRect.y + sourceRect.height) : new Point(sourceRect.x + sourceRect.width, sourceRect.y + sourceRect.height);
        _text = text;
        Point topPointInLayerPane = (Point)_topPoint.clone();
        Point bottomPointInLayerPane = (Point)_bottomPoint.clone();
        SwingUtilities.convertPointFromScreen(topPointInLayerPane, layerPane);
        SwingUtilities.convertPointFromScreen(bottomPointInLayerPane, layerPane);
        int minConnectorHeight = EditorPeekPopup._bottomPoint.y - EditorPeekPopup._topPoint.y;
        int halfLine = (int)((float)lineHeight * 0.5f);
        int startRow = editorPane.getRowForLine(startLine);
        int endRow = editorPane.getRowForLine(endLine);
        int leftTrim = EditorPeekPopup._getTrimWidth(editorPane, startLine, endLine, true);
        int rightTrim = EditorPeekPopup._getTrimWidth(editorPane, startLine, endLine, false);
        if (startRow == endRow) {
            --startRow;
            leftTrim = 0;
        }
        int diffY = startRow * lineHeight + halfLine;
        int diffHeight = (endRow + 2) * lineHeight - diffY - halfLine + 1;
        Rectangle renderRect = new Rectangle(0, diffY, editorPane.getWidth(), diffHeight);
        renderRect.x = leftTrim;
        renderRect.width = renderRect.width - leftTrim - rightTrim;
        int widthAvailable = _isLeft ? layerPane.getWidth() - topPointInLayerPane.x : topPointInLayerPane.x;
        widthAvailable -= 40;
        if (minSize > -1) {
            renderRect.width = Math.max(renderRect.width, minSize);
        }
        renderRect.width = Math.min(renderRect.width, widthAvailable);
        _foregroundColor = editorPane.getForeground();
        _backgroundColor = editorPane.getBackground();
        int maxSize = layerPane.getHeight() - 60;
        renderRect.height = Math.min(renderRect.height, maxSize);
        if (_text != null && _text.length > 0) {
            int lineW;
            int line;
            _markColor = new Color[_text.length];
            for (int i = 0; i < _text.length; ++i) {
                EditorPeekPopup._markColor[i] = i < markColors.length && markColors[i] != null ? new Color(markColors[i].getRed(), markColors[i].getGreen(), markColors[i].getBlue(), 85) : Color.WHITE;
            }
            int w = 0;
            for (line = 0; line < _text.length; ++line) {
                if (_text[line] == null || _text[line].trim().length() == 0) continue;
                lineW = SwingUtilities.computeStringWidth(_popComponent.getFontMetrics(_popComponent.getFont()), _text[line]);
                w = Math.max(w, lineW + 4);
            }
            _textSize = new Dimension(w, _popComponent.getFontMetrics(_popComponent.getFont()).getHeight() * _text.length);
            renderRect.width = Math.min(renderRect.width, EditorPeekPopup._textSize.width + 4);
            for (line = 0; line < _text.length; ++line) {
                lineW = SwingUtilities.computeStringWidth(_popComponent.getFontMetrics(_popComponent.getFont()), _text[line]) + 2;
                if (lineW <= renderRect.width) continue;
                String newLine = _text[line];
                while (lineW > renderRect.width && (newLine = newLine.substring(0, newLine.length() - 1)).length() != 0) {
                    lineW = SwingUtilities.computeStringWidth(_popComponent.getFontMetrics(_popComponent.getFont()), newLine + "...") + 2;
                }
                EditorPeekPopup._text[line] = newLine + "...";
            }
        } else {
            _textSize = new Dimension(0, 0);
        }
        if (renderRect.width <= 0 || renderRect.height <= 0) {
            EditorPeekPopup.hidePopup(true);
            return;
        }
        _renderImage = new BufferedImage(renderRect.width, renderRect.height, 2);
        Graphics2D topG = (Graphics2D)_renderImage.getGraphics();
        Image compImage = EditorPeekPopup._getImage(editorPane, renderRect);
        topG.drawImage(compImage, 0, 0, renderRect.width, renderRect.height, 0, 0, renderRect.width, renderRect.height, null);
        Dimension prefSize = new Dimension(0, 0);
        int imageHeight = 0;
        if (startLine == endLine) {
            _renderImage = null;
            prefSize.width = 31 + EditorPeekPopup._textSize.width + 4;
            prefSize.height = 6 + EditorPeekPopup._textSize.height;
        } else {
            prefSize = new Dimension(_renderImage.getWidth(), _renderImage.getHeight());
            prefSize.width += 31;
            prefSize.height += 7 + EditorPeekPopup._textSize.height;
            topG.setComposite(AlphaComposite.getInstance(6));
            topG.setPaint(new GradientPaint(0.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, 0.0f), 0.0f, fadeAmount * 4, new Color(0.0f, 0.0f, 0.0f, 1.0f)));
            topG.fillRect(0, 0, _renderImage.getWidth(), fadeAmount * 4);
            if (_renderImage.getHeight() < maxSize) {
                topG.setPaint(new GradientPaint(0.0f, _renderImage.getHeight() - fadeAmount * 4, new Color(0.0f, 0.0f, 1.0f, 1.0f), 0.0f, _renderImage.getHeight(), new Color(0.0f, 1.0f, 0.0f, 0.0f)));
                topG.fillRect(0, _renderImage.getHeight() - fadeAmount * 4, _renderImage.getWidth(), fadeAmount * 4);
            }
            topG.dispose();
            imageHeight = _renderImage.getHeight();
        }
        prefSize.height = Math.max(prefSize.height, minConnectorHeight);
        _popComponent.setSize(prefSize);
        int y = 0;
        y = prefSize.height > EditorPeekPopup._bottomPoint.y - EditorPeekPopup._topPoint.y ? topPointInLayerPane.y + (bottomPointInLayerPane.y - topPointInLayerPane.y) / 2 - prefSize.height / 2 : topPointInLayerPane.y;
        Point location = _isLeft ? new Point(topPointInLayerPane.x, y) : new Point(topPointInLayerPane.x - prefSize.width, y);
        location.y = Math.min(topPointInLayerPane.y, location.y);
        location.y = Math.max(layerPane.getY() + 10, location.y);
        location.y = Math.min(layerPane.getHeight() - (imageHeight + EditorPeekPopup._textSize.height) - 10, location.y);
        _popComponent.setLocation(location);
        if (_popComponent.getParent() != layerPane) {
            layerPane.add((Component)_popComponent, JLayeredPane.POPUP_LAYER);
        }
        ToolTipManager.sharedInstance().setEnabled(false);
        layerPane.getParent().repaint();
    }

    private static int _getTrimWidth(BasicEditorPane editorPane, int startLine, int endLine, boolean isLeft) {
        int trimWidth = -1;
        try {
            FontMetrics fm = editorPane.getFontMetrics(editorPane.getFont());
            for (int line = startLine + 1; line <= endLine; ++line) {
                int sOff = editorPane.getLineStartOffset(line);
                int eOff = editorPane.getLineEndOffset(line);
                String text = editorPane.getText(sOff, eOff - sOff);
                String textTrimmed = text.trim();
                int curTrimWidth = 0;
                if (textTrimmed.length() == 0) continue;
                if (isLeft) {
                    int charIndex = text.indexOf(textTrimmed.charAt(0));
                    if (charIndex > 0) {
                        String trimmedPart = text.substring(0, charIndex);
                        curTrimWidth = SwingUtilities.computeStringWidth(fm, trimmedPart);
                    }
                } else {
                    int lastNonWhiteChar = text.lastIndexOf(textTrimmed.charAt(textTrimmed.length() - 1));
                    if (text.length() > lastNonWhiteChar + 1) {
                        String trimmed = text.substring(0, lastNonWhiteChar + 1);
                        int stringWidth = SwingUtilities.computeStringWidth(fm, trimmed);
                        curTrimWidth = editorPane.getWidth() - stringWidth;
                    }
                }
                if (trimWidth != -1 && curTrimWidth >= trimWidth) continue;
                trimWidth = curTrimWidth;
            }
        }
        catch (BadLocationException e) {
            return 0;
        }
        trimWidth = trimWidth < 0 ? 0 : (trimWidth -= Math.min(10, trimWidth));
        return trimWidth;
    }

    private static Image _getImage(BasicEditorPane editorPane, Rectangle renderRect) {
        boolean isOpaque = editorPane.isOpaque();
        editorPane.setOpaque(false);
        boolean wasCaretVisible = ((DefaultCaret)editorPane.getCaret()).isActive();
        editorPane.getCaret().setVisible(false);
        VolatileImage wholeCompImage = editorPane.createVolatileImage(renderRect.width, renderRect.height);
        Graphics g = wholeCompImage.getGraphics();
        g.setColor(editorPane.getBackground());
        g.setClip(0, 0, renderRect.width, renderRect.height);
        g.fillRect(0, 0, renderRect.width, renderRect.height);
        g.translate(-renderRect.x, -renderRect.y);
        editorPane.paint(g);
        editorPane.getCaret().setVisible(wasCaretVisible);
        editorPane.setOpaque(isOpaque);
        g.dispose();
        return wholeCompImage;
    }

    public static String[] createTextLines(String text) {
        if (text == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(text, "\n\r");
        ArrayList<String> stringList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            stringList.add(tokenizer.nextToken());
        }
        return stringList.toArray(new String[stringList.size()]);
    }

    public static void hidePopup(boolean keepKey) {
        if (!keepKey) {
            _keyRef = null;
        }
        _renderImage = null;
        if (_popComponent != null && _popComponent.getParent() != null) {
            JComponent c = (JComponent)_popComponent.getParent();
            c.remove(_popComponent);
            c.repaint();
        }
        ToolTipManager.sharedInstance().setEnabled(true);
    }

    public static boolean isShowing() {
        return _popComponent != null && _popComponent.isShowing();
    }

    static {
        _text = new String[0];
        editorPeek = true;
        String gutterPeekProp = System.getProperty("ide.gutter.peek");
        if (gutterPeekProp != null && gutterPeekProp.equalsIgnoreCase("false")) {
            editorPeek = false;
        }
    }

    private class PopupPanel
    extends JPanel {
        private PopupPanel() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    EditorPeekPopup.hidePopup(false);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    EditorPeekPopup.hidePopup(false);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    EditorPeekPopup.hidePopup(false);
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            int[] nArray;
            int[] nArray2;
            int[] nArray3;
            int[] ys;
            int[] xs;
            int x1;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            float[] elements = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.2f, 0.2f, 0.2f, 0.1f, 0.1f, 0.2f, 0.4f, 0.2f, 0.1f, 0.1f, 0.2f, 0.2f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f};
            Kernel myKernel = new Kernel(5, 5, elements);
            ConvolveOp simpleBlur = new ConvolveOp(myKernel);
            BufferedImage shadowImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics2D shadowG = (Graphics2D)shadowImage.getGraphics();
            Point topPoint = (Point)_topPoint.clone();
            Point bottomPoint = (Point)_bottomPoint.clone();
            SwingUtilities.convertPointFromScreen(topPoint, this);
            SwingUtilities.convertPointFromScreen(bottomPoint, this);
            int lineHeight = this._getLineHeight(g2);
            int textHeight = _text == null ? 0 : lineHeight * _text.length;
            int destMidY = this.getHeight() / 2 - 5 + 1;
            int imgH = _renderImage == null ? 0 : _renderImage.getHeight();
            int y0 = Math.max(destMidY - (imgH + textHeight) / 2, 0);
            int y1 = destMidY + (imgH + textHeight + 5) / 2;
            shadowG.setColor(new Color(0, 0, 0, 20));
            int BLUR_RADIUS = 3;
            y0 += BLUR_RADIUS;
            y1 += BLUR_RADIUS;
            if (_isLeft) {
                x1 = 25;
                xs = new int[]{this.getWidth() - 5 - BLUR_RADIUS, x1, topPoint.x, bottomPoint.x, x1, this.getWidth() - 5 - BLUR_RADIUS};
                ys = new int[]{y0, y0, topPoint.y, bottomPoint.y, y1, y1};
            } else {
                x1 = this.getWidth() - 1 - 25;
                xs = new int[]{BLUR_RADIUS, x1, topPoint.x, bottomPoint.x, x1, BLUR_RADIUS};
                ys = new int[]{y0, y0, topPoint.y, bottomPoint.y, y1, y1};
            }
            shadowG.fillPolygon(xs, ys, 6);
            y0 -= BLUR_RADIUS;
            y1 -= BLUR_RADIUS;
            g2.drawImage(shadowImage, simpleBlur, 0, 0);
            shadowG.dispose();
            g2.setColor(_foregroundColor);
            if (_isLeft) {
                int[] nArray4 = new int[6];
                nArray4[0] = this.getWidth() - 5;
                nArray4[1] = x1;
                nArray4[2] = topPoint.x;
                nArray4[3] = bottomPoint.x;
                nArray4[4] = x1;
                nArray3 = nArray4;
                nArray4[5] = this.getWidth() - 5;
            } else {
                int[] nArray5 = new int[6];
                nArray5[0] = 5;
                nArray5[1] = x1;
                nArray5[2] = topPoint.x - 1;
                nArray5[3] = bottomPoint.x - 1;
                nArray5[4] = x1;
                nArray3 = nArray5;
                nArray5[5] = 5;
            }
            xs = nArray3;
            ys = new int[]{y0, y0, topPoint.y, bottomPoint.y, y1 - 1, y1 - 1};
            if (_isLeft) {
                int[] nArray6 = new int[4];
                nArray6[0] = x1;
                nArray6[1] = topPoint.x;
                nArray6[2] = bottomPoint.x;
                nArray2 = nArray6;
                nArray6[3] = x1;
            } else {
                int[] nArray7 = new int[4];
                nArray7[0] = x1;
                nArray7[1] = topPoint.x - 1;
                nArray7[2] = bottomPoint.x - 1;
                nArray2 = nArray7;
                nArray7[3] = x1;
            }
            int[] xs1 = nArray2;
            int[] ys1 = new int[]{y0, topPoint.y, bottomPoint.y, y1 - 1};
            g2.setColor(_backgroundColor);
            g2.fillPolygon(xs, ys, 6);
            Paint origPaint = g2.getPaint();
            GradientPaint gPaint = _isLeft ? new GradientPaint(x1 + 7, topPoint.y, _backgroundColor, topPoint.x, topPoint.y, _backgroundColor.darker()) : new GradientPaint(x1 - 7, topPoint.y, _backgroundColor, topPoint.x, topPoint.y, _backgroundColor.darker());
            g2.setPaint(gPaint);
            g2.fillPolygon(xs1, ys1, 4);
            g2.setPaint(origPaint);
            g2.setColor(_foregroundColor);
            g2.drawPolygon(xs, ys, 6);
            if (textHeight > 0) {
                this._renderText(g2, lineHeight, textHeight, x1, y0);
            }
            if (_renderImage != null) {
                if (_isLeft) {
                    g2.drawImage((Image)_renderImage, 26, y0 + 1 + textHeight + 1, null);
                } else {
                    g2.drawImage((Image)_renderImage, 6, y0 + 1 + textHeight + 1, null);
                }
            }
            g2.setColor(_foregroundColor);
            g2.drawLine(x1, y0, x1, y1 - 1);
            if (_isLeft) {
                int[] nArray8 = new int[6];
                nArray8[0] = this.getWidth() - 5;
                nArray8[1] = x1;
                nArray8[2] = topPoint.x;
                nArray8[3] = bottomPoint.x;
                nArray8[4] = x1;
                nArray = nArray8;
                nArray8[5] = this.getWidth() - 5;
            } else {
                int[] nArray9 = new int[6];
                nArray9[0] = 5;
                nArray9[1] = x1;
                nArray9[2] = topPoint.x - 1;
                nArray9[3] = bottomPoint.x - 1;
                nArray9[4] = x1;
                nArray = nArray9;
                nArray9[5] = 5;
            }
            xs = nArray;
            ys = new int[]{y0, y0, topPoint.y, bottomPoint.y, y1 - 1, y1 - 1};
            g2.drawPolygon(xs, ys, 6);
        }

        private void _renderText(Graphics2D g2, int lineHeight, int textHeight, int x1, int y0) {
            if (_isLeft) {
                int x0 = this.getWidth() - 5 + 1;
                for (int line = 0; line < _text.length; ++line) {
                    g2.setColor(_markColor[line]);
                    g2.fillRect(x1, y0 + 1 + line * lineHeight, x0 - x1, lineHeight);
                    g2.setColor(_foregroundColor);
                    g2.drawString(_text[line], x1 + 3, y0 + lineHeight * (line + 1) - 2);
                }
                g2.setColor(_foregroundColor);
                g2.drawLine(this.getWidth() - 5, y0 + textHeight + 1, x1, y0 + textHeight + 1);
            } else {
                int x0 = 6;
                for (int line = 0; line < _text.length; ++line) {
                    g2.setColor(_markColor[line]);
                    g2.fillRect(x0, y0 + 1 + line * lineHeight, x1 - x0, lineHeight);
                    g2.setColor(_foregroundColor);
                    g2.drawString(_text[line], y0 + 1 + 5 + 2, y0 + lineHeight * (line + 1) - 2);
                }
                g2.setColor(_foregroundColor);
                g2.drawLine(6, y0 + textHeight + 1, x1, y0 + textHeight + 1);
            }
        }

        private int _getLineHeight(Graphics2D g2) {
            int lineHeight = 0;
            if (_text != null && _text.length > 0 && _text[0] != null) {
                lineHeight = (int)_popComponent.getFontMetrics(_popComponent.getFont()).getStringBounds(_text[0], g2).getHeight();
            }
            return lineHeight;
        }
    }
}

