/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.columnlayout;

import java.awt.Container;
import java.util.ArrayList;
import oracle.javatools.columnlayout.LayoutComponent;

public class LayoutRow
implements LayoutComponent {
    private int m_totalRows = 0;
    private int m_totalColumns = 0;
    private ArrayList m_columns = new ArrayList();

    @Override
    public void addToPanel(Container container, int baseRow, int baseColumn, boolean[] rowConstraints, boolean[] columnConstraints, int rowSpan) {
        int columnCount = this.m_columns.size();
        for (int i = 0; i < columnCount; ++i) {
            LayoutComponent lc = (LayoutComponent)this.m_columns.get(i);
            lc.addToPanel(container, baseRow, baseColumn, rowConstraints, columnConstraints, rowSpan);
            baseColumn += lc.getColumnCount();
        }
    }

    @Override
    public void areRowsResizable(boolean[] rowConstraints, int baseRow, int rowSpan) {
        for (int i = this.m_columns.size() - 1; i >= 0; --i) {
            LayoutComponent lc = (LayoutComponent)this.m_columns.get(i);
            lc.areRowsResizable(rowConstraints, baseRow, rowSpan);
        }
    }

    @Override
    public void areColumnsResizable(boolean[] columnConstraints, int baseColumn) {
        baseColumn += this.m_totalColumns;
        for (int i = this.m_columns.size() - 1; i >= 0; --i) {
            LayoutComponent lc = (LayoutComponent)this.m_columns.get(i);
            lc.areColumnsResizable(columnConstraints, baseColumn -= lc.getColumnCount());
        }
    }

    @Override
    public int getRowCount() {
        return this.m_totalRows;
    }

    @Override
    public int getColumnCount() {
        return this.m_totalColumns;
    }

    public void add(LayoutComponent lc) {
        if (lc == null) {
            throw new IllegalArgumentException("Layout component was null");
        }
        this.m_columns.add(lc);
        int newRows = lc.getRowCount();
        if (newRows > this.m_totalRows) {
            this.m_totalRows = newRows;
        }
        this.m_totalColumns += lc.getColumnCount();
    }
}

