/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.ui;

import java.sql.Connection;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.RepoPageMigration;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class AppRepoPanel
extends RepoPageMigration {
    public static final String REPOSITORY_CONN = "MIGR_REPOSITORY";
    public static final String TRUNCATE_REPOSITORY = "TRUNCATE_REPOSITORY";

    public void onEntry(TraversableContext traversableContext) {
        Object object = traversableContext.get("project");
        if (object != null) {
            traversableContext.getWizardCallbacks().wizardSkipCurrentStep();
            return;
        }
        this._chkGoSummary.setVisible(false);
        if (!MigrationAddin.isRepositoryOpen()) {
            this.initPageWithData(traversableContext);
        }
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    protected void initPageWithData(TraversableContext traversableContext) {
        String string;
        if (this.connPanel != null) {
            this.connPanel.resetConnections();
        }
        if ((string = MigrationAddin.getRepositoryConnectionName()) != null && string.trim().length() > 0) {
            this.connPanel.setSelectedItem(string);
        }
        this.hideTruncIfNoRepository(this.connPanel.getConnectionName());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Object object = traversableContext.get("project");
        if (object != null) {
            return;
        }
        String string = this.connPanel.getConnectionName();
        if (traversableContext.getDirection() == 1 && (string == null || string.trim().length() == 0)) {
            throw new TraversalException(QMWizardArb.getString((String)"RepoConnBad"));
        }
        traversableContext.put(REPOSITORY_CONN, (Object)string);
        traversableContext.put(TRUNCATE_REPOSITORY, (Object)this._chkTrunc.isSelected());
        if (MigrationAddin.getDefaultMigrationRepository().equals(string)) {
            if (!MigrationAddin.isRepositoryOpen()) {
                MigrationAddin.openRepository((String)string);
            }
        } else {
            boolean bl = false;
            try {
                Connection connection = Connections.getInstance().getConnection(string);
                bl = RepositoryManager.doesRepositoryExist((Connection)connection);
            }
            catch (Exception exception) {
                bl = false;
            }
            if (bl) {
                MigrationAddin.openRepository((String)string);
            }
        }
        RepositoryManager.findOrCreateRepositoryTables((String)string);
    }

    public void commit(ApplyEvent applyEvent) throws TraversalException {
    }
}

