/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.scanner;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.migration.applications.AppScanArb;
import oracle.dbtools.raptor.migration.applications.addin.ProcessorException;
import oracle.dbtools.raptor.migration.applications.cmdline.ScannerDetails;
import oracle.dbtools.raptor.migration.applications.recognisers.AllFilesFilter;
import oracle.dbtools.raptor.migration.applications.recognisers.FileTypeRecognizerRegistry;
import oracle.dbtools.raptor.migration.applications.recognisers.SupportedExtentionFilter;
import oracle.dbtools.raptor.migration.applications.rules.Rules;
import oracle.dbtools.raptor.migration.applications.rules.RulesRegistry;
import oracle.dbtools.raptor.migration.applications.rules.parser.RuleSet;
import oracle.dbtools.raptor.migration.applications.scanner.FilePattern;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorAppEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorArtifactEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorFileEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorListener;
import oracle.dbtools.raptor.migration.applications.utils.Utils;
import oracle.javatools.util.PlatformUtils;

public class FileProcessor {
    private static Logger LOGGER = Logger.getLogger(FileProcessor.class.getName());
    private ScannerDetails options;
    private HashMap<String, ArrayList<RuleSet>> rules = null;
    private ArrayList<FilePattern> fPatterns = new ArrayList();
    private ArrayList<FileProcessorListener> m_listeners;
    private ArrayList<String> backedUpFiles;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public void addListener(FileProcessorListener fileProcessorListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList();
        }
        this.m_listeners.add(fileProcessorListener);
    }

    public void removeListener(FileProcessorListener fileProcessorListener) {
        if (this.m_listeners.contains(fileProcessorListener)) {
            this.m_listeners.remove(fileProcessorListener);
        }
    }

    public void notifyListeners(FileProcessorEvent fileProcessorEvent) {
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            this.m_listeners.get(i).raiseEvent(fileProcessorEvent);
        }
    }

    public void notifyListeners(ArrayList<FileProcessorArtifactEvent> arrayList) {
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            this.m_listeners.get(i).raiseEvent(arrayList);
        }
    }

    public final ArrayList<FilePattern> getfPatterns() {
        return this.fPatterns;
    }

    public FileProcessor(ScannerDetails scannerDetails) throws ProcessorException {
        this.options = scannerDetails;
        RulesRegistry.getInstance().loadXML(scannerDetails);
        if (this.options.getType() == "UNKNOWN") {
            String string = "";
            String[] stringArray = Rules.getInstance().getDBTypes();
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i];
                if (i >= stringArray.length - 1) continue;
                string = string + ",";
            }
            throw new ProcessorException(MessageFormat.format(AppScanArb.getString("CL_APPSCAN_UNKNOWN_DATABASE"), string));
        }
        this.rules = Rules.getInstance().getRules4Type(this.options.getType());
        if (this.rules == null || this.rules.isEmpty()) {
            throw new ProcessorException(MessageFormat.format("There are no rules registered for {0}", this.options.getType()));
        }
    }

    public void process(File file) throws ProcessorException {
        File file2 = file;
        if (file != null) {
            if (this.options.isOutputSpecified() && this.options.getDir() != null) {
                file2 = Utils.createOutputFile(file, this.options);
            }
            FilePattern filePattern = null;
            String string = FileTypeRecognizerRegistry.getType(file2);
            if (file.isFile() && !string.equals("ANY") || file.isFile() && !Utils.isBinary(file) && string.equals("ANY")) {
                ArrayList<RuleSet> arrayList = this.getRules4SourceType(string);
                filePattern = new FilePattern(file2, arrayList, this.m_listeners, this.options);
                filePattern.process();
            } else if (file.isFile() && Utils.isBinary(file)) {
                FileProcessorFileEvent fileProcessorFileEvent = new FileProcessorFileEvent(file2.getName(), "binary", "ignore", Utils.getURI(file2, this.options), string, "START", 0);
                this.notifyListeners(fileProcessorFileEvent);
            }
            if (filePattern != null && filePattern.getBackedUpFiles() != null) {
                if (this.backedUpFiles == null) {
                    this.backedUpFiles = new ArrayList();
                }
                this.backedUpFiles.addAll(filePattern.getBackedUpFiles());
            }
        }
    }

    private ArrayList<RuleSet> getRules4SourceType(String string) {
        ArrayList<RuleSet> arrayList = this.rules.get(string);
        ArrayList<RuleSet> arrayList2 = this.rules.get("ANY".toLowerCase());
        if (arrayList != null) {
            if (arrayList2 != null) {
                Iterator<RuleSet> iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
        } else {
            arrayList = arrayList2;
        }
        return arrayList;
    }

    public void process(ArrayList<File> arrayList) throws ProcessorException {
        for (File file : arrayList) {
            this.process(file);
        }
    }

    private ArrayList<File> buildFileList(File file, FileFilter fileFilter) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles(fileFilter)) {
                arrayList.addAll(this.buildFileList(file2, fileFilter));
            }
        } else {
            arrayList.add(file);
        }
        return arrayList;
    }

    public void process() throws ProcessorException {
        ArrayList<File> arrayList = this.findFiles();
        this.process(arrayList);
        if (this.backedUpFiles != null) {
            boolean bl = PlatformUtils.isWindows();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.backedUpFiles) {
                if (bl) {
                    stringBuilder.append("move " + string + ".backup " + string + "\n");
                    continue;
                }
                stringBuilder.append("mv " + string + ".backup " + string + "\n");
            }
            try {
                Object object = null;
                object = bl ? new FileWriter(new File("replace.bat")) : new FileWriter(new File("replace.sh"));
                ((Writer)object).write(stringBuilder.toString());
                ((OutputStreamWriter)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        FileProcessorAppEvent fileProcessorAppEvent = new FileProcessorAppEvent(this.options.getApplicationName(), this.options.getApplicationDescription(), this.options.getDirURIPath(), this.options.getOutputDirURIPath(), this.options.isInPlace(), "FINISH", 0);
        this.notifyListeners(fileProcessorAppEvent);
    }

    private ArrayList<File> findFiles() {
        Object object;
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 0;
        System.out.println("Finding files....");
        if (this.options.isDirBased() && this.options.isDirSpecified() && this.options.getDir() != null) {
            object = new File(this.options.getDir());
            n = this.buildFileList((File)object, new AllFilesFilter()).size();
            arrayList.addAll(this.buildFileList((File)object, new SupportedExtentionFilter()));
        }
        if (this.options.getfileList() != null) {
            for (String string : this.options.getfileList()) {
                arrayList.add(new File(string));
            }
        }
        object = new FileProcessorAppEvent(this.options.getApplicationName(), this.options.getApplicationDescription(), this.options.getDirURIPath(), this.options.getOutputDirURIPath(), this.options.isInPlace(), "START", n);
        if (this.options.isRepositorySpecified()) {
            ((FileProcessorAppEvent)object).setProjectId(this.options.getProjectId());
        }
        this.notifyListeners((FileProcessorEvent)object);
        return arrayList;
    }
}

