/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.report;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import oracle.dbtools.raptor.migration.applications.report.CmdLineStream;
import oracle.dbtools.raptor.migration.applications.report.Summary;

public class StdErrReportStream
extends CmdLineStream {
    String summaryString = "High Level Overview\n-------------------\n\t{0} total calls found\n\t{1} distinct calls found\n\t{2} files scanned\n\t{3} language types\n\t{4} total files in source\n\t{5} lines of code in scanned application";

    public StdErrReportStream(PrintStream printStream) {
        super(printStream);
    }

    public void endApplication(Summary summary) {
        DecimalFormat decimalFormat = new DecimalFormat("###,###,###");
        this.getPrintStream().println("------------------------ Application Results -----------------");
        if (this.isLogFile()) {
            this.printOverallSummary(summary, decimalFormat, this.getSummaryPrintStream());
            this.printFileTypeSummary(summary, this.getSummaryPrintStream());
            this.printCallBreakdownSummary(summary, this.getSummaryPrintStream());
            this.printCallBreakdownByFile(summary, this.getSummaryPrintStream());
        } else {
            this.printCallBreakdownByFile(summary, this.getPrintStream());
            this.printCallBreakdownSummary(summary, this.getPrintStream());
            this.printFileTypeSummary(summary, this.getPrintStream());
            this.printOverallSummary(summary, decimalFormat, this.getPrintStream());
        }
        this.getPrintStream().println("-------------------------------------------------------------");
    }

    private void printOverallSummary(Summary summary, NumberFormat numberFormat, PrintStream printStream) {
        this.getPrintStream().println("------------------------    Summary   -----------------------");
        printStream.println(MessageFormat.format(this.summaryString, numberFormat.format(summary.getTotalCalls()), numberFormat.format(summary.getDistinctCalls()), numberFormat.format(summary.getTotalFiles()), numberFormat.format(summary.getTotalTypes()), numberFormat.format(summary.getTotalFilesInSource()), numberFormat.format(summary.getTotalLoc())));
        printStream.println("-------------------------------------------------------------");
    }

    private void printFileTypeSummary(Summary summary, PrintStream printStream) {
        printStream.println("\nFile Type Summary");
        printStream.println("----------------------");
        printStream.println(summary.getTypeBreakDownByNumber());
        printStream.println("-------------------------------------------------------------");
    }

    private void printCallBreakdownSummary(Summary summary, PrintStream printStream) {
        printStream.println("\nCall Breakdown Summary");
        printStream.println("----------------------");
        printStream.println(summary.getCallBreakDownCount());
        printStream.println("-------------------------------------------------------------");
    }

    private void printCallBreakdownByFile(Summary summary, PrintStream printStream) {
        printStream.println("\nCall Breakdown Summary by File");
        printStream.println("------------------------------");
        printStream.println(summary.getCallBreakDownCountByFile());
        printStream.println("-------------------------------------------------------------");
    }

    @Override
    public void endApplication() {
    }

    @Override
    public void endFile() {
    }

    @Override
    public void startApplication(String string) {
        this.getPrintStream().println(string);
    }

    @Override
    public void startFile(String string) {
        this.getPrintStream().println("\t\t" + string);
    }

    @Override
    public void printArtificat(String string) {
        this.getPrintStream().println("\t\t\t" + string);
    }

    @Override
    public void startDir(String string) {
        this.getPrintStream().println("\t" + string);
    }
}

