/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.report;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.migration.applications.cmdline.ScannerDetails;
import oracle.dbtools.raptor.migration.applications.report.ReportEngine;
import oracle.dbtools.raptor.migration.applications.report.StdErrReportStream;
import oracle.dbtools.raptor.migration.applications.report.Summary;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorAppEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorArtifactEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorFileEvent;
import oracle.dbtools.raptor.migration.applications.scanner.PatternFound;

public class CommandlineEngine
extends ReportEngine {
    Logger LOGGER = Logger.getLogger(this.getClass().getName());
    ArrayList<PatternFound> e = new ArrayList();
    StdErrReportStream printStream;
    private int n = 0;
    private String m_file = "";
    private String m_currentAppName = "";
    private String m_dir = "";
    private ScannerDetails m_options;

    public CommandlineEngine(ScannerDetails scannerDetails) {
        this.m_options = scannerDetails;
        if (scannerDetails.isLogSpecified()) {
            String string = scannerDetails.getLog();
            try {
                File file = new File(string);
                String string2 = file.getParent();
                String string3 = string2 + File.separator + "summary.log";
                this.printStream = new StdErrReportStream(new PrintStream(new File(string.toString())));
                this.printStream.setSummaryPrintStream(new PrintStream(new File(string3)));
                this.printStream.setLogOn(scannerDetails.isLogSpecified());
            }
            catch (IOException iOException) {
                this.LOGGER.log(Level.FINE, "Cannot open LogFile {0}", new Object[]{string.toString()});
            }
        } else {
            this.printStream = new StdErrReportStream(System.out);
        }
    }

    protected boolean isLog() {
        return this.m_options.isLogSpecified();
    }

    @Override
    public void generateReport(Summary summary) {
        if (summary != null) {
            this.printStream.endApplication(summary);
        }
    }

    @Override
    protected int createApplication(FileProcessorAppEvent fileProcessorAppEvent) {
        if (!this.m_currentAppName.equals("") && !this.m_currentAppName.equals(fileProcessorAppEvent.getAppName())) {
            this.printStream.endApplication();
        }
        this.m_currentAppName = fileProcessorAppEvent.getAppName();
        this.printStream.startApplication(fileProcessorAppEvent.getAppName());
        return 0;
    }

    @Override
    protected void createArtifact(FileProcessorArtifactEvent fileProcessorArtifactEvent, int n) {
        this.printStream.printArtificat(fileProcessorArtifactEvent.getLineNo() + ":" + fileProcessorArtifactEvent.getStringFound());
    }

    @Override
    protected int createFile(FileProcessorFileEvent fileProcessorFileEvent, int n) {
        if (this.m_file != null && !this.m_file.equals(fileProcessorFileEvent.getFileName())) {
            this.printStream.endFile();
            this.m_file = fileProcessorFileEvent.getFileName();
        }
        File file = new File(fileProcessorFileEvent.getURI());
        if (this.m_dir != null && !this.m_dir.equals(file.getParent())) {
            this.m_dir = file.getParent() == null ? "" : file.getParent();
            this.printStream.startDir(this.m_dir);
        }
        this.printStream.startFile(fileProcessorFileEvent.getFileName());
        return 0;
    }

    @Override
    public void raiseEvent(ArrayList<FileProcessorArtifactEvent> arrayList) {
        for (FileProcessorArtifactEvent fileProcessorArtifactEvent : arrayList) {
            this.raiseEvent(fileProcessorArtifactEvent);
        }
    }

    @Override
    protected void finishApplication(FileProcessorAppEvent fileProcessorAppEvent) {
    }

    @Override
    protected void finishFile(FileProcessorFileEvent fileProcessorFileEvent, int n) {
    }
}

