/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.recognisers;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.raptor.migration.applications.recognisers.Recognizer;
import oracle.dbtools.raptor.migration.applications.recognisers.iFileRecognizer;
import oracle.dbtools.raptor.migration.applications.utils.Utils;

public class FileTypeRecognizerRegistry {
    public static final String ANY = "ANY";
    private static Map<String, iFileRecognizer> s_registry = new TreeMap<String, iFileRecognizer>();
    private static Map<String, iFileRecognizer> ext_registry = new TreeMap<String, iFileRecognizer>();

    public static synchronized void registerRecognizer(iFileRecognizer iFileRecognizer2) {
        s_registry.put(iFileRecognizer2.getTypeString().toLowerCase(), iFileRecognizer2);
    }

    public static synchronized void unregisterRecognizer(iFileRecognizer iFileRecognizer2) {
        s_registry.remove(iFileRecognizer2.getTypeString().toLowerCase());
    }

    public static synchronized iFileRecognizer getRecognizer(String string) {
        return s_registry.get(string.toLowerCase());
    }

    public static synchronized List<String> getTypes() {
        FileTypeRecognizerRegistry.buildExtensionList();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(s_registry.keySet());
        return arrayList;
    }

    public static synchronized String getType(File file) {
        FileTypeRecognizerRegistry.buildExtensionList();
        if (ext_registry.containsKey(Utils.getExtension(file))) {
            return ext_registry.get(Utils.getExtension(file)).getType();
        }
        List<String> list = FileTypeRecognizerRegistry.getTypes();
        for (int i = 0; i < list.size(); ++i) {
            if (!FileTypeRecognizerRegistry.getRecognizer(list.get(i)).isType(file)) continue;
            return FileTypeRecognizerRegistry.getRecognizer(list.get(i)).getType();
        }
        return ANY;
    }

    public static synchronized List<String> getExtensions() {
        FileTypeRecognizerRegistry.buildExtensionList();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(ext_registry.keySet());
        return arrayList;
    }

    private static void buildExtensionList() {
        Iterator<Map.Entry<String, iFileRecognizer>> iterator = s_registry.entrySet().iterator();
        while (iterator.hasNext()) {
            iFileRecognizer iFileRecognizer2 = iterator.next().getValue();
            for (int i = 0; i < iFileRecognizer2.getExtensions().length; ++i) {
                ext_registry.put(iFileRecognizer2.getExtensions()[i], iFileRecognizer2);
            }
        }
    }

    public static boolean contains(Recognizer recognizer) {
        return s_registry.containsKey(recognizer.getTypeString());
    }
}

