/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.utils;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;

public class TTSQLDevFileNames {
    private static final String HOME_DIR;
    private static Logger LOGGER;

    public static String getFileName(String string, TTSQLDevFileType tTSQLDevFileType) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String string2 = simpleDateFormat.format(System.currentTimeMillis());
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(string + "-");
        stringBuilder.append(tTSQLDevFileType.getFileName() + "-");
        stringBuilder.append(string2);
        stringBuilder.append("." + tTSQLDevFileType.getExtension());
        return stringBuilder.toString();
    }

    public static String[] getHeaders(DBObject dBObject) {
        Connection connection = dBObject.getConnection();
        String string = Connections.getDisplayName((String)dBObject.getConnectionName());
        return TTSQLDevFileNames.getHeaders(connection, string);
    }

    public static String[] getHeaders(Connection connection, String string) {
        String[] stringArray = new String[4];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String string2 = simpleDateFormat.format(System.currentTimeMillis());
        stringArray[0] = "-- This file was generated by SQL Developer at " + string2;
        stringArray[1] = "-- SQL Developer version " + Ide.getProductVersion();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            stringArray[2] = "-- Database version: " + databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.SEVERE, "Can't get database version", sQLException);
            stringArray[2] = "-- Database version: Cannot ascertain database version";
        }
        stringArray[3] = "-- Connection name: " + string;
        return stringArray;
    }

    static {
        LOGGER = Logger.getLogger(TTSQLDevFileNames.class.getPackage().getName());
        HOME_DIR = System.getProperty("user.home");
    }

    public static enum TTSQLDevFileType {
        INDEX_ADVICE("indexadvice", "sql"),
        EXPORT_OPTIMIZER_STATS("exportstatistics", "sql");

        private String _fileName;
        private String _extension;

        protected String getFileName() {
            return this._fileName;
        }

        protected String getExtension() {
            return this._extension;
        }

        private TTSQLDevFileType(String string2, String string3) {
            this._fileName = string2;
            this._extension = string3;
        }
    }
}

