/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor;

import java.awt.Component;
import java.sql.Connection;
import java.util.HashSet;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.commands.TTAutotraceTreeModel;
import oracle.dbtools.raptor.timesten.performancemonitor.data.SummaryDataProvider;
import oracle.dbtools.raptor.timesten.performancemonitor.data.TopSQLCmdBean;
import oracle.dbtools.raptor.timesten.utils.JavaFxWorker;
import oracle.dbtools.raptor.timesten.utils.SqlLikeConditionToRegex;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.ide.Ide;

public class TopSQLPane
extends BorderPane {
    private ObservableList<TopSQLCmdBean> topSQL;
    private Connection conn;
    private TableView<TopSQLCmdBean> topSQLTable;
    private ObservableList<TopSQLCmdBean> filteredList;
    private TextField ownerTextField;
    private TextField sqlTextField;
    private HashSet<String> systemUsers = new HashSet();
    private CheckBox hideSystem;
    private Button refresh;
    private MenuItem executionCount;
    private MenuItem executionTime;
    private MenuItem both;
    private MenuButton orderBy;
    EventHandler<ActionEvent> orderBySelection;
    EventHandler<KeyEvent> enterEvent;

    public TopSQLPane(ObservableList<TopSQLCmdBean> observableList, Connection connection) {
        this.systemUsers.add("PUBLIC");
        this.systemUsers.add("SYS");
        this.systemUsers.add("TTREP");
        this.systemUsers.add("GRID");
        this.systemUsers.add("SYSTEM");
        this.orderBySelection = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (TopSQLPane.this.orderBy.getText().equals(((MenuItem)actionEvent.getSource()).getText())) {
                    return;
                }
                if (actionEvent.getSource() == TopSQLPane.this.executionCount) {
                    TopSQLPane.this.refreshData("executions");
                } else if (actionEvent.getSource() == TopSQLPane.this.executionTime) {
                    TopSQLPane.this.refreshData("lastexecutetime");
                } else if (actionEvent.getSource() == TopSQLPane.this.both) {
                    TopSQLPane.this.refreshData("(executions *lastexecutetime)");
                }
                TopSQLPane.this.orderBy.setText(((MenuItem)actionEvent.getSource()).getText());
            }
        };
        this.enterEvent = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.ENTER) {
                    TopSQLPane.this.doSearch();
                }
            }
        };
        this.conn = connection;
        this.topSQL = observableList;
        this.topSQLTable = new TableView();
        this.filteredList = FXCollections.observableArrayList(observableList);
        TableColumn tableColumn = new TableColumn(Messages.getString("TimesTenGrid.element"));
        tableColumn.setCellValueFactory((Callback)new PropertyValueFactory("elementId"));
        TableColumn tableColumn2 = new TableColumn(Messages.getString("TimestenGrid.sqlCmdId"));
        tableColumn2.setCellValueFactory((Callback)new PropertyValueFactory("sqlCmdId"));
        TableColumn tableColumn3 = new TableColumn(Messages.getString("TimestenGrid.executions"));
        tableColumn3.setCellValueFactory((Callback)new PropertyValueFactory("executions"));
        TableColumn tableColumn4 = new TableColumn(Messages.getString("TimestenGrid.prepares"));
        tableColumn4.setCellValueFactory((Callback)new PropertyValueFactory("prepares"));
        TableColumn tableColumn5 = new TableColumn(Messages.getString("TimestenGrid.reprepares"));
        tableColumn5.setCellValueFactory((Callback)new PropertyValueFactory("reprepares"));
        TableColumn tableColumn6 = new TableColumn(Messages.getString("TimestenGrid.startTime"));
        tableColumn6.setCellValueFactory((Callback)new PropertyValueFactory("startTime"));
        TableColumn tableColumn7 = new TableColumn(Messages.getString("TimestenGrid.lastExecuteTime"));
        tableColumn7.setCellValueFactory((Callback)new PropertyValueFactory("lastExecutionTime"));
        TableColumn tableColumn8 = new TableColumn(Messages.getString("TimestenGrid.maxExecuteTime"));
        tableColumn8.setCellValueFactory((Callback)new PropertyValueFactory("maxExecutionTime"));
        this.ownerTextField = new TextField();
        Label label = new Label(Messages.getString("TimesTen.common.owner"));
        VBox vBox = new VBox();
        vBox.setPadding(new Insets(5.0));
        vBox.setAlignment(Pos.CENTER);
        vBox.getChildren().addAll((Object[])new Node[]{this.ownerTextField, label});
        TableColumn tableColumn9 = new TableColumn();
        tableColumn9.setGraphic((Node)vBox);
        tableColumn9.setCellValueFactory((Callback)new PropertyValueFactory("owner"));
        this.sqlTextField = new TextField();
        Label label2 = new Label(Messages.getString("TimestenGrid.query"));
        VBox vBox2 = new VBox();
        vBox2.setPadding(new Insets(5.0));
        vBox2.setAlignment(Pos.CENTER);
        vBox2.getChildren().addAll((Object[])new Node[]{this.sqlTextField, label2});
        TableColumn tableColumn10 = new TableColumn();
        tableColumn10.setGraphic((Node)vBox2);
        tableColumn10.setCellValueFactory((Callback)new PropertyValueFactory("query"));
        this.topSQLTable.getColumns().addAll((Object[])new TableColumn[]{tableColumn9, tableColumn10, tableColumn, tableColumn2, tableColumn4, tableColumn5, tableColumn3, tableColumn6, tableColumn7, tableColumn8});
        this.topSQLTable.setItems(this.filteredList);
        this.topSQLTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.setContextMenuForTable();
        this.setCenter((Node)this.topSQLTable);
        this.setupButton();
        this.ownerTextField.setOnKeyPressed(this.enterEvent);
        this.sqlTextField.setOnKeyPressed(this.enterEvent);
    }

    private void setupButton() {
        this.hideSystem = new CheckBox(Messages.getString("TimestenGrid.hideSystemUsers"));
        this.orderBy = new MenuButton();
        Label label = new Label(Messages.getString("TimestenGrid.listBy"));
        this.executionCount = new MenuItem(Messages.getString("TimestenGrid.executionCount"));
        this.executionTime = new MenuItem(Messages.getString("TimestenGrid.executionTime"));
        this.both = new MenuItem(Messages.getString("TimestenGrid.executionCountAndTime"));
        this.executionCount.setOnAction(this.orderBySelection);
        this.executionTime.setOnAction(this.orderBySelection);
        this.both.setOnAction(this.orderBySelection);
        this.orderBy.setText(this.executionCount.getText());
        this.refresh = new Button(Messages.getString("TimestenGrid.refresh"));
        this.refresh.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                TopSQLPane.this.manualRefresh();
            }
        });
        this.orderBy.getItems().addAll((Object[])new MenuItem[]{this.executionCount, this.executionTime, this.both});
        ToolBar toolBar = new ToolBar();
        toolBar.setPadding(new Insets(10.0));
        Region region = new Region();
        HBox.setHgrow((Node)region, (Priority)Priority.ALWAYS);
        toolBar.getItems().addAll((Object[])new Node[]{label, this.orderBy, region, this.hideSystem, this.refresh});
        this.setTop((Node)toolBar);
        this.hideSystem.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                TopSQLPane.this.doSearch();
            }
        });
    }

    private void manualRefresh() {
        String string = this.orderBy.getText();
        if (string.equals(this.executionCount.getText())) {
            this.refreshData("executions");
        } else if (string.equals(this.executionTime.getText())) {
            this.refreshData("lastexecutetime");
        } else if (string.equals(this.both.getText())) {
            this.refreshData("(executions *lastexecutetime)");
        }
    }

    private void refreshData(final String string) {
        JavaFxWorker javaFxWorker = new JavaFxWorker(){

            @Override
            public void doInBackground() {
                SummaryDataProvider summaryDataProvider = new SummaryDataProvider(TopSQLPane.this.conn);
                TopSQLPane.this.topSQL = summaryDataProvider.getTopSQLCmds(string);
                TopSQLPane.this.filteredList.clear();
            }

            @Override
            public void done() {
                TopSQLPane.this.topSQLTable.setItems(TopSQLPane.this.topSQL);
                TopSQLPane.this.hideSystem.setSelected(false);
            }
        };
        javaFxWorker.execute();
    }

    private void doSearch() {
        this.filteredList.clear();
        String string = "";
        String string2 = "";
        SqlLikeConditionToRegex sqlLikeConditionToRegex = new SqlLikeConditionToRegex();
        if (!this.ownerTextField.getText().isEmpty()) {
            string = sqlLikeConditionToRegex.parse(this.ownerTextField.getText());
        }
        if (!this.sqlTextField.getText().isEmpty()) {
            string2 = sqlLikeConditionToRegex.parse(this.sqlTextField.getText());
        }
        boolean bl = this.hideSystem.isSelected();
        for (TopSQLCmdBean topSQLCmdBean : this.topSQL) {
            if (bl && this.systemUsers.contains(topSQLCmdBean.getOwner())) continue;
            if (!string.isEmpty() && !string2.isEmpty()) {
                if (!topSQLCmdBean.getOwner().matches(string) || !topSQLCmdBean.getQuery().matches(string2)) continue;
                this.filteredList.add((Object)topSQLCmdBean);
                continue;
            }
            if (!string.isEmpty()) {
                if (!topSQLCmdBean.getOwner().matches(string)) continue;
                this.filteredList.add((Object)topSQLCmdBean);
                continue;
            }
            if (!string2.isEmpty()) {
                if (!topSQLCmdBean.getQuery().matches(string2)) continue;
                this.filteredList.add((Object)topSQLCmdBean);
                continue;
            }
            this.filteredList.add((Object)topSQLCmdBean);
        }
        this.topSQLTable.setItems(this.filteredList);
    }

    void setContextMenuForTable() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem menuItem = new MenuItem(Messages.getString("TimestenGrid.showExecutionPlan"));
        menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                final String string = ((TopSQLCmdBean)TopSQLPane.this.topSQLTable.getSelectionModel().getSelectedItem()).getQuery();
                final String string2 = String.valueOf(((TopSQLCmdBean)TopSQLPane.this.topSQLTable.getSelectionModel().getSelectedItem()).getSqlCmdId());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new ExecutionPlanDialog(string, string2);
                    }
                });
            }
        });
        contextMenu.getItems().add((Object)menuItem);
        this.topSQLTable.setContextMenu(contextMenu);
        this.topSQLTable.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && TopSQLPane.this.topSQLTable.getSelectionModel().getSelectedItem() != null) {
                    Dialog dialog = new Dialog();
                    TextArea textArea = new TextArea(((TopSQLCmdBean)TopSQLPane.this.topSQLTable.getSelectionModel().getSelectedItem()).getQuery());
                    textArea.setEditable(false);
                    textArea.setWrapText(true);
                    GridPane gridPane = new GridPane();
                    textArea.setMaxWidth(Double.MAX_VALUE);
                    textArea.setMaxHeight(Double.MAX_VALUE);
                    GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
                    GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
                    Label label = new Label(Messages.getString("TimestenGrid.query"));
                    gridPane.setMaxWidth(Double.MAX_VALUE);
                    gridPane.add((Node)label, 0, 0);
                    gridPane.add((Node)textArea, 0, 1);
                    ButtonType buttonType = new ButtonType(Messages.getString("TimesTenGrid.okButtonWizard"), ButtonBar.ButtonData.OK_DONE);
                    dialog.getDialogPane().getButtonTypes().add((Object)buttonType);
                    dialog.getDialogPane().setExpandableContent((Node)gridPane);
                    dialog.getDialogPane().setExpanded(true);
                    dialog.show();
                }
            }
        });
    }

    class ExecutionPlanDialog
    extends JEWTDialog {
        public ExecutionPlanDialog(String string, String string2) {
            this.setTitle(Messages.getString("TimestenGrid.executionPlan"));
            AutotracePanel autotracePanel = new AutotracePanel(string2, true, "com.timesten.jdbc.TimesTenDriver");
            TTAutotraceTreeModel tTAutotraceTreeModel = new TTAutotraceTreeModel(autotracePanel);
            autotracePanel.explainPlan(string, string2, TopSQLPane.this.conn);
            autotracePanel.fetchPlan(string, string2, TopSQLPane.this.conn);
            this.setContent((Component)autotracePanel);
            this.setResizable(true);
            this.setModal(true);
            this.setSize(400, 400);
            this.setLocationRelativeTo((Component)Ide.getMainWindow());
            this.setVisible(true);
        }
    }
}

