/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor;

import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.timesten.performancemonitor.GenericPerformanceMonitorNode;
import oracle.dbtools.raptor.timesten.performancemonitor.PerformanceDataEditor;
import oracle.dbtools.raptor.timesten.performancemonitor.data.DashboardSummaryInfo;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;

public class InformationTile
extends Region {
    private DashboardSummaryInfo info;
    private String title;
    private Font font = Font.getDefault();
    private String units;
    private boolean toInt;
    private String value;
    private final int VALUE_BORDER = 13;

    public InformationTile(String string, String string2, boolean bl) {
        this.title = string;
        this.units = string2;
        this.toInt = bl;
        this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                GenericPerformanceMonitorNode genericPerformanceMonitorNode = null;
                                genericPerformanceMonitorNode = new GenericPerformanceMonitorNode(InformationTile.this.title, GenericPerformanceMonitorNode.SUMMARY_INFO);
                                genericPerformanceMonitorNode.setFieldData(InformationTile.this.info);
                                Context context = Context.newIdeContext((Node)genericPerformanceMonitorNode);
                                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, PerformanceDataEditor.class);
                                List list = EditorManager.getEditorManager().getAllEditors();
                                ArrayList<Editor> arrayList = new ArrayList<Editor>();
                                for (Editor editor : list) {
                                    if (!(editor instanceof PerformanceDataEditor)) continue;
                                    arrayList.add(editor);
                                }
                                EditorManager.getEditorManager().closeEditors(arrayList);
                                Editor editor = EditorManager.getEditorManager().openEditor(openEditorOptions);
                            }
                        });
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        });
    }

    public InformationTile(String string, String string2) {
        this(string, string2, false);
    }

    public InformationTile(String string) {
        this(string, null, false);
    }

    public InformationTile(String string, String string2, String string3) {
        this.title = string;
        this.units = string2;
        this.value = string3;
        this.redraw(this.getWidth(), this.getHeight());
    }

    public void resize(double d, double d2) {
        super.resize(d, d2);
        this.redraw(this.getWidth(), this.getHeight());
    }

    public void refreshPane(DashboardSummaryInfo dashboardSummaryInfo) {
        this.info = dashboardSummaryInfo;
        this.redraw(this.getWidth(), this.getHeight());
    }

    public void redraw(double d, double d2) {
        if (this.info == null && this.value == null) {
            return;
        }
        ArrayList<Text> arrayList = new ArrayList<Text>();
        Text text = null;
        Text text2 = null;
        Text text3 = null;
        if (this.value == null) {
            text = new Text(this.title);
            text2 = new Text(this.units);
            if (this.toInt) {
                text3 = new Text(Integer.toString((int)this.info.getAverage()));
            } else {
                DecimalFormat decimalFormat = new DecimalFormat("#,###,##0.00");
                text3 = new Text(decimalFormat.format(this.info.getAverage()));
            }
        } else {
            text = new Text(this.title);
            text2 = new Text(this.units);
            text3 = new Text(this.value);
        }
        text.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)(this.font.getSize() - 1.0)));
        text2.setFont(Font.font(null, (FontWeight)FontWeight.LIGHT, (double)(this.font.getSize() - 3.0)));
        text3.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)(this.font.getSize() + 25.0)));
        int n = 24;
        while (d > 0.0 && text3.getLayoutBounds().getWidth() > d - 26.0) {
            text3.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)(this.font.getSize() + (double)n--)));
        }
        text.setTranslateX(0.0);
        text.setTranslateY(text.getLayoutBounds().getHeight());
        text2.setTranslateX(0.0);
        text2.setTranslateY(text.getLayoutBounds().getHeight() + 10.0);
        Bounds bounds = text3.getLayoutBounds();
        double d3 = d / 2.0 - bounds.getWidth() / 2.0;
        text3.setTranslateX(d3);
        double d4 = d2 / 2.0 + bounds.getHeight() / 2.0;
        text3.setTranslateY(d4);
        arrayList.add(text);
        arrayList.add(text2);
        arrayList.add(text3);
        this.getChildren().setAll(arrayList);
    }
}

