/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.object;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.object.DBDefObject;
import oracle.dbtools.raptor.timesten.grid.object.DistributionMap;
import oracle.dbtools.raptor.timesten.grid.object.Element;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyElement;
import oracle.ide.Ide;

public class DatabaseObject {
    private DistributionMap currentDistMap;
    private List<Element> elements;
    private List<String> elementsRemoved;
    private Map<Element, List<ElementConnection>> elementConnectionDetails;
    private List<ElementConnection> allElementConnectionDetails;
    private boolean statusAvailable;
    private LoadReadiness loadReadiness = LoadReadiness.UNKNOWN;
    private List<String> notLoadableRSs;
    private DBDefObject dbdef;
    private GridObject currentGrid;
    private String name;
    private Logger _logger = Logger.getLogger(DatabaseObject.class.getName());
    private int connections;
    private int appConnections;
    private DBStatus dbStatus;
    public static final String SQL_DEV_CONN_NAME = "SQLDEV_SEL_GVDATASTORE";
    private static final String ROWRXP = "<(.*),([0-9|\\s]+),(.*),(.*),(.*),(.*),([0-9\\s]+),([0-9\\s]+)>";

    public boolean isStatusAvailable() {
        return this.statusAvailable;
    }

    private void setStatusAvailable(boolean bl) {
        this.statusAvailable = bl;
    }

    public DatabaseObject(GridObject gridObject, DBDefObject dBDefObject, String string) {
        this.name = string;
        this.currentDistMap = new DistributionMap(gridObject.getProperties().getK());
        this.elementConnectionDetails = new HashMap<Element, List<ElementConnection>>();
        this.allElementConnectionDetails = new ArrayList<ElementConnection>();
        this.elements = new ArrayList<Element>();
        this.elementsRemoved = new ArrayList<String>();
        this.currentGrid = gridObject;
        this.dbdef = dBDefObject;
        this.statusAvailable = false;
        this.dbStatus = new DBStatus();
        this.notLoadableRSs = new ArrayList<String>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public DBStatus getDBStatus() {
        return this.dbStatus;
    }

    public List<Element> getAllElements() {
        return this.elements;
    }

    public Set<Element> getElementInDistMap() {
        HashSet<Element> hashSet = new HashSet<Element>();
        for (TopologyElement topologyElement : this.currentDistMap.getElementsInTopology()) {
            hashSet.add((Element)topologyElement);
        }
        return hashSet;
    }

    public DistributionMap getDistributionMap() {
        return this.currentDistMap;
    }

    public void setDBDef(DBDefObject dBDefObject) {
        this.dbdef = dBDefObject;
    }

    public DBDefObject getDBDef() {
        return this.dbdef;
    }

    public int getConnections() {
        if (this.connections != 0) {
            return this.connections;
        }
        return this.allElementConnectionDetails != null ? this.allElementConnectionDetails.size() : this.connections;
    }

    public int getAppConnections() {
        return this.appConnections;
    }

    public int getSystemConnections() {
        return this.connections - this.appConnections;
    }

    public void resetConnectionDetails() {
        this.allElementConnectionDetails.clear();
        this.elementConnectionDetails.clear();
        this.connections = 0;
        this.appConnections = 0;
    }

    public void updateDBStatus(JsonObject jsonObject) {
        try {
            JsonObject jsonObject22;
            JsonArray jsonArray = jsonObject.getJsonArray("databases");
            JsonObject jsonObject3 = jsonArray == null ? jsonObject : (JsonObject)jsonArray.getValuesAs(JsonObject.class).get(0);
            this.elements.clear();
            this.currentDistMap.clear();
            this.getElementInDistMap().clear();
            this.getDBDef().setGUID(jsonObject3.getString("dbdefGuid"));
            JsonArray jsonArray2 = jsonObject3.getJsonArray("instances");
            for (JsonObject jsonObject22 : jsonArray2.getValuesAs(JsonObject.class)) {
                InstanceObject instanceObject;
                HostObject hostObject = this.currentGrid.getHost(jsonObject22.getString("hostName"));
                if (hostObject == null || (instanceObject = this.currentGrid.getInstance(hostObject, jsonObject22.getString("instanceName"))) == null) continue;
                instanceObject.setInMembership(jsonObject22.getBoolean("inMembership"));
                JsonObject jsonObject4 = (JsonObject)jsonObject22.getJsonArray("elements").getValuesAs(JsonObject.class).get(0);
                Element element = new Element();
                try {
                    element.setLastChangeStart(Common.DBSTATUSDATEFORMAT.parse(jsonObject4.getString("lastChangeStart")));
                    element.setLastChangeEnd(Common.DBSTATUSDATEFORMAT.parse(jsonObject4.getString("lastChangeEnd")));
                    element.setLastChangeCode(jsonObject4.getString("lastChangeCode"));
                }
                catch (Exception exception) {
                    this._logger.log(Level.INFO, "Last change start/end/code, not available in dbStatus.");
                }
                element.setReplicaSet(jsonObject4.getInt("syncReplicaSet"));
                element.setInstance(instanceObject);
                element.setAddInNextDistMap(jsonObject4.getString("addInNextDistMap").equalsIgnoreCase("Y"));
                element.setRemoveInNextDistMap(jsonObject4.getString("removeInNextDistMap").equalsIgnoreCase("Y"));
                if (element.getReplicaSet() <= 0) {
                    element.setInCurrentDistMap(false);
                } else {
                    element.setInCurrentDistMap(jsonObject4.getString("inCurDistMap").equalsIgnoreCase("Y"));
                }
                element.setInPreviousDistMap(jsonObject4.getString("inPrevDistMap").equalsIgnoreCase("Y"));
                element.setId(jsonObject4.getInt("elementNumber"));
                try {
                    if (instanceObject.inMembership()) {
                        element.setState(jsonObject4.getString("state"));
                    } else {
                        element.setState("Down");
                    }
                }
                catch (Exception exception) {
                    element.setState(Messages.getString("TimesTen.common.unknown"));
                }
                try {
                    element.setMessage(jsonObject4.getString("lastChangeMsg"));
                }
                catch (Exception exception) {
                    element.setMessage("");
                }
                if (this.elementsRemoved.contains(element.getInstance().getFullName())) continue;
                this.currentDistMap.save(element);
                this.getAllElements().add(element);
            }
            JsonObject jsonObject5 = jsonObject3.getJsonObject("overall");
            jsonObject22 = jsonObject5.getJsonArray("summary");
            this.dbStatus.update(jsonObject5, (JsonArray)jsonObject22);
            this.setStatusAvailable(true);
        }
        catch (Exception exception) {
            String string = MessageFormat.format(Messages.getString("TimesTenGrid.updateObjFailed"), exception.getMessage());
            this._logger.log(Level.SEVERE, string);
        }
    }

    public void searchRemovedElements(JsonObject jsonObject) {
        try {
            JsonObject jsonObject2 = jsonObject.getJsonObject("rs");
            if (jsonObject2 == null) {
                throw new Exception();
            }
            this.elementsRemoved.clear();
            JsonArray jsonArray = jsonObject2.getJsonArray("-1");
            for (JsonObject jsonObject3 : jsonArray.getValuesAs(JsonObject.class)) {
                if (!jsonObject3.getString("isRemoved").equals("Y") && !jsonObject3.getString("isEvicted").equals("Y")) continue;
                this.elementsRemoved.add(jsonObject3.getString("hostName") + "." + jsonObject3.getString("instanceName"));
            }
        }
        catch (Exception exception) {
            String string = MessageFormat.format(Messages.getString("TimesTenGrid.updateObjFailed"), exception.getMessage());
            this._logger.log(Level.SEVERE, string);
        }
    }

    public List<ElementConnection> getElementsConnections() {
        return this.allElementConnectionDetails;
    }

    public List<ElementConnection> getElementsConnectionsByID(int n) {
        return this.elementConnectionDetails.get(this.getElementByID(n));
    }

    public List<ElementConnection> getElementsConnections(Element element) {
        return this.elementConnectionDetails.get(element);
    }

    public Element getElementByInstanceName(String string) {
        for (Element element : this.elements) {
            if (!element.toString().equalsIgnoreCase(string)) continue;
            return element;
        }
        return null;
    }

    public LoadReadiness getLoadReadiness() {
        return this.loadReadiness;
    }

    public void updateConnectionDetails(String string) {
        Object object;
        if (string == null) {
            oracle.dbtools.util.Logger.severe(DatabaseObject.class, (String)"Cannot parse GV$datastore output");
            return;
        }
        this.elementConnectionDetails.clear();
        this.allElementConnectionDetails.clear();
        for (Element object22 : this.elements) {
            this.elementConnectionDetails.put(object22, new ArrayList());
        }
        Matcher matcher = Pattern.compile(ROWRXP).matcher(string);
        String string2 = ".*[\\/\\\\](.*)";
        while (matcher.find()) {
            object = new ElementConnection();
            ((ElementConnection)object).setDatastore(matcher.group(1).trim());
            ((ElementConnection)object).setPID(Integer.parseInt(matcher.group(2).trim()));
            ((ElementConnection)object).setCtx(matcher.group(3).trim());
            ((ElementConnection)object).setContype(matcher.group(4).trim());
            ((ElementConnection)object).setSHMID(matcher.group(5).trim());
            ((ElementConnection)object).setConnectionName(matcher.group(6).trim());
            ((ElementConnection)object).setConnId(Integer.parseInt(matcher.group(7).trim()));
            int n = Integer.parseInt(matcher.group(8).trim());
            Matcher matcher2 = Pattern.compile(string2).matcher(((ElementConnection)object).getDatastore());
            if (!matcher2.matches() || !matcher2.group(1).equals(this.name) || ((ElementConnection)object).getConnectionName().equalsIgnoreCase(SQL_DEV_CONN_NAME)) continue;
            Element element = this.getElementByID(n);
            if (element == null) {
                oracle.dbtools.util.Logger.severe(DatabaseObject.class, (String)("Element not found in internal database object:" + n));
                continue;
            }
            ((ElementConnection)object).setElement(element);
            if (!this.elementConnectionDetails.containsKey(element)) {
                this.elementConnectionDetails.put(element, new ArrayList());
            }
            this.elementConnectionDetails.get(element).add((ElementConnection)object);
            this.allElementConnectionDetails.add((ElementConnection)object);
        }
        object = new Comparator<ElementConnection>(){

            @Override
            public int compare(ElementConnection elementConnection, ElementConnection elementConnection2) {
                return elementConnection.getContype().compareToIgnoreCase(elementConnection2.getContype());
            }
        };
        this.allElementConnectionDetails.sort((Comparator<ElementConnection>)object);
        for (Element element : this.elementConnectionDetails.keySet()) {
            this.elementConnectionDetails.get(element).sort((Comparator<ElementConnection>)object);
        }
    }

    public void updateConnectionCount(int[] nArray) {
        if (nArray == null) {
            oracle.dbtools.util.Logger.severe(DatabaseObject.class, (String)"Cannot parse GV$datastore output");
            return;
        }
        this.connections = nArray[0];
        this.appConnections = nArray[1];
    }

    public Element getElementByID(int n) {
        for (Element element : this.getElementInDistMap()) {
            if (element.getId() != n) continue;
            return element;
        }
        return null;
    }

    public void updateLoadReadiness() throws GridCommandException {
        GridCommand gridCommand = GridCommand.DB_LOAD_READINESS;
        gridCommand.prepareCommand(this.name);
        JsonObject jsonObject = this.currentGrid.getExecutor().executeCommandGetJson(gridCommand, true);
        this.notLoadableRSs.clear();
        if (jsonObject != null && jsonObject.containsKey((Object)"Load Readiness")) {
            String string = jsonObject.getString("Load Readiness").trim();
            if (string.equalsIgnoreCase("Loadable")) {
                this.loadReadiness = LoadReadiness.YES;
            } else if (string.equalsIgnoreCase("Not Loadable")) {
                this.loadReadiness = LoadReadiness.NO;
                JsonArray jsonArray = jsonObject.getJsonArray("Replica Sets");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject jsonObject2 = jsonArray.getJsonObject(i);
                    String string2 = jsonObject2.getString("State").trim();
                    if (!string2.equalsIgnoreCase("Not loadable")) continue;
                    this.notLoadableRSs.add(MessageFormat.format(Messages.getString("TimesTenGrid.DBReplicaSet"), jsonObject2.getString("rs")));
                }
            } else {
                this.loadReadiness = string.equalsIgnoreCase("Loaded") ? LoadReadiness.ALREADY_LOADED : LoadReadiness.UNKNOWN;
            }
        }
    }

    public void tryToLoadStart(final boolean bl) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                try {
                    DatabaseObject.this.updateLoadReadiness();
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            LoadReadiness loadReadiness = DatabaseObject.this.getLoadReadiness();
                            if (loadReadiness == LoadReadiness.ALREADY_LOADED && !bl) {
                                Common.displayErrorMsg((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.databaseAlreadyLoaded"), DatabaseObject.this.name));
                            } else if (loadReadiness == LoadReadiness.NO) {
                                Common.displayErrorMsg((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.dbCantBeLoadedRS"), DatabaseObject.this.name, String.join((CharSequence)", ", DatabaseObject.this.notLoadableRSs)));
                            } else if (bl) {
                                GridCommand gridCommand = GridCommand.PERL_START_DATABASE;
                                gridCommand.prepareCommand(DatabaseObject.this.name);
                                DatabaseObject.this.currentGrid.executePerlCommandOnRaptorTask(MessageFormat.format(Messages.getString("TimesTenGrid.startingDBCommand"), DatabaseObject.this.name), gridCommand, new Runnable(){

                                    @Override
                                    public void run() {
                                        Common.displayInfoMsg(null, MessageFormat.format(Messages.getString("TimesTenGrid.startDBStarted"), DatabaseObject.this.name), Messages.getString("TimesTenGrid.commandIssued"));
                                    }
                                });
                            } else {
                                GridCommand gridCommand = GridCommand.LOAD_DATABASE;
                                gridCommand.prepareCommand(DatabaseObject.this.name);
                                DatabaseObject.this.currentGrid.executeCommandOnRaptorTask(MessageFormat.format(Messages.getString("TimesTenGrid.loadingDBCommand"), DatabaseObject.this.name), gridCommand, new Runnable(){

                                    @Override
                                    public void run() {
                                        Common.displayInfoMsg(null, MessageFormat.format(Messages.getString("TimesTenGrid.loadDBStarted"), DatabaseObject.this.name), Messages.getString("TimesTenGrid.commandIssued"));
                                    }
                                }, false);
                            }
                        }
                    };
                    runnable.run();
                }
                catch (GridCommandException gridCommandException) {
                    Common.displayErrorMsg(null, gridCommandException.getMessage());
                    DatabaseObject.this._logger.severe(gridCommandException.getMessage());
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(MessageFormat.format(Messages.getString("TimesTenGrid.gettingLoadReadiness"), this.name));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public boolean isAllInstanceStatusUnknown() {
        for (Element element : this.getAllElements()) {
            if (!element.getInstance().isStatusAvailable()) continue;
            return false;
        }
        return true;
    }

    public class DBStatus {
        private int nInstances;
        private int nDown;
        private int nCreated;
        private int nCreateFailed;
        private int nInstancesOpened;
        private int nInstancesLoaded;
        private int nCreating;
        private int nLoading;
        private String summary;
        private boolean nonExistent;
        private boolean unknown;

        public DBStatus() {
            this.setUnknown(true);
        }

        public int getNInstances() {
            return this.nInstances;
        }

        public int getNDown() {
            return this.nDown;
        }

        public int getNCreated() {
            return this.nCreated;
        }

        public int getNCreateFailed() {
            return this.nCreateFailed;
        }

        public int getNInstancesOpened() {
            return this.nInstancesOpened;
        }

        public int getNInstancesLoaded() {
            return this.nInstancesLoaded;
        }

        public int getNCreating() {
            return this.nCreating;
        }

        public int getNLoading() {
            return this.nLoading;
        }

        public String getSummary() {
            return this.summary;
        }

        void update(JsonObject jsonObject, JsonArray jsonArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < jsonArray.size(); ++i) {
                stringBuilder.append(((JsonValue)jsonArray.get(i)).toString().replaceAll("\"", ""));
                if (i >= jsonArray.size() - 1) continue;
                stringBuilder.append(", ");
            }
            this.summary = stringBuilder.toString();
            this.unknown = false;
            this.nInstances = jsonObject.getInt("nInstances");
            this.nDown = jsonObject.getInt("nDown");
            this.nCreated = jsonObject.getInt("nCreated");
            this.nCreateFailed = jsonObject.getInt("nCreateFailed");
            this.nInstancesOpened = jsonObject.getInt("nInstancesOpened");
            this.nInstancesLoaded = jsonObject.getInt("nInstancesLoaded");
            this.nCreating = jsonObject.getInt("nCreating");
            this.nLoading = jsonObject.getInt("nLoading");
        }

        public boolean isLoaded() {
            return this.nInstances > 0 && this.nInstances == this.nInstancesLoaded;
        }

        public boolean isPartiallyLoaded() {
            return this.nInstancesLoaded > 0 && this.nInstancesLoaded < this.nInstances;
        }

        public boolean isLoading() {
            return this.nLoading > 0;
        }

        public boolean isOpen() {
            return this.nInstances > 0 && this.nInstances == this.nInstancesOpened;
        }

        public boolean isPartiallyOpen() {
            return this.nInstancesOpened > 0 && this.nInstancesOpened < this.nInstances;
        }

        public void setNonExistent(boolean bl) {
            this.nonExistent = bl;
        }

        public boolean isNonExistent() {
            return this.nonExistent;
        }

        public void setUnknown(boolean bl) {
            this.unknown = bl;
            if (bl) {
                this.summary = Messages.getString("TimesTen.common.unknown");
            }
        }

        public boolean isUnknown() {
            return this.unknown;
        }
    }

    public static enum LoadReadiness {
        YES(Messages.getString("TimesTen.common.yes")),
        NO(Messages.getString("TimesTen.common.no")),
        ALREADY_LOADED(Messages.getString("TimesTenGrid.DBAlreadyLoaded")),
        UNKNOWN(Messages.getString("TimesTen.common.unknown"));

        String message;

        private LoadReadiness(String string2) {
            this.message = string2;
        }

        public String toString() {
            return this.message;
        }
    }

    public static class ElementConnection {
        private String datastore;
        private int PID;
        private String ctx;
        private String contype;
        private String SHMID;
        private String connectionName;
        private int connId;
        private Element element;

        public String getDatastore() {
            return this.datastore;
        }

        public void setDatastore(String string) {
            this.datastore = string;
        }

        public int getPID() {
            return this.PID;
        }

        public void setPID(int n) {
            this.PID = n;
        }

        public String getCtx() {
            return this.ctx;
        }

        public void setCtx(String string) {
            this.ctx = string;
        }

        public String getContype() {
            return this.contype;
        }

        public void setContype(String string) {
            this.contype = string;
        }

        public String getSHMID() {
            return this.SHMID;
        }

        public void setSHMID(String string) {
            this.SHMID = string;
        }

        public String getConnectionName() {
            return this.connectionName;
        }

        public void setConnectionName(String string) {
            this.connectionName = string;
        }

        public int getConnId() {
            return this.connId;
        }

        public void setConnId(int n) {
            this.connId = n;
        }

        public Element getElement() {
            return this.element;
        }

        public void setElement(Element element) {
            this.element = element;
        }

        public boolean isAppConnection() {
            return ElementConnection.isAppConnection(this.contype);
        }

        public static boolean isAppConnection(String string) {
            return string.equals("application") || string.equals("server");
        }
    }
}

