/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.loginspector;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oracle.dbtools.raptor.timesten.grid.loginspector.InstanceLogTablePanel;
import oracle.dbtools.raptor.timesten.grid.loginspector.LogFilter;
import oracle.dbtools.raptor.timesten.grid.loginspector.TTLogEntry;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;

public class InstanceLogWrapper {
    private InstanceObject instance;
    private List<TTLogEntry> logMessages;
    private List<DateLineMsg> dateLines;
    private File logFile;
    private boolean logLoaded;
    private long logLineCount;
    private int filtrVersionUsed;
    private LogFilter filter;
    private long lastLineRead;
    private String lastKnownDate;
    private static final Pattern TT_MSG_PATTERN = Pattern.compile("^(\\d\\d:\\d\\d:\\d\\d\\.\\d\\d\\d) ([A-Z ][a-z ]*):([ A-Z]+):\\s*(\\d+):\\s*(.*)");
    private static final Pattern TT_STARTED_ON_PATTERN = Pattern.compile("started\\s+on\\s+(\\d\\d\\d\\d-\\d\\d-\\d\\d)");
    private static final Pattern MIDNIGHT_MSG_PATTERN = Pattern.compile("<< Date :.+00:0\\d:\\d\\d.+>>");
    private static final SimpleDateFormat SDF_DATE_ONLY = new SimpleDateFormat("yyyy-MM-dd");
    private static final Logger logger = Logger.getLogger(InstanceLogWrapper.class.getName());

    public InstanceLogWrapper(InstanceObject instanceObject) {
        this.instance = instanceObject;
        this.logLoaded = false;
        this.lastKnownDate = "";
        this.filtrVersionUsed = 0;
        this.logMessages = new ArrayList<TTLogEntry>();
        this.filter = LogFilter.getFilterObjectInstance();
        this.lastLineRead = 0L;
    }

    public boolean isLogLoaded() {
        return this.logLoaded;
    }

    public void setLogLoaded(boolean bl) {
        this.logLoaded = bl;
    }

    public InstanceObject getInstance() {
        return this.instance;
    }

    public List<TTLogEntry> getLogMessages() {
        return this.logMessages;
    }

    public void setLogMessages(ArrayList<TTLogEntry> arrayList) {
        this.logMessages = arrayList;
    }

    public File getLogFile() {
        if (this.logFile == null) {
            this.logFile = this.createTempLogFile();
        }
        return this.logFile;
    }

    public void setLogFile(File file) {
        this.logFile = file;
    }

    public int getNextEntryIndexContaining(String string, int n) {
        Pattern pattern = Pattern.compile(".*" + string + ".*");
        OptionalInt optionalInt = this.logMessages.stream().skip(Math.max(0, n + 1)).filter(tTLogEntry -> pattern.matcher(tTLogEntry.getMessage()).matches()).mapToInt(tTLogEntry -> this.logMessages.indexOf(tTLogEntry)).findFirst();
        return optionalInt.isPresent() ? optionalInt.getAsInt() : -1;
    }

    public int getNextEntryIndexContaining(String string, int n, int n2) {
        Pattern pattern = Pattern.compile(".*" + string + ".*");
        OptionalInt optionalInt = this.logMessages.stream().skip(Math.max(0, n + 1)).limit(n2).filter(tTLogEntry -> pattern.matcher(tTLogEntry.getMessage()).matches()).mapToInt(tTLogEntry -> this.logMessages.indexOf(tTLogEntry)).findFirst();
        return optionalInt.isPresent() ? optionalInt.getAsInt() : -1;
    }

    public void parseFirstLines() {
        if (this.filtrVersionUsed == this.filter.getFilterVersion()) {
            logger.info("Filtered messages up to date. No need to recompute");
        }
        this.logMessages.clear();
        try {
            this.logLineCount = this.lastLineRead = Files.lines(Paths.get(this.getLogFile().getCanonicalPath(), new String[0])).count();
        }
        catch (IOException iOException) {
            logger.severe("Error while counting lines from " + this.getInstance().getFullName());
            logger.severe(iOException.getMessage());
        }
        try {
            Throwable object = null;
            try (LineNumberReader lineNumberReader = new LineNumberReader(Files.newBufferedReader(Paths.get(this.getLogFile().getCanonicalPath(), new String[0])));){
                this.dateLines = lineNumberReader.lines().filter(string -> TT_STARTED_ON_PATTERN.matcher((CharSequence)string).find() || MIDNIGHT_MSG_PATTERN.matcher((CharSequence)string).find()).map(string -> new DateLineMsg(lineNumberReader.getLineNumber(), (String)string)).collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throw throwable;
            }
        }
        catch (IOException iOException) {
            logger.severe("Error while reading dates from " + this.getInstance().getFullName());
            logger.severe(iOException.getMessage());
        }
        this.lastKnownDate = "";
        for (DateLineMsg dateLineMsg : this.dateLines) {
            this.lastKnownDate = dateLineMsg.setDate(this.lastKnownDate);
        }
        this.readPreviousMessages(InstanceLogTablePanel.MAX_INITIAL_LINES_TO_SHOW);
    }

    public synchronized boolean readPreviousMessages(long l) {
        if (this.lastLineRead == 0L) {
            logger.info("No more lines to read from log file " + this.instance.getFullName());
            return false;
        }
        logger.info("Attempting to fetch " + l + " more lines from log file " + this.instance.getFullName());
        int n = this.logMessages.size();
        while ((long)this.logMessages.size() < (long)n + l) {
            List<Object> list = new ArrayList();
            long l2 = this.lastLineRead;
            this.lastLineRead = this.filter.isFilterClear() ? (this.lastLineRead -= l) : (this.lastLineRead -= 10L * l);
            this.lastLineRead = Math.max(0L, this.lastLineRead);
            try {
                LineNumberReader lineNumberReader = new LineNumberReader(Files.newBufferedReader(Paths.get(this.getLogFile().getCanonicalPath(), new String[0])));
                Object object = null;
                try {
                    list = lineNumberReader.lines().skip(this.lastLineRead).limit(l2 - this.lastLineRead).map(string -> new TTLogEntry(lineNumberReader.getLineNumber(), (String)string)).collect(Collectors.toList());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (lineNumberReader != null) {
                        if (object != null) {
                            try {
                                lineNumberReader.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            lineNumberReader.close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                logger.severe("Error while reading  from " + this.getInstance().getFullName());
                logger.severe(iOException.getMessage());
            }
            Collections.reverse(list);
            for (Object object : list) {
                ((TTLogEntry)object).setDate(this.dateLines);
                if (this.filter.messageMatchesAllCriteria((TTLogEntry)object)) {
                    this.logMessages.add((TTLogEntry)object);
                }
                if ((long)this.logMessages.size() < (long)n + l) continue;
                this.lastLineRead = Math.max(0, this.logMessages.get(this.logMessages.size() - 1).getLineNo() - 1);
                break;
            }
            if (this.lastLineRead > 0L) continue;
            this.lastLineRead = 0L;
            break;
        }
        this.filtrVersionUsed = this.filter.getFilterVersion();
        return (long)this.logMessages.size() >= (long)n + l;
    }

    public synchronized void readPreviousMessagesOnNewThread(long l, Runnable runnable) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(() -> {
            this.readPreviousMessages(l);
            runnable.run();
            executorService.shutdown();
        });
    }

    public synchronized void readAllPreviousMessages(Runnable runnable) {
        this.readPreviousMessagesOnNewThread(this.lastLineRead, runnable);
    }

    private File createTempLogFile() {
        File file = null;
        try {
            file = File.createTempFile(this.instance.getFullName() + "ttmesg", ".log");
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            Logger.getLogger(InstanceLogWrapper.class.getName()).log(Level.SEVERE, "While creating temporary file for instance " + this.instance.getFullName() + ":" + iOException.getMessage());
        }
        return file;
    }

    protected static class DateLineMsg {
        private int lineNo;
        private String line;
        private String date;

        public DateLineMsg(int n, String string) {
            this.lineNo = n;
            this.line = string;
            Matcher matcher = TT_STARTED_ON_PATTERN.matcher(string);
            if (matcher.find()) {
                this.date = matcher.group(1);
            }
        }

        public int getLineNo() {
            return this.lineNo;
        }

        public String getDate() {
            return this.date;
        }

        public String setDate(String string) {
            Matcher matcher = MIDNIGHT_MSG_PATTERN.matcher(this.line);
            if (!matcher.find()) {
                return this.date;
            }
            try {
                Date date = SDF_DATE_ONLY.parse(string);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(5, 1);
                date = calendar.getTime();
                this.date = SDF_DATE_ONLY.format(date);
            }
            catch (ParseException parseException) {
                logger.severe("Error while parsing date:" + string);
            }
            return this.date;
        }

        public String getLine() {
            return this.line;
        }
    }
}

