/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.Component;
import javax.json.JsonException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyPanel;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpInfo;

public class HostFolderEditor
extends TTBaseEditor {
    private TopologyPanel _topologyPanel;

    public HostFolderEditor() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        if (!this.initialized) {
            this.currentGrid = TTGridRootNode.getInstance().getGrid(TTGridRootNode.getInstance().getCurrentGrid());
            this._topologyPanel = new TopologyPanel(this.currentGrid.getHostTopology(), true);
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.dsgAssign"), (Component)((Object)this._topologyPanel));
            this.helpInfo = new HelpInfo(TimesTenHelpID.HOST_FOLDER_EDITOR.toString());
            this.initialized = true;
        }
    }

    @Override
    public void updateContent() {
        this._topologyPanel.setTopology(this.currentGrid.getHostTopology());
        this._topologyPanel.updateDraw();
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        super.handleEvent(ideAction, context);
        if (ideAction.getCommandId() == REFRESH_ID) {
            this.refreshInfo();
            return true;
        }
        return false;
    }

    private void refreshInfo() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){
            StringBuilder errorMessage;
            {
                this.errorMessage = new StringBuilder("");
            }

            protected Void doWork() throws TaskException {
                try {
                    HostFolderEditor.this.currentGrid.getGridCurrentModel().diff(HostFolderEditor.this.currentGrid);
                    HostFolderEditor.this._topologyPanel.setTopology(HostFolderEditor.this.currentGrid.getHostTopology());
                    HostFolderEditor.this._topologyPanel.updateDraw();
                }
                catch (JsonException jsonException) {
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), this.errorMessage.toString());
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(Messages.getString("TimesTenGrid.refreshingGrid"));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }
}

