/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.navigator.AbstractNode;
import oracle.dbtools.raptor.timesten.grid.object.ConfigObject;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpInfo;

public class ConfigObjectEditor
extends TTBaseEditor {
    private ConfigPanel _configPanel;

    public ConfigObjectEditor() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        if (!this.initialized) {
            this._configPanel = new ConfigPanel();
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.content"), this._configPanel);
            this.helpInfo = new HelpInfo(TimesTenHelpID.CONF_OBJ_EDITOR.toString());
            this.initialized = true;
        }
    }

    @Override
    public void updateContent() {
        this._configPanel.updateInfo();
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == REFRESH_ID) {
            this._configPanel.updateInfo();
            return true;
        }
        return false;
    }

    class ConfigPanel
    extends JPanel {
        private JTextArea _contentTxtArea;

        public ConfigPanel() {
            this.init();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            this._contentTxtArea = new JTextArea();
            this._contentTxtArea.setEditable(false);
            this.add((Component)this._contentTxtArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        }

        public void updateInfo() {
            AbstractNode abstractNode = (AbstractNode)ConfigObjectEditor.this.context.getNode();
            ConfigObject configObject = null;
            if (ConfigObjectEditor.this.currentGrid == null) {
                return;
            }
            if (abstractNode.isMembershipConfigNode()) {
                configObject = ConfigObjectEditor.this.currentGrid.getMembershipConfiguration();
            } else if (abstractNode.isInstanceConfigNode()) {
                configObject = ConfigObjectEditor.this.currentGrid.getInstanceConfiguration();
            } else if (abstractNode.isSQLNetNode()) {
                configObject = ConfigObjectEditor.this.currentGrid.getSQLNet();
            } else if (abstractNode.isTNSNamesNode()) {
                configObject = ConfigObjectEditor.this.currentGrid.getTNSNames();
            }
            if (configObject != null) {
                this._contentTxtArea.setText(configObject.getContent());
            }
        }
    }
}

