/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyElement;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class WizardDistribute
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private GridObject currentGrid = TTGridRootNode.getInstance().getGrid(TTGridRootNode.getInstance().getCurrentGrid());
    private TopologyPanel _topology;
    private JCheckBox _skipDistBtn;
    private DatabaseObject db;

    public WizardDistribute() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this._topology = new TopologyPanel(null, false);
        this._skipDistBtn = new JCheckBox(Messages.getString("TimesTenGrid.skipDist"));
        this._skipDistBtn.setName(Messages.getString("TimesTenGrid.skipDist"));
        this._skipDistBtn.setSelected(false);
        this.add((Component)((Object)this._topology), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add(this._skipDistBtn, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 24, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.dbDist")));
    }

    public void onEntry(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        this.db = (DatabaseObject)traversableContext.get("DF_DEF_ATTRIBUTES");
        this._topology.setDistributionMap(this.db.getDistributionMap(), "TODO:");
        for (TopologyElement topologyElement : this.db.getDistributionMap().getMaxAddableElements()) {
            this.db.getDistributionMap().markToAdd(topologyElement);
        }
        this._topology.updateDraw();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        traversableContext.put("addInNextDistMap", (Object)this._skipDistBtn.isSelected());
        if (!this._skipDistBtn.isSelected()) {
            // empty if block
        }
    }

    public Object getExitTransition() {
        return "Summary";
    }
}

