/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.grid.object.Element;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyElement;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyPanel;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class DatabaseDistributionPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton _applyChgsBtn;
    private JButton _closeBtn;
    private JEWTDialog _dialog;
    private TopologyPanel topology;
    private DatabaseObject currentDB;
    private GridObject currentGrid;
    private Logger _logger = Logger.getLogger(DatabaseDistributionPanel.class.getName());

    public DatabaseDistributionPanel(GridObject gridObject, DatabaseObject databaseObject) {
        this.currentDB = databaseObject;
        this.currentGrid = gridObject;
        this.initGUI();
        DatabaseUpdateWorker databaseUpdateWorker = new DatabaseUpdateWorker();
        databaseUpdateWorker.execute();
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this._applyChgsBtn = new JButton(Messages.getString("TimesTenGrid.saveApplyDistribution"));
        this._applyChgsBtn.setName(Messages.getString("TimesTenGrid.saveApplyDistribution"));
        this._closeBtn = new JButton(Messages.getString("TimesTenGrid.Close"));
        this._closeBtn.setName(Messages.getString("TimesTenGrid.Close"));
        this.topology = new TopologyPanel(this.currentDB.getDistributionMap(), "", false);
        this._closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DatabaseDistributionPanel.this.currentDB.getDistributionMap().changesPending()) {
                    if (MessageDialog.confirm((Component)DatabaseDistributionPanel.this._dialog, (Object)Messages.getString("TimesTenGrid.distMapChanged"), (String)Messages.getString("TimesTenGrid.pendingChanges"), null, (boolean)false)) {
                        DatabaseDistributionPanel.this._dialog.dispose();
                    }
                } else {
                    DatabaseDistributionPanel.this._dialog.dispose();
                }
            }
        });
        this._applyChgsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DatabaseDistributionPanel.this.validateDistribution()) {
                    DistributionMapWorker distributionMapWorker = new DistributionMapWorker(true);
                    distributionMapWorker.execute();
                }
            }
        });
        this.add((Component)((Object)this.topology), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.instanceDist")));
    }

    private boolean validateDistribution() {
        int n;
        int n2 = this.currentDB.getDistributionMap().getKSafety();
        int n3 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < n2; ++n) {
            int n4 = this.currentDB.getDistributionMap().getElementsMarkedToAdd(n + 1).size();
            Set<TopologyElement> set = this.currentDB.getDistributionMap().getElementsInTopologyHideRemoved(n + 1);
            set.removeAll(this.currentDB.getDistributionMap().getToEvict());
            set.removeAll(this.currentDB.getDistributionMap().getToRemoveReplace().keySet());
            arrayList.add(set.size() + n4);
            if ((Integer)arrayList.get(n) == 0) {
                ++n3;
            }
            set.clear();
        }
        if (n3 == n2) {
            Common.displayErrorMsg((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.removeAllInstances"));
            return false;
        }
        int n5 = (Integer)arrayList.get(0);
        for (n = 0; n < n2; ++n) {
            if ((Integer)arrayList.get(n) == 0) {
                Common.displayErrorMsg((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.errorOneReplicaSet"));
                return false;
            }
            if (n5 == (Integer)arrayList.get(n)) continue;
            Common.displayErrorMsg((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.dataSpaceGroupsBalanced"));
            return false;
        }
        return true;
    }

    public JButton get_applyChgsBtn() {
        return this._applyChgsBtn;
    }

    public JButton get_closeBtn() {
        return this._closeBtn;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void setDialog(JEWTDialog jEWTDialog) {
        this._dialog = jEWTDialog;
    }

    public static void showDialog(GridObject gridObject, DatabaseObject databaseObject) {
        DatabaseDistributionPanel databaseDistributionPanel = new DatabaseDistributionPanel(gridObject, databaseObject);
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)databaseDistributionPanel, (String)MessageFormat.format(Messages.getString("TimesTenGrid.distributionTitle"), databaseObject.getName()), (ActionListener)databaseDistributionPanel);
        databaseDistributionPanel.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(4);
        Dimension dimension = new Dimension(700, 600);
        jEWTDialog.setSize(dimension);
        jEWTDialog.setResizable(false);
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.addCustomButton((Component)databaseDistributionPanel.get_applyChgsBtn());
        jEWTDialog.addCustomButton((Component)databaseDistributionPanel.get_closeBtn());
        HelpSystem.getHelpSystem().registerTopic((JComponent)databaseDistributionPanel, TimesTenHelpID.DB_REDISTRIBUTE.toString());
        jEWTDialog.setVisible(true);
    }

    public void fetchDistributionMap(GridCommand gridCommand) throws GridCommandException {
        this.currentDB.getDistributionMap().clear();
        gridCommand = GridCommand.DB_DISTRIBUTE_LIST;
        gridCommand.prepareCommand(this.currentDB.getName());
        JsonObject jsonObject = this.currentGrid.getExecutor().executeCommandGetJson(gridCommand, true);
        this.currentDB.searchRemovedElements(jsonObject);
        gridCommand = GridCommand.DB_STATUS;
        gridCommand.prepareCommand(this.currentDB.getName());
        JsonObject jsonObject2 = this.currentGrid.getExecutor().executeCommandGetJson(gridCommand, true);
        this.currentDB.updateDBStatus(jsonObject2);
    }

    private class DistributionMapWorker
    extends SwingWorker<Void, Void> {
        private CustomProgressMonitor progressMonitor;
        private boolean applyChanges;

        public DistributionMapWorker(boolean bl) {
            this.applyChanges = bl;
            this.progressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.performingOperations"), "", null);
            this.addPropertyChangeListener(this.progressMonitor);
            this.progressMonitor.setSwingWorker(this);
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.progressMonitor.start();
            try {
                TopologyElement topologyElement;
                GridCommand gridCommand = null;
                for (TopologyElement topologyElement2 : DatabaseDistributionPanel.this.currentDB.getDistributionMap().getToAdd()) {
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.addingToDistMap"), ((Element)topologyElement2).toString()));
                    gridCommand = GridCommand.DB_DISTRIBUTE_ADD;
                    gridCommand.prepareCommand(DatabaseDistributionPanel.this.currentDB.getName(), topologyElement2.toString());
                    DatabaseDistributionPanel.this.currentGrid.getExecutor().executeCommandGetString(gridCommand, false);
                }
                for (TopologyElement topologyElement2 : DatabaseDistributionPanel.this.currentDB.getDistributionMap().getToRemove()) {
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.removingFromDistMap"), ((Element)topologyElement2).toString()));
                    gridCommand = GridCommand.DB_DISTRIBUTE_REMOVE;
                    gridCommand.prepareCommand(DatabaseDistributionPanel.this.currentDB.getName(), topologyElement2.toString());
                    DatabaseDistributionPanel.this.currentGrid.getExecutor().executeCommandGetString(gridCommand, false);
                }
                for (TopologyElement topologyElement2 : DatabaseDistributionPanel.this.currentDB.getDistributionMap().getToRemoveReplace().keySet()) {
                    topologyElement = DatabaseDistributionPanel.this.currentDB.getDistributionMap().getToRemoveReplace().get(topologyElement2);
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.removingReplaceFromDistMap"), topologyElement2.toString(), topologyElement.toString()));
                    gridCommand = GridCommand.DB_DISTRIBUTE_REPLACE;
                    gridCommand.prepareCommand(DatabaseDistributionPanel.this.currentDB.getName(), ((Element)topologyElement2).toString(), ((Element)topologyElement).toString());
                    DatabaseDistributionPanel.this.currentGrid.getExecutor().executeCommandGetString(gridCommand, false);
                }
                for (TopologyElement topologyElement2 : DatabaseDistributionPanel.this.currentDB.getDistributionMap().getToEvict()) {
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.evicting"), ((Element)topologyElement2).toString()));
                    gridCommand = GridCommand.DB_DISTRIBUTE_EVICT;
                    gridCommand.prepareCommand(DatabaseDistributionPanel.this.currentDB.getName(), topologyElement2.toString());
                    DatabaseDistributionPanel.this.currentGrid.getExecutor().executeCommandGetString(gridCommand, false);
                }
                for (TopologyElement topologyElement2 : DatabaseDistributionPanel.this.currentDB.getDistributionMap().getToEvictReplace().keySet()) {
                    topologyElement = DatabaseDistributionPanel.this.currentDB.getDistributionMap().getToEvictReplace().get(topologyElement2);
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.evictingReplacing"), ((Element)topologyElement2).toString(), ((Element)topologyElement).toString()));
                    gridCommand = GridCommand.DB_DISTRIBUTE_EVICT_REPLACE;
                    gridCommand.prepareCommand(DatabaseDistributionPanel.this.currentDB.getName(), topologyElement2.toString(), topologyElement.toString());
                    DatabaseDistributionPanel.this.currentGrid.getExecutor().executeCommandGetString(gridCommand, false);
                }
                if (this.applyChanges) {
                    gridCommand = GridCommand.DB_DISTRIBUTE_APPLY;
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.applyDistMap"));
                    gridCommand.prepareCommand(DatabaseDistributionPanel.this.currentDB.getName());
                    DatabaseDistributionPanel.this.currentGrid.getExecutor().executeCommandGetString(gridCommand, false);
                }
                DatabaseDistributionPanel.this.fetchDistributionMap(gridCommand);
            }
            catch (JsonException | GridCommandException throwable) {
                DatabaseDistributionPanel.this._logger.log(Level.SEVERE, throwable.getMessage());
            }
            return null;
        }

        @Override
        protected void done() {
            DatabaseDistributionPanel.this._applyChgsBtn.setEnabled(false);
            DatabaseDistributionPanel.this.topology.setDisableRightclick(true);
            try {
                DatabaseDistributionPanel.this.topology.updateDraw();
            }
            finally {
                this.progressMonitor.finish();
                this.progressMonitor.close();
            }
            super.done();
        }
    }

    private class DatabaseUpdateWorker
    extends SwingWorker<Void, Void> {
        private CustomProgressMonitor progressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.updateDBStatus"), "", null);

        public DatabaseUpdateWorker() {
            this.addPropertyChangeListener(this.progressMonitor);
            this.progressMonitor.setSwingWorker(this);
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.progressMonitor.start();
            try {
                GridCommand gridCommand = null;
                DatabaseDistributionPanel.this.fetchDistributionMap(gridCommand);
            }
            catch (JsonException | GridCommandException throwable) {
                DatabaseDistributionPanel.this._logger.log(Level.SEVERE, throwable.getMessage());
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                DatabaseDistributionPanel.this.topology.updateDraw();
            }
            finally {
                this.progressMonitor.finish();
                this.progressMonitor.close();
            }
            super.done();
        }
    }
}

