/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import javax.json.Json;
import javax.json.JsonObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingWorker;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.SSHChannel;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.grid.object.MySSHException;
import oracle.dbtools.raptor.timesten.utils.AutoCompleteComponent;
import oracle.ide.Ide;

public class ManageExistingGridPanel
extends JPanel
implements ActionListener {
    private JLabel _addressLabel;
    private JLabel _locationLabel;
    private JLabel _instanceAdminLabel;
    private JLabel _pwdLabel;
    private AutoCompleteComponent _addressTxtField;
    private AutoCompleteComponent _locationTxtField;
    private AutoCompleteComponent _instanceAdminTxtField;
    private JPasswordField _pwdField;
    private JButton _testButton;
    private JButton _okButton;
    private JCheckBox _savePwdCheckBox;
    private JPanel _mgmtInstPanel;
    private JPanel _credPanel;
    private JEWTDialog _dialog;
    private CustomProgressMonitor _progressMonitor;
    private GridObject grid;
    private GridObject existingGrid;
    private static final String ONE = "1";
    private static final String TWO = "2";
    private static final String LOCAL = "local";
    private static final String DBACTIVE = "dbActive";
    private static final String ADDRESS = "address";
    private static final String INTERNAL_ADDRESS = "internalAddress";
    private static final String INST_HOME = "instanceHome";

    public ManageExistingGridPanel(GridObject gridObject) {
        this.existingGrid = gridObject;
        this.setLayout(new GridBagLayout());
        this._addressTxtField = new AutoCompleteComponent(15, HostObject.getHostExternalAddressSuggestions());
        this._locationTxtField = new AutoCompleteComponent(30, InstanceObject.getInstanceHomeSuggestions());
        this._instanceAdminTxtField = new AutoCompleteComponent(15, TTGridRootNode.getStorage().getSuggestion("adminUID"));
        this._pwdField = new JPasswordField(15);
        this._addressLabel = new JLabel(Messages.getString("TimesTenGrid.addressLabel"));
        this._addressLabel.setLabelFor(this._addressTxtField);
        this._locationLabel = new JLabel(Messages.getString("TimesTenGrid.instHomeLabel"));
        this._locationLabel.setLabelFor(this._locationTxtField);
        this._instanceAdminLabel = new JLabel(Messages.getString("TimesTenGrid.instanceAdminLabel"));
        this._instanceAdminLabel.setLabelFor(this._instanceAdminTxtField);
        this._pwdLabel = new JLabel(Messages.getString("TimesTenGrid.passwordLabel"));
        this._pwdLabel.setLabelFor(this._pwdField);
        this._testButton = new JButton(Messages.getString("TimesTenGrid.test"));
        this._testButton.addActionListener(this);
        this._okButton = new JButton(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.OKButton")));
        this._okButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.OKButton")));
        this._okButton.addActionListener(this);
        this._savePwdCheckBox = new JCheckBox(Messages.getString("TimesTenGrid.savePwd"));
        this._mgmtInstPanel = new JPanel(new GridBagLayout());
        this._mgmtInstPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.mgmtInstInformation")));
        this._credPanel = new JPanel(new GridBagLayout());
        this._credPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.instanceAdminCredentials")));
        this._mgmtInstPanel.add((Component)this._addressLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 5, 10, 10), 0, 0));
        this._mgmtInstPanel.add((Component)this._addressTxtField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this._mgmtInstPanel.add((Component)this._locationLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 5, 10, 10), 0, 0));
        this._mgmtInstPanel.add((Component)this._locationTxtField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this._credPanel.add((Component)this._instanceAdminLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 5, 10, 10), 0, 0));
        this._credPanel.add((Component)this._instanceAdminTxtField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this._credPanel.add((Component)this._pwdLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 5, 10, 10), 0, 0));
        this._credPanel.add((Component)this._pwdField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this._credPanel.add((Component)this._savePwdCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 5, 10, 10), 0, 0));
        this.add((Component)this._mgmtInstPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._credPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (gridObject != null) {
            this.populateFields();
        }
        this.setNames();
    }

    private void populateFields() {
        GridCommandExecutor.WorkingHost workingHost = this.existingGrid.getExecutor().getWorkingHost();
        this._addressTxtField.setText(workingHost.getIPaddress());
        this._locationTxtField.setText(workingHost.getInstanceHome());
        this._instanceAdminTxtField.setText(workingHost.getInstanceAdmin());
        if (this.existingGrid.getSavePassword()) {
            this._pwdField.setText(new String(workingHost.getPwd()));
        }
        this._savePwdCheckBox.setSelected(this.existingGrid.getSavePassword());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.validInput()) {
            return;
        }
        String string = this._addressTxtField.getText().trim();
        String string2 = this._locationTxtField.getText().trim();
        String string3 = this._instanceAdminTxtField.getText().trim();
        char[] cArray = this._pwdField.getPassword();
        this.connect(string, string2, string3, cArray, actionEvent.getSource() == this._testButton);
    }

    private boolean validInput() {
        String string = this._addressTxtField.getText().trim();
        if (string.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noAddressError"));
            return false;
        }
        if (!Common.validAddress(string)) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.addressFormatError"));
            return false;
        }
        String string2 = this._locationTxtField.getText().trim();
        if (string2.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noInstHomeError"));
            return false;
        }
        String string3 = this._instanceAdminTxtField.getText().trim();
        if (string3.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noInstanceAdminError"));
            return false;
        }
        char[] cArray = this._pwdField.getPassword();
        if (cArray.length == 0) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noPwdError"));
            return false;
        }
        return true;
    }

    public JButton getTestButton() {
        return this._testButton;
    }

    public JButton getOKButton() {
        return this._okButton;
    }

    private void connect(final String string, final String string2, final String string3, final char[] cArray, final boolean bl) {
        this._progressMonitor = new CustomProgressMonitor(this, MessageFormat.format(Messages.getString("TimesTenGrid.connectingToHost"), string), Messages.getString("TimesTen.common.pleaseWait"), null);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            StringBuilder errorMessage = new StringBuilder();

            @Override
            protected Void doInBackground() throws Exception {
                Object object;
                GridCommandExecutor gridCommandExecutor = new GridCommandExecutor(string, string2, string3, cArray);
                ManageExistingGridPanel.this._progressMonitor.start();
                this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.verifyingInstance"));
                try {
                    SSHChannel.checkInstanceHome(string, string3, cArray, string2);
                    object = gridCommandExecutor.executeCommandGetJson(GridCommand.MGMT_STATUS, true);
                    if (!ManageExistingGridPanel.this.chechMgmtStatus((JsonObject)object)) {
                        throw new GridCommandException(Messages.getString("TimesTenGrid.noActiveMgmtInst"));
                    }
                }
                catch (GridCommandException | MySSHException exception) {
                    if (exception.getMessage().indexOf(123) >= 0) {
                        String string5 = exception.getMessage().substring(exception.getMessage().indexOf(123), exception.getMessage().length());
                        JsonObject jsonObject = Json.createReader((Reader)new StringReader(string5)).readObject();
                        if (jsonObject.getInt("status") == 73) {
                            this.errorMessage.append(Messages.getString("TimesTenGrid.invalidManagementInstanceHome"));
                        } else {
                            this.errorMessage.append(exception.getMessage());
                        }
                    } else {
                        this.errorMessage.append(exception.getMessage());
                    }
                    return null;
                }
                if (!bl) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.retrievingGridModel"));
                    try {
                        if (ManageExistingGridPanel.this.existingGrid != null) {
                            object = ManageExistingGridPanel.this.existingGrid;
                            ((GridObject)object).setExecutor(gridCommandExecutor);
                        } else {
                            object = ManageExistingGridPanel.this.grid = new GridObject("", gridCommandExecutor);
                        }
                        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.gettingSystemInfo"));
                        gridCommandExecutor.executePerlScriptCommand(GridCommand.PERL_GET_SYSTEM_INFO, null);
                        String[] stringArray = gridCommandExecutor.getSSHChannel().getLastCommandOutput().split(";");
                        String string6 = stringArray[0];
                        String string22 = stringArray[1];
                        String string32 = stringArray[2] + stringArray[3];
                        String string4 = stringArray[3];
                        gridCommandExecutor.getWorkingHost().updateSystemInfo(string6, string22, string32, string4);
                        ((GridObject)object).setSavePassword(ManageExistingGridPanel.this._savePwdCheckBox.isSelected());
                        JsonObject jsonObject = gridCommandExecutor.executeCommandGetJson(GridCommand.EXPORT_MODEL, true);
                        ((GridObject)object).setGridComponents(jsonObject, true);
                        ((GridObject)object).setCurrentModel(((GridObject)object).getExecutor().executeCommandGetJson(GridCommand.EXPORT_CURRENTMODEL, true));
                        ((GridObject)object).getGridCurrentModel().diff((GridObject)object);
                    }
                    catch (Exception exception) {
                        this.errorMessage.append(exception.getMessage());
                        return null;
                    }
                }
                this.firePropertyChange("progress", null, 100);
                return null;
            }

            @Override
            protected void done() {
                ManageExistingGridPanel.this._progressMonitor.close();
                if (this.isCancelled()) {
                    return;
                }
                if (ManageExistingGridPanel.this._progressMonitor.successfulExecution()) {
                    TTGridRootNode.getStorage().saveSuggestion("adminUID", string3);
                    String string4 = Messages.getString("TimesTenGrid.successfulTest");
                    String string22 = Messages.getString("TimesTenGrid.testGrid");
                    if (!bl) {
                        ManageExistingGridPanel.this.getDialog().dispose();
                        if (ManageExistingGridPanel.this.existingGrid != null) {
                            return;
                        }
                        if (TTGridRootNode.getInstance().getGrid(ManageExistingGridPanel.this.grid.getName()) == null) {
                            TTGridRootNode.getInstance().addGrid(ManageExistingGridPanel.this.grid);
                        }
                        string4 = MessageFormat.format(Messages.getString("TimesTenGrid.successfullyManage"), ManageExistingGridPanel.this.grid.getShortName());
                        string22 = Messages.getString("TimesTenGrid.manageExistingGrid");
                    }
                    Common.displayInfoMsg((Component)Ide.getMainWindow(), string4, string22);
                } else {
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), this.errorMessage.toString());
                }
            }
        };
        swingWorker.addPropertyChangeListener(this._progressMonitor);
        this._progressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    public void setDialog(JEWTDialog jEWTDialog) {
        this._dialog = jEWTDialog;
    }

    public JEWTDialog getDialog() {
        return this._dialog;
    }

    public boolean chechMgmtStatus(JsonObject jsonObject) throws GridCommandException {
        JsonObject jsonObject2 = null;
        JsonObject jsonObject3 = null;
        JsonObject jsonObject4 = null;
        String string = null;
        String string2 = null;
        String string3 = this._locationTxtField.getText().trim();
        String string4 = this._addressTxtField.getText().trim();
        String string5 = this._instanceAdminTxtField.getText().trim();
        char[] cArray = this._pwdField.getPassword();
        jsonObject2 = jsonObject.getJsonObject(ONE);
        jsonObject3 = jsonObject.getJsonObject(TWO);
        if (jsonObject2 != null) {
            jsonObject4 = jsonObject2.getJsonObject(LOCAL);
            if (jsonObject4 == null) {
                throw new GridCommandException(Messages.getString("TimesTenGrid.invalidMgmtInstStatus"));
            }
            string = jsonObject4.getString(INST_HOME);
            string2 = jsonObject4.getString(ADDRESS);
            if (string2.equalsIgnoreCase(string4) || Common.sameHostName(string2, string4, string5, cArray)) {
                if (Common.sameDirectories(string, string3)) {
                    return this.checkDBActive(jsonObject2, string, string2);
                }
                if (jsonObject3 != null) {
                    return this.checkInTwoMgmtInstance(jsonObject3, string3, string4);
                }
                throw new GridCommandException(Messages.getString("TimesTenGrid.invalidMgmtInstStatus"));
            }
            if (jsonObject3 != null) {
                return this.checkInTwoMgmtInstance(jsonObject3, string3, string4);
            }
            throw new GridCommandException(Messages.getString("TimesTenGrid.invalidMgmtInstStatus"));
        }
        throw new GridCommandException(Messages.getString("TimesTenGrid.invalidMgmtInstStatus"));
    }

    private boolean checkDBActive(JsonObject jsonObject, String string, String string2) throws GridCommandException {
        JsonObject jsonObject2 = null;
        String string3 = null;
        String string4 = null;
        jsonObject2 = jsonObject.getJsonObject(DBACTIVE);
        if (jsonObject2 != null) {
            string3 = jsonObject2.getString(INST_HOME);
            string4 = jsonObject2.getString(INTERNAL_ADDRESS);
            return (string4.equalsIgnoreCase(string2) || Common.sameHostName(string4, string2, this._instanceAdminTxtField.getText().trim(), this._pwdField.getPassword())) && Common.sameDirectories(string3, string);
        }
        throw new GridCommandException(Messages.getString("TimesTenGrid.invalidMgmtInstStatus"));
    }

    private boolean checkInTwoMgmtInstance(JsonObject jsonObject, String string, String string2) throws GridCommandException {
        String string3 = null;
        String string4 = null;
        JsonObject jsonObject2 = jsonObject.getJsonObject(LOCAL);
        if (jsonObject2 == null) {
            throw new GridCommandException(Messages.getString("TimesTenGrid.invalidMgmtInstStatus"));
        }
        string4 = jsonObject2.getString(INST_HOME);
        string3 = jsonObject2.getString(ADDRESS);
        if (string3.equalsIgnoreCase(string2) || Common.sameHostName(string3, string2, this._instanceAdminTxtField.getText().trim(), this._pwdField.getPassword())) {
            if (Common.sameDirectories(string4, string)) {
                return this.checkDBActive(jsonObject, string4, string3);
            }
            throw new GridCommandException(Messages.getString("TimesTenGrid.invalidMgmtInstStatus"));
        }
        return false;
    }

    private void setNames() {
        this._addressLabel.setName(Messages.getString("TimesTenGrid.addressLabel"));
        this._locationLabel.setName(Messages.getString("TimesTenGrid.instHomeLabel"));
        this._instanceAdminLabel.setName(Messages.getString("TimesTenGrid.instanceAdminLabel"));
        this._pwdLabel.setName(Messages.getString("TimesTenGrid.passwordLabel"));
        this._addressTxtField.setName("_addressTxtField", "_addressCmbBox");
        this._locationTxtField.setName("_locationTxtField", "_locationCmbBox");
        this._instanceAdminTxtField.setName("_instanceAdminTxtField", "_instanceAdminCmbBox");
        this._pwdField.setName("_pwdField");
        this._testButton.setName(Messages.getString("TimesTenGrid.test"));
        this._okButton.setName(Messages.getString("TimesTen.common.OKButton"));
        this._savePwdCheckBox.setName(Messages.getString("TimesTenGrid.savePwd"));
    }
}

