/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.object.Executable;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.PhysicalGroupObject;

public enum GridCommand {
    INSTANCE_EXEC("ttGridAdmin -instanceExec -f json"),
    HOST_EXEC("ttGridAdmin -hostExec -f json"),
    EXPORT_MODEL("ttGridAdmin -modelExport -latest"),
    EXPORT_CURRENTMODEL("ttGridAdmin -modelExport -current"),
    EXPORT_OTHER_MODEL("ttGridAdmin -modelExport -version {1}"),
    EXPORT_MEMCONFIG("ttGridAdmin -membershipConfigExport -latest {1}"),
    EXPORT_CURRENT_MEMCONFIG("ttGridAdmin -membershipConfigExport -current {1}"),
    EXPORT_OTHER_MEMCONFIG("ttGridAdmin -membershipConfigExport -version {1} {2}"),
    EXPORT_INSTCONFIG("ttGridAdmin -instanceConfigExport -latest {1}"),
    EXPORT_CURRENT_INSTCONFIG("ttGridAdmin -instanceConfigExport -current {1}"),
    EXPORT_OTHER_INSTCONFIG("ttGridAdmin -instanceConfigExport -version {1} {2}"),
    EXPORT_SQLNET("ttGridAdmin -SQLNetExport -latest {1}"),
    EXPORT_CURRENT_SQLNET("ttGridAdmin -SQLNetExport -current {1}"),
    EXPORT_OTHER_SQLNET("ttGridAdmin -SQLNetExport -version {1} {2}"),
    EXPORT_TNSNAMES("ttGridAdmin -TNSNamesExport -latest {1}"),
    EXPORT_CURRENT_TNSNAMES("ttGridAdmin -TNSNamesExport -current {1}"),
    EXPORT_OTHER_TNSNAMES("ttGridAdmin -TNSNamesExport -version {1} {2}"),
    EXPORT_DSN("ttgridadmin -gridClientExport {1}"),
    GRID_DISPLAY("ttGridAdmin -gridDisplay"),
    PHYSICAL_CREATE("ttGridAdmin -physicalCreate {1}"),
    PHYSICAL_DELETE("ttGridAdmin -physicalDelete {1}"),
    IMPORT_MODEL("ttGridAdmin -modelImport {1}"),
    IMPORT_MEMCONFIG("ttGridAdmin -membershipConfigImport {1}"),
    IMPORT_INSTCONFIG("ttGridAdmin -instanceConfigImport {1}"),
    IMPORT_SQLNET("ttGridAdmin -SQLNetImport {1}"),
    IMPORT_TNSNAMES("ttGridAdmin -TNSNamesImport {1}"),
    START_WORKING_INSTANCE("ttDaemonAdmin -start"),
    STOP_WORKING_INSTANCE("ttDaemonAdmin -stop"),
    START_WORKING_INSTANCE_FORCE("ttDaemonAdmin -start -force"),
    STOP_WORKING_INSTANCE_FORCE("ttDaemonAdmin -stop -force"),
    START_INSTANCE("ttGridAdmin -instanceExec -only {1} ttDaemonAdmin -start {2}"),
    START_SERVER("ttGridAdmin -instanceExec -only {1} ttDaemonAdmin -startserver {2}"),
    STOP_INSTANCE("ttGridAdmin -instanceExec -only {1} ttDaemonAdmin -stop {2}"),
    STOP_SERVER("ttGridAdmin -instanceExec -only {1} ttDaemonAdmin -stopserver {2}"),
    CREATE_CONNECTABLE("ttGridAdmin -connectableCreate -dbdef {1} {2}"),
    MODIFY_CONNECTABLE("ttGridAdmin -connectableModify {1}"),
    DELETE_CONNECTABLE("ttGridAdmin -connectableDelete {1}"),
    LOAD_DATABASE("ttGridAdmin -dbLoad {1}"),
    OPEN_DATABASE("ttGridAdmin -dbOpen {1}"),
    CLOSE_DATABASE("ttGridAdmin -dbClose {1}"),
    UNLOAD_DATABASE("ttGridAdmin -dbUnload {1}"),
    UNLOAD_FORCE_DATABASE("ttGridAdmin -dbUnload {1} -force"),
    DESTROY_DATABASE("ttGridAdmin -dbDestroy {1}"),
    DELETE_DATABASE_DEFINITION("ttGridAdmin -dbdefDelete {1}"),
    CLONE_HOST("ttGridAdmin -hostCreate -name {1} -internalAddress {2} -externalAddress {3} -like {4} -cascade"),
    CLONE_HOST_PG("ttGridAdmin -hostCreate -name {1} -internalAddress {2} -externalAddress {3} -physicalgroup {4} -like {5} -cascade"),
    INSTANCE_CREATE("ttGridAdmin -instanceCreate -name {1} -host {2} -location {3} -daemonport {4} -csport {5}"),
    INSTANCE_CREATE2("ttGridAdmin -instanceCreate -name {1} -host {2} -location {3} -installation {4} -daemonport {5} -csport {6}"),
    INSTANCE_EDIT("ttGridAdmin -instanceModify -host {1} -name {2} -install {5}"),
    MGMT_INSTANCE_CREATE("ttGridAdmin -instanceCreate -type management -name {1} -host {2} -location {3} -installation {4} -daemonport {5} -csport {6} -mgmtport {7}"),
    INSTANCE_DELETE("ttGridAdmin -instanceDelete -host {1} -name {2} "),
    MODEL_APPLY("ttGridAdmin -modelApply"),
    CREATE_DBDEF("ttGridAdmin -dbdefCreate {1}"),
    MODIFY_DBDEF("ttGridAdmin -dbdefModify {1}"),
    CREATE_DATABASE("ttGridAdmin -dbCreate {1}"),
    CHECK_REMOTE_DIR_IS_W("ssh -x {1} test -w {2} 2>/dev/null"),
    CREATE_REMOTE_DIR("ssh -x {1} mkdir -p {2} 2>/dev/null"),
    CHECK_REMOTE_DIR_FILE_IS_READ("ssh -x {1} test {2} 2>/dev/null"),
    CHECK_REMOTE_DIR_IS_READ("ssh -x {1} test -d {2} 2>/dev/null"),
    CHECK_LOCAL_DIR_IS_READ("test -d {2}"),
    CHECK_DIR("ssh -x {1} test -w {2} 2>/dev/null"),
    PERL_CHECK_SCRIPT("#PERL_LOCATION# -e 'use Digest::MD5 qw(md5_hex);$script=\"#INSTANCE_HOME#/gridCompositeCommands.pl\";if(!-e $script){print q[Perl script not present.];exit 1;}local $/;open(FILE,$script);my $data = <FILE>;close FILE;if(md5_hex($data) ne q[{1}]){print q[Remote perl script does not match local one.];exit 1;}else{exit 0;}'"),
    PERL_CREATE_DATABASE("#PERL_LOCATION# #INSTANCE_HOME#/gridCompositeCommands.pl -command createDB -dbDefPath {1}"),
    PERL_CREATE_DATABASE_FROM_DBDEF("#PERL_LOCATION# #INSTANCE_HOME#/gridCompositeCommands.pl -command createDBFromDBDef -dbName {1} "),
    PERL_DELETE_DATABASE("#PERL_LOCATION# #INSTANCE_HOME#/gridCompositeCommands.pl -command destroyDB -dbName {1} -destroyDBDef {2}"),
    PERL_START_DATABASE("#PERL_LOCATION# #INSTANCE_HOME#/gridCompositeCommands.pl -command startDB -dbName {1}"),
    PERL_STOP_DATABASE("#PERL_LOCATION# #INSTANCE_HOME#/gridCompositeCommands.pl -command stopDB -dbName {1}"),
    PERL_CREATE_GRID("#PERL_LOCATION# #INSTANCE_HOME#/gridCompositeCommands.pl -command createGrid -gridFile {1}"),
    PERL_ADD_HOSTS("#PERL_LOCATION# #INSTANCE_HOME#/gridCompositeCommands.pl -command addNewHosts -hostFile {1}"),
    PERL_APPLY_MODEL("#PERL_LOCATION# #INSTANCE_HOME#/gridCompositeCommands.pl -command applyModel"),
    PERL_GET_OSNAME_SHELL("#PERL_LOCATION# #INSTANCE_HOME#/gridCompositeCommands.pl -command printOSNameShell"),
    PERL_GET_SYSTEM_INFO("#PERL_LOCATION# #INSTANCE_HOME#/gridCompositeCommands.pl -command printSystemInfo"),
    PERL_GET_SYSTEM_INFO_NG("{1}perl -e 'use strict;use File::Spec::Functions;use Config;my $tmpdir=File::Spec->tmpdir();my $fseparator=catfile(\"\",\"\");print \"$Config{osname};$ENV{SHELL};$tmpdir;$fseparator;\\n\";'"),
    PERL_DELETE_FILES("#PERL_LOCATION# #INSTANCE_HOME#/gridCompositeCommands.pl -command deleteFiles"),
    PERL_GET_CONNECTION_COUNT("#PERL_LOCATION# #INSTANCE_HOME#/gridCompositeCommands.pl -command printConnectionCount -instance {1} -timeout {2} -dbName {3} -connName {4}"),
    PERL_GET_CONNECTION_DETAILS("#PERL_LOCATION# #INSTANCE_HOME#/gridCompositeCommands.pl -command printConnectionDetails -instance {1} -timeout {2} -dbName {3} -connName {4}"),
    DB_STATUS("ttGridAdmin -dbStatus {1}"),
    DB_LOAD_READINESS("ttGridAdmin -dbStatus -loadReadiness {1}"),
    DB_DISTRIBUTE_ADD("ttGridAdmin -dbDistribute {1} -add {2}"),
    DB_DISTRIBUTE_REMOVE("ttGridAdmin -dbDistribute {1} -remove {2}"),
    DB_DISTRIBUTE_REPLACE("ttGridAdmin -dbDistribute {1} -remove {2} -replaceWith {3}"),
    DB_DISTRIBUTE_EVICT("ttGridAdmin -dbDistribute {1} -evict {2}"),
    DB_DISTRIBUTE_EVICT_REPLACE("ttGridAdmin -dbDistribute {1} -evict {2} -replaceWith {3}"),
    DB_DISTRIBUTE_LIST("ttGridAdmin -dbDistribute {1} -list"),
    DB_DISTRIBUTE_APPLY("ttGridAdmin -dbDistribute {1} -apply"),
    DBS_STATUS("ttGridAdmin -dbStatus"),
    HOST_CREATE("ttGridAdmin -hostCreate -name {1} -address {2} -dataspacegroup {3}"),
    HOST_FULL_CREATE("ttGridAdmin -hostCreate -name {1} -internaladdress {2} -externaladdress {3}"),
    HOST_CREATE_NONAME("ttGridAdmin -hostCreate -internaladdress {1} -externaladdress {2}"),
    HOST_CREATE_NODSG("ttGridAdmin -hostCreate -name {1} -address {2} -nodataspacegroup"),
    HOST_MODIFY("ttGridAdmin -hostModify -name {1} -dataspacegroup {4}"),
    HOST_MODIFY_ADDR("ttGridAdmin -hostModify -name {1}"),
    HOST_MODIFY_ADD_PG("ttGridAdmin -hostModify -name {1} -physicalGroup {2}"),
    HOST_MODIFY_ADD_PGS("ttGridAdmin -hostModify -name {1} -addPhysicalGroup {2}"),
    HOST_MODIFY_REMOVE_PG("ttGridAdmin -hostModify -name {1} -removePhysicalGroup {2}"),
    HOST_MODIFY_NO_PG("ttGridAdmin -hostModify -name {1} -nophysicalgroup"),
    HOST_MODIFY_NODSG("ttGridAdmin -hostModify -name {1} -nodataspacegroup"),
    ASSIGN_HOST_NODSG("ttGridAdmin -hostModify -name {1} -nodataspacegroup"),
    ASSIGN_HOST_DSG("ttGridAdmin -hostModify -name {1} -dataspacegroup {2}"),
    HOST_DELETE("ttGridAdmin -hostDelete {1} -cascade"),
    INSTALLATION_CREATE("ttGridAdmin -installationCreate -host {1} -location {2}"),
    INSTALLATION_CREATE_FULL("ttGridAdmin -installationCreate -host {1} -location {2} -name {3} -source {4}"),
    INSTALLATION_DELETE("ttGridAdmin -installationDelete -host {1} -name {2}"),
    DSG_SUGGEST("ttGridAdmin -dataSpaceGroupSuggest"),
    MGMT_EXAMINE("ttGridAdmin -mgmtExamine"),
    MGMT_STATUS("ttGridAdmin -mgmtStatus"),
    MGMT_SWITCH("ttGridAdmin -mgmtActiveSwitch"),
    MGMT_STANDBY_START("ttGridAdmin mgmtStandbyStart"),
    MGMT_STANDBY_STOP("ttGridAdmin mgmtStandbyStop"),
    TT_STATUS("ttStatus"),
    TT_STATUS_DB("ttStatus -gridbrief #JSON# dsn={1}"),
    TT_STATUS_ALL("ttStatus -gridbrief"),
    TIMESTEN_HOME("TIMESTEN_HOME"),
    GRID_MEMBERSHIP("Grid Membership:"),
    SCP_CMD("Copy File"),
    SCP2_CMD("Write File"),
    REMOVE_FILE("rm -f {1}"),
    CDREMOVE_FILE("cd {1};rm -f {2}"),
    STARTUP_OK("startup OK."),
    TT_INSTANCE_CREATE("{1}ttInstanceCreate -location {2} -name {3} -daemonport {4} -csport {5} -grid"),
    UNCOMPRESS_SW("cd {1};tar -xvf {2}"),
    CDPARENTDIR_SW("cd {1};tar -tf {2} | grep ttInstanceCreate"),
    PARENTDIR_SW("tar -tf {1} | grep ttInstanceCreate"),
    CHANGE_DIR_GROUP("chgrp -R {1} {2}"),
    CUSTOM_COMMAND("{1}");

    public final String INSTANCE_EXEC_ONLY_OPTION = " -only {1}";
    public final String INSTANCE_EXEC_EXCLUDE_OPTION = " -exclude {1}";
    public final String JSON_OPTION = " -f json";
    public final String TT_STATUS_JSON_OPTION = " -json";
    public final String NO_PG = " -nophysicalgroup";
    public final String ADD_PG = " -physicalgroup {1}";
    public static final String PERL_SCRIPT_HOME = "#INSTANCE_HOME#/gridCompositeCommands.pl";
    private static final Logger _logger;
    public String baseCommand;
    public String preparedCommand;
    public boolean jsonRequested;

    private GridCommand(String string2) {
        this.baseCommand = string2;
        this.preparedCommand = string2;
        this.jsonRequested = false;
    }

    public String getCommand() {
        return this.preparedCommand;
    }

    public void requestJson() {
        if (!this.commandReady() || this == CUSTOM_COMMAND) {
            return;
        }
        if (this.preparedCommand.endsWith(" -f json") || this.preparedCommand.endsWith(" -json")) {
            return;
        }
        this.preparedCommand = this != TT_STATUS_DB && this != TT_STATUS_ALL && this != TT_STATUS ? this.preparedCommand + " -f json" : (this == TT_STATUS_DB ? this.preparedCommand.replace("#JSON#", " -json") : this.preparedCommand + " -json");
        this.jsonRequested = true;
    }

    public void setPerlLocation(String string) {
        this.preparedCommand = this.preparedCommand.replace("#PERL_LOCATION#", string + "/PERL/bin/perl");
    }

    public void setInstanceHome(String string) {
        this.preparedCommand = this.preparedCommand.replace("#INSTANCE_HOME#", string);
    }

    public void removeJsonRequest() {
        if (this == CUSTOM_COMMAND) {
            return;
        }
        if (this.preparedCommand.contains(" -f json")) {
            this.preparedCommand = this.preparedCommand.replaceAll(" -f json", "");
        } else if (this.preparedCommand.contains("#JSON#")) {
            this.preparedCommand = this.preparedCommand.replaceAll("#JSON#", "");
        } else if (this.preparedCommand.contains(" -json")) {
            this.preparedCommand = this.preparedCommand.replaceAll(" -json", "");
        }
    }

    public boolean isJsonRequested() {
        return this.jsonRequested;
    }

    public boolean commandReady() {
        return !this.preparedCommand.contains("{") || !this.preparedCommand.contains("}");
    }

    public void prepareCommand(String ... stringArray) {
        this.preparedCommand = this.baseCommand;
        for (int i = 0; i < stringArray.length; ++i) {
            this.preparedCommand = this.preparedCommand.replace("{" + (i + 1) + "}", stringArray[i]);
        }
        if (this == PERL_DELETE_FILES) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(" -file ");
                stringBuilder.append(stringArray[i]);
            }
            this.preparedCommand = this.preparedCommand + stringBuilder.toString();
        }
    }

    boolean enableTimeout() {
        switch (this) {
            case INSTANCE_EXEC: 
            case HOST_EXEC: 
            case MODEL_APPLY: 
            case SCP_CMD: 
            case SCP2_CMD: 
            case PERL_CHECK_SCRIPT: 
            case PERL_CREATE_DATABASE: 
            case PERL_CREATE_DATABASE_FROM_DBDEF: 
            case PERL_DELETE_DATABASE: 
            case PERL_START_DATABASE: 
            case PERL_STOP_DATABASE: 
            case PERL_CREATE_GRID: 
            case PERL_ADD_HOSTS: 
            case PERL_APPLY_MODEL: 
            case DB_DISTRIBUTE_APPLY: 
            case UNCOMPRESS_SW: 
            case CDPARENTDIR_SW: 
            case PARENTDIR_SW: 
            case MGMT_SWITCH: 
            case MGMT_STANDBY_START: 
            case MGMT_STANDBY_STOP: 
            case CUSTOM_COMMAND: {
                return false;
            }
        }
        return true;
    }

    public void createConnectableWithCSOption(String string) {
        if (this != CREATE_CONNECTABLE && this != MODIFY_CONNECTABLE) {
            return;
        }
        if (this == CREATE_CONNECTABLE) {
            this.preparedCommand = this.preparedCommand + " -cs";
        }
        if (!string.equalsIgnoreCase(Messages.getString("TimesTenGrid.anyInstance"))) {
            this.preparedCommand = this.preparedCommand + " -only " + string;
        }
    }

    public void prepareHostCreateCommand(HostObject hostObject) {
        if (this != HOST_FULL_CREATE && this != HOST_CREATE_NONAME) {
            _logger.warning("Call to prepareHostCreateCommand from a GridCommand enum different than HOST_FULL_CREATE or HOST CREATE NONAME");
            return;
        }
        if (hostObject.getName().isEmpty()) {
            this.prepareCommand(hostObject.getInternalAddress(), hostObject.getExternalAddress());
        } else {
            this.prepareCommand(hostObject.getName(), hostObject.getInternalAddress(), hostObject.getExternalAddress());
        }
        this.preparedCommand = hostObject.getDataSpaceGroup() > 0 ? this.preparedCommand + " -dataspacegroup " + hostObject.getDataSpaceGroup() : this.preparedCommand + " -nodataspacegroup";
        if (!hostObject.getPhysicalGroups().isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(" -physicalGroup ");
            for (PhysicalGroupObject physicalGroupObject : hostObject.getPhysicalGroups()) {
                stringBuilder.append(physicalGroupObject.getName() + " ");
            }
            this.preparedCommand = this.preparedCommand + stringBuilder.toString();
        }
    }

    public void addHostPGOptions(HostObject hostObject, List<PhysicalGroupObject> list) {
        if (!list.isEmpty()) {
            this.preparedCommand = this.preparedCommand + " -physicalgroup {1}";
            StringBuilder stringBuilder = new StringBuilder();
            for (PhysicalGroupObject physicalGroupObject : list) {
                stringBuilder.append(physicalGroupObject.getName() + " ");
            }
            this.preparedCommand = this.preparedCommand.replace("{1}", stringBuilder.toString());
        } else {
            this.preparedCommand = this.preparedCommand + " -nophysicalgroup";
        }
    }

    public void includeExec(List<? extends Executable> list, GridCommand gridCommand, int n, ExecMode execMode) {
        if (this != INSTANCE_EXEC && this != HOST_EXEC) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(this.baseCommand);
        for (Executable executable : list) {
            String string = " -only {1}";
            string = string.replace("{1}", executable.getTargetName());
            stringBuilder.append(string);
        }
        if (execMode != null) {
            switch (execMode) {
                case ALL: {
                    stringBuilder.append(" -type all");
                    break;
                }
                case DATA: {
                    stringBuilder.append(" -type data");
                    break;
                }
                case MGMT: {
                    stringBuilder.append(" -type management");
                }
            }
        }
        if (n > 0) {
            stringBuilder.append(" -timeout " + n);
        }
        stringBuilder.append(" \"{1}\" ");
        this.preparedCommand = stringBuilder.toString();
        this.preparedCommand = this.preparedCommand.replace("{1}", gridCommand.getCommand());
    }

    static {
        _logger = Logger.getLogger(GridCommand.class.getName());
    }

    public static enum ExecMode {
        DATA,
        MGMT,
        ALL;

    }
}

