/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.SelectPhysicalGroupsPanel;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.PhysicalGroupObject;
import oracle.dbtools.raptor.timesten.utils.AutoCompleteComponent;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public class EditHostPanel
extends TTGUIBasePanel {
    private JLabel _internalAddrLabel;
    private JLabel _externalAddrLabel;
    private JLabel _dsgLabel;
    private JLabel _PGsLabel;
    private JLabel _PGsSelected;
    private JButton _selectPGsButton;
    private AutoCompleteComponent _internalAddrTxtField;
    private AutoCompleteComponent _externalAddrTxtField;
    private JComboBox<String> _dsgComboBox;
    private List<PhysicalGroupObject> newPGS;
    private HostObject host;
    private int prevDSG;
    private static Logger _logger = Logger.getLogger(EditHostPanel.class.getPackage().getName());
    private SelectPhysicalGroupsPanel selectPGPanel;

    public EditHostPanel() {
        this.host = this.grid.getHost(this.root.getCurrentHost());
        HostObject hostObject = this.grid.getGridCurrentModel().getHost(this.host.getName());
        this.prevDSG = this.host.getDataSpaceGroup();
        this.newPGS = new ArrayList<PhysicalGroupObject>(this.host.getPhysicalGroups());
        this._internalAddrTxtField = new AutoCompleteComponent(15, HostObject.getHostInternalAddressSuggestions());
        this._internalAddrTxtField.setText(this.host.getInternalAddress());
        this._externalAddrTxtField = new AutoCompleteComponent(15, HostObject.getHostExternalAddressSuggestions());
        this._externalAddrTxtField.setText(this.host.getExternalAddress());
        this._dsgComboBox = Common.getDSGComboBox(this.grid.getProperties().getK());
        this._dsgComboBox.setSelectedIndex(this.prevDSG);
        this._internalAddrLabel = new JLabel(Messages.getString("TimesTenGrid.internalAddrLabel"));
        this._externalAddrLabel = new JLabel(Messages.getString("TimesTenGrid.externalAddrLabel"));
        this._dsgLabel = new JLabel(Messages.getString("TimesTenGrid.DSGLabel"));
        this._PGsLabel = new JLabel(Messages.getString("TimesTenGrid.physicalGroups2"));
        this._PGsSelected = new JLabel(this.host.getPhysicalGroupsString());
        this._selectPGsButton = new JButton(Messages.getString("TimesTenGrid.selectButton"));
        this._internalAddrTxtField.setEnabled(false);
        this._externalAddrTxtField.setEnabled(false);
        if (this.grid.getGridCurrentModel().getProperties().getVersion() > 1 && hostObject != null && hostObject.getDataSpaceGroup() != 0) {
            this._dsgComboBox.setEnabled(false);
        }
        this._internalAddrLabel.setLabelFor(this._internalAddrTxtField);
        this._externalAddrLabel.setLabelFor(this._externalAddrTxtField);
        this._dsgLabel.setLabelFor(this._dsgComboBox);
        this._selectPGsButton.addActionListener(actionEvent -> this.showSelectPGSDialog(this.host));
        this.add((Component)this._internalAddrLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._internalAddrTxtField, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._externalAddrLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._externalAddrTxtField, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._dsgLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add(this._dsgComboBox, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._PGsLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._PGsSelected, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._selectPGsButton, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.HOST_EDIT.toString());
        this.setNames();
    }

    private void showSelectPGSDialog(HostObject hostObject) {
        this.selectPGPanel = new SelectPhysicalGroupsPanel(this.grid);
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)this.selectPGPanel, (String)Messages.getString("TimesTenGrid.physicalGroups2"), (ActionListener)this);
        jEWTDialog.setButtonMask(3);
        jEWTDialog.setSize(new Dimension(300, 300));
        jEWTDialog.setMinimumSize(new Dimension(300, 300));
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        this.selectPGPanel.setSelection(this.newPGS);
        jEWTDialog.setVisible(true);
        if (jEWTDialog.isOked()) {
            this.newPGS = this.selectPGPanel.getSelected();
            StringBuilder stringBuilder = new StringBuilder();
            for (PhysicalGroupObject physicalGroupObject : this.newPGS) {
                stringBuilder.append(physicalGroupObject.getName() + ",");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            } else {
                stringBuilder.append(Messages.getString("TimesTenGrid.blank"));
            }
            this._PGsSelected.setText(stringBuilder.toString());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.validInput()) {
            return;
        }
        if (!this.informationChanged(this._internalAddrTxtField.getText().trim(), this._externalAddrTxtField.getText().trim(), this.getDSG())) {
            this._dialog.dispose();
            return;
        }
        this.editHost(this._internalAddrTxtField.getText().trim(), this._externalAddrTxtField.getText().trim(), this.getDSG(), this.newPGS);
        super.actionPerformed(actionEvent);
    }

    private boolean informationChanged(String string, String string2, int n) {
        boolean bl = this.newPGS.containsAll(this.host.getPhysicalGroups()) && this.host.getPhysicalGroups().containsAll(this.newPGS);
        return !string.equals(this.host.getInternalAddress()) || !string2.equals(this.host.getExternalAddress()) || !bl || n != this.host.getDataSpaceGroup();
    }

    private boolean validInput() {
        String string = this._internalAddrTxtField.getText().trim();
        String string2 = this._externalAddrTxtField.getText().trim();
        if (string.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noInternalAddrError"));
            return false;
        }
        if (!Common.validAddress(string)) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.internalAddrFormatError"));
            return false;
        }
        if (string2.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noExternalAddrError"));
            return false;
        }
        if (!Common.validAddress(string2)) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.externalAddrFormatError"));
            return false;
        }
        return true;
    }

    private int getDSG() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this._dsgComboBox.getSelectedItem());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private void editHost(final String string, final String string2, final int n, List<PhysicalGroupObject> list) {
        this._progressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.editHost"), MessageFormat.format(Messages.getString("TimesTenGrid.editingHost"), this.host.getName()), null);
        this._progressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    boolean bl;
                    GridMouseListener.expander.getExpansionState();
                    GridCommand gridCommand = GridCommand.HOST_MODIFY_ADDR;
                    if (EditHostPanel.this.prevDSG == n) {
                        gridCommand.prepareCommand(EditHostPanel.this.host.getName(), string, string2);
                    } else {
                        gridCommand = GridCommand.HOST_MODIFY;
                        if (n == 0) {
                            gridCommand = GridCommand.HOST_MODIFY_NODSG;
                            gridCommand.prepareCommand(EditHostPanel.this.host.getName(), string, string2);
                        } else {
                            gridCommand.prepareCommand(EditHostPanel.this.host.getName(), string, string2, String.valueOf(n));
                        }
                    }
                    boolean bl2 = bl = EditHostPanel.this.newPGS.containsAll(EditHostPanel.this.host.getPhysicalGroups()) && EditHostPanel.this.host.getPhysicalGroups().containsAll(EditHostPanel.this.newPGS);
                    if (!bl) {
                        gridCommand.addHostPGOptions(EditHostPanel.this.host, EditHostPanel.this.newPGS);
                    }
                    EditHostPanel.this._progressMonitor.start();
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.modifyingHost"), EditHostPanel.this.host.getName()));
                    EditHostPanel.this.grid.getExecutor().executeCommandGetJson(gridCommand, true);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    EditHostPanel.this.grid.refreshGridModels();
                    this.firePropertyChange("progress", null, 100);
                }
                catch (JsonException | GridCommandException throwable) {
                    _logger.log(Level.SEVERE, throwable.getMessage());
                    this.firePropertyChange("error", null, throwable.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                EditHostPanel.this._progressMonitor.finish();
                if (!EditHostPanel.this._progressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.modifyHostCancelled"));
                    EditHostPanel.this._progressMonitor.updateMessage(Messages.getString("TimesTenGrid.modifyHostCancelled"));
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    EditHostPanel.this.showModelNeedsApplyWarning();
                    GridMouseListener.expander.setExpansionState();
                }
            }
        };
        swingWorker.addPropertyChangeListener(this._progressMonitor);
        this._progressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    private void setNames() {
        this._internalAddrLabel.setName(Messages.getString("TimesTenGrid.internalAddrLabel"));
        this._externalAddrLabel.setName(Messages.getString("TimesTenGrid.externalAddrLabel"));
        this._dsgLabel.setName(Messages.getString("TimesTenGrid.DSGLabel"));
        this._PGsLabel.setName(Messages.getString("TimesTenGrid.physicalGroups2"));
        this._selectPGsButton.setName(Messages.getString("TimesTenGrid.selectButton"));
        this._PGsSelected.setName("_PGsSelected");
        this._internalAddrTxtField.setName("_internalAddrTxtField", "_internalAddrCmbBox");
        this._externalAddrTxtField.setName("_externalAddrTxtField", "_externalAddrCmbBox");
        this._dsgComboBox.setName("_dsgComboBox");
    }
}

