/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.swing.SwingWorker;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.DeleteBasePanel;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.ide.Ide;

public class DeleteHostPanel
extends DeleteBasePanel {
    private static Logger _logger = Logger.getLogger(DeleteHostPanel.class.getPackage().getName());

    public DeleteHostPanel(String string) {
        super(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.deleteHost();
    }

    private void deleteHost() {
        this._progressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.deleteHost"), MessageFormat.format(Messages.getString("TimesTenGrid.deletingHostPW"), this.hostName), null);
        this._progressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    GridMouseListener.expander.getExpansionState();
                    DeleteHostPanel.this._progressMonitor.start();
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.deletingHost"), DeleteHostPanel.this.hostName));
                    GridCommand gridCommand = GridCommand.HOST_DELETE;
                    gridCommand.prepareCommand(DeleteHostPanel.this.hostName);
                    DeleteHostPanel.this.grid.getExecutor().executeCommandGetString(gridCommand, true);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    DeleteHostPanel.this.grid.setGridComponents(DeleteHostPanel.this.grid.getExecutor().executeCommandGetJson(GridCommand.EXPORT_MODEL, true), false);
                    this.firePropertyChange("progress", null, 100);
                }
                catch (JsonException | GridCommandException throwable) {
                    _logger.log(Level.SEVERE, throwable.getMessage());
                    this.firePropertyChange("error", null, throwable.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                DeleteHostPanel.this._progressMonitor.finish();
                if (this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.hostDeletionCancelled"));
                    DeleteHostPanel.this._progressMonitor.updateMessage(Messages.getString("TimesTenGrid.hostDeletionCancelled"));
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    DeleteHostPanel.this.showModelNeedsApplyWarning();
                    GridMouseListener.expander.setExpansionState();
                }
            }
        };
        swingWorker.addPropertyChangeListener(this._progressMonitor);
        this._progressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }
}

