/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.start.DatabaseTraversablePanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.icons.OracleIcons;

public class BaseTraversablePanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    protected GridObject currentGrid;
    protected JTable _objTable;
    protected AbstractTableModel model;
    protected JButton refreshButton;
    protected JLabel refreshLbl;
    protected JLabel lastRefreshLbl;
    protected JButton actionBtn;
    protected DefaultTableCellRenderer centerRenderer;
    protected JTextPane outputPane;
    protected JComboBox<String> refreshIntervalCmb;
    protected StyledDocument doc;
    protected ExecutorService updateStatusThread;
    protected UpdaterWorker worker;
    protected boolean allRight;
    protected boolean actionBtnClicked;
    protected static final Logger logger = Logger.getLogger(BaseTraversablePanel.class.getName());
    protected Runnable statusUpdate = null;
    protected int waitTime;
    private static final int DEFAULT_WAIT_TIME = 5000;
    protected final String NEW_LINE = System.lineSeparator();
    protected TraversableContext dataContext;
    protected boolean start;

    public BaseTraversablePanel(boolean bl) {
        this.start = bl;
        this.currentGrid = TTGridRootNode.getInstance().getGrid(TTGridRootNode.getInstance().getCurrentGrid());
        this.waitTime = -1;
        this.statusUpdate = new Runnable(){

            @Override
            public void run() {
                try {
                    switch (BaseTraversablePanel.this.refreshIntervalCmb.getSelectedIndex()) {
                        case 0: {
                            BaseTraversablePanel.this.waitTime = -1;
                            break;
                        }
                        case 1: {
                            BaseTraversablePanel.this.waitTime = 1000 * Common.INTERVALS[0];
                            break;
                        }
                        case 2: {
                            BaseTraversablePanel.this.waitTime = 1000 * Common.INTERVALS[1];
                            break;
                        }
                        case 3: {
                            BaseTraversablePanel.this.waitTime = 1000 * Common.INTERVALS[2];
                            break;
                        }
                        case 4: {
                            BaseTraversablePanel.this.waitTime = 1000 * Common.INTERVALS[3];
                        }
                    }
                    if (BaseTraversablePanel.this.waitTime > 0) {
                        Thread.sleep(BaseTraversablePanel.this.waitTime);
                    }
                    while (BaseTraversablePanel.this.waitTime > 0) {
                        logger.info("(Autorefresh) Updating status...");
                        BaseTraversablePanel.this.updateStatus(false);
                        if (BaseTraversablePanel.this.waitTime <= 0) continue;
                        Thread.sleep(BaseTraversablePanel.this.waitTime);
                    }
                    BaseTraversablePanel.this.updateStatusThread.shutdownNow();
                }
                catch (JsonException | GridCommandException throwable) {
                    logger.severe("(Autorefresh) Updating status failed: " + throwable.getMessage());
                }
                catch (InterruptedException interruptedException) {
                    BaseTraversablePanel.this.currentGrid.getExecutor().stopCurrentExecution();
                    logger.info("(Autorefresh) Status update interrupted by user");
                }
            }
        };
    }

    protected void initGUI() {
        this.setLayout(new GridBagLayout());
        this.refreshIntervalCmb = new JComboBox<String>(Common.INTERVAL_OPTIONS);
        this.refreshIntervalCmb.setSelectedIndex(0);
        this.refreshIntervalCmb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    BaseTraversablePanel.this.updateStatusThread.shutdownNow();
                    BaseTraversablePanel.this.updateStatusThread = Executors.newSingleThreadExecutor();
                    BaseTraversablePanel.this.updateStatusThread.execute(BaseTraversablePanel.this.statusUpdate);
                }
            }
        });
        this.refreshButton = new JButton(OracleIcons.getIcon((String)"refresh.png"));
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaseTraversablePanel.this.updateStatusThread.shutdownNow();
                BaseTraversablePanel.this.launchUpdater();
            }
        });
        this.actionBtn = new JButton(this.start ? Messages.getString("TimesTenGrid.startInstances") : Messages.getString("TimesTenGrid.stopInstances"));
        this.actionBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaseTraversablePanel.this.actionBtnClicked = true;
                BaseTraversablePanel.this.enableWizardButtons();
                BaseTraversablePanel.this.worker = new UpdaterWorker(true, true, true);
                BaseTraversablePanel.this.worker.execute();
            }
        });
        this.centerRenderer = new DefaultTableCellRenderer();
        this.centerRenderer.setHorizontalAlignment(0);
        this.outputPane = new JTextPane();
        this.outputPane.setEditable(false);
        this.doc = this.outputPane.getStyledDocument();
        Style style = this.outputPane.addStyle("Regular", null);
        StyleConstants.setFontSize(style, 12);
        StyleConstants.setFontFamily(style, "monospaced");
        this.refreshLbl = new JLabel(Messages.getString("TimestenGrid.refresh"));
        this.lastRefreshLbl = new JLabel(MessageFormat.format(Messages.getString("TimestenGrid.lastRefresh"), ""));
        this.lastRefreshLbl.setToolTipText(this.lastRefreshLbl.getText());
        this.lastRefreshLbl.setLabelFor(this.refreshButton);
        this.add(this.refreshLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.add(this.refreshIntervalCmb, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel jPanel = new JPanel(new BorderLayout(5, 0));
        jPanel.add((Component)this.lastRefreshLbl, "Center");
        jPanel.add((Component)this.refreshButton, "East");
        this.add(jPanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 24, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)new JScrollPane(this.outputPane), new GridBagConstraints(0, 0, 3, 3, 1.0, 0.4, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this.actionBtn, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.2, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(jPanel2, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.4, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setNames();
    }

    protected void printMessageInPanel(String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                this.doc.insertString(this.doc.getLength(), string + this.NEW_LINE, this.doc.getStyle("Regular"));
            }
            catch (BadLocationException badLocationException) {}
        } else {
            SwingUtilities.invokeLater(() -> {
                try {
                    this.doc.insertString(this.doc.getLength(), string + this.NEW_LINE, this.doc.getStyle("Regular"));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            });
        }
    }

    protected void clearOutputPanel() {
        try {
            this.doc.remove(0, this.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected void updateStatus(boolean bl) throws GridCommandException, JsonException {
    }

    protected void executeCommand() {
    }

    protected int getWaitTime() {
        return 5000;
    }

    protected void enableWizardButtons() {
    }

    public void shutdownAutoRefresh() {
        this.updateStatusThread.shutdownNow();
    }

    protected void launchUpdater() {
        this.clearOutputPanel();
        this.worker = new UpdaterWorker(true, false, false);
        this.worker.execute();
        this.updateStatusThread = Executors.newSingleThreadExecutor();
    }

    protected void updateLastRefresh() {
        this.lastRefreshLbl.setText(MessageFormat.format(Messages.getString("TimestenGrid.lastRefresh"), LocalDateTime.now().format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.MEDIUM))));
        this.lastRefreshLbl.setToolTipText(this.lastRefreshLbl.getText());
    }

    private void setNames() {
        this.refreshButton.setName("refreshButton");
        this.refreshLbl.setName(Messages.getString("TimestenGrid.refresh"));
        this.lastRefreshLbl.setName(MessageFormat.format(Messages.getString("TimestenGrid.lastRefresh"), ""));
        this.actionBtn.setName(this.start ? Messages.getString("TimesTenGrid.startInstances") : Messages.getString("TimesTenGrid.stopInstances"));
        this.outputPane.setName("outputPane");
        this.refreshIntervalCmb.setName("refreshIntervalCmb");
    }

    public static enum InstanceActionPanelInstanceType {
        DATA(1),
        MGMT(2);

        private GridCommand.ExecMode execMode;

        private InstanceActionPanelInstanceType(int n2) {
            if (n2 == 1) {
                this.execMode = GridCommand.ExecMode.DATA;
            } else if (n2 == 2) {
                this.execMode = GridCommand.ExecMode.MGMT;
            }
        }

        public GridCommand.ExecMode getExecMode() {
            return this.execMode;
        }
    }

    protected class UpdaterWorker
    extends SwingWorker<Void, Void> {
        CustomProgressMonitor progressMonitor;
        boolean showInfoMsg;
        boolean waitToUpdate;
        boolean executeCmd;
        boolean databaseStep;

        public UpdaterWorker(boolean bl, boolean bl2, boolean bl3) {
            this.showInfoMsg = bl;
            this.waitToUpdate = bl2;
            this.executeCmd = bl3;
            this.databaseStep = BaseTraversablePanel.this instanceof oracle.dbtools.raptor.timesten.grid.shutdown.DatabaseTraversablePanel || BaseTraversablePanel.this instanceof DatabaseTraversablePanel;
            this.progressMonitor = new CustomProgressMonitor((Component)((Object)BaseTraversablePanel.this), this.databaseStep ? Messages.getString("TimesTenGrid.updateDBsInfoTask") : Messages.getString("TimesTenGrid.updateInstancesInfoTask"), Messages.getString("LoadTablesFromOracle.inProgress"), null);
            this.addPropertyChangeListener(this.progressMonitor);
            this.progressMonitor.setSwingWorker(this);
        }

        @Override
        protected Void doInBackground() {
            try {
                this.progressMonitor.start();
                if (this.executeCmd) {
                    BaseTraversablePanel.this.executeCommand();
                }
                if (this.waitToUpdate) {
                    try {
                        Thread.sleep(BaseTraversablePanel.this.getWaitTime());
                    }
                    catch (InterruptedException interruptedException) {
                        logger.log(Level.WARNING, "Interrupted while waiting to update status: " + interruptedException.getMessage());
                    }
                }
                this.firePropertyChange("message", null, this.databaseStep ? Messages.getString("TimesTenGrid.updateDBsInfoTask") : Messages.getString("TimesTenGrid.updateInstancesInfoTask"));
                BaseTraversablePanel.this.updateStatus(this.showInfoMsg);
                this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                this.progressMonitor.updateMessage(Messages.getString("TimesTenGrid.taskComplete"));
                this.firePropertyChange("progress", null, 100);
            }
            catch (JsonException | GridCommandException throwable) {
                this.firePropertyChange("message", null, throwable.getMessage());
                logger.severe(this.databaseStep ? "Could not update databases status:" : "Could not update instances status:" + throwable);
                this.cancel(true);
            }
            return null;
        }

        @Override
        protected void done() {
            this.progressMonitor.finish();
            if (this.progressMonitor.successfulExecution() && !this.isCancelled()) {
                BaseTraversablePanel.this.model.fireTableDataChanged();
                this.progressMonitor.close();
            } else {
                if (this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskCancelled"));
                    this.progressMonitor.updateMessage(Messages.getString("TimesTenGrid.taskCancelled"));
                }
                BaseTraversablePanel.this.currentGrid.getExecutor().stopCurrentExecution();
            }
        }

        public boolean commandExecuted() {
            return this.executeCmd;
        }
    }
}

