/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.format;

import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.timesten.commands.BuiltInProcedure;
import oracle.dbtools.raptor.timesten.extendedtype.BlobType;
import oracle.dbtools.raptor.timesten.extendedtype.VarBinaryType;
import oracle.dbtools.raptor.utils.Connections;

public abstract class GenericResultsFormatter
extends ResultsFormatter {
    private boolean theInterruptFlag;

    public GenericResultsFormatter(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public void interrupt() {
        super.interrupt();
        this.theInterruptFlag = true;
    }

    protected Object getValue(Object object) {
        if (this.isOracle()) {
            return super.getValue(object);
        }
        Object object2 = null;
        if (object instanceof Timestamp) {
            object2 = GenericResultsFormatter.convertToOracleTimestamp((Timestamp)object, true);
        } else if (object instanceof Date) {
            object2 = GenericResultsFormatter.convertToOracleDate((Date)object);
        } else if (object instanceof byte[]) {
            object2 = GenericResultsFormatter.convertBinaryField((byte[])object);
        } else if (object instanceof VarBinaryType) {
            byte[] byArray = (byte[])((VarBinaryType)object).getValue();
            object2 = byArray == null ? byArray : (byte[])GenericResultsFormatter.convertBinaryField(byArray);
        } else if (object instanceof Blob || object instanceof Clob || object instanceof NClob) {
            object2 = object;
        } else if (object instanceof BlobType) {
            object2 = ((BlobType)object).getValue();
        } else if (object instanceof VarBinaryType) {
            object2 = ((VarBinaryType)object).getValue();
        } else if (object instanceof String) {
            object2 = object;
        } else {
            return super.getValue(object);
        }
        return object2;
    }

    public static String convertToOracleDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        long l = date.getTime();
        calendar.clear();
        calendar.setTimeInMillis(l);
        StringBuffer stringBuffer = new StringBuffer(128);
        if (calendar.get(0) == 0) {
            stringBuffer.append("-");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String string = simpleDateFormat.format(calendar.getTime());
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String convertToOracleTimestamp(Timestamp timestamp, boolean bl) {
        Calendar calendar = Calendar.getInstance();
        long l = timestamp.getTime();
        int n = timestamp.getNanos();
        calendar.clear();
        calendar.setTimeInMillis(l);
        calendar.set(14, n / 1000000);
        StringBuffer stringBuffer = new StringBuffer(128);
        if (calendar.get(0) == 0) {
            stringBuffer.append("-");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:");
        String string = simpleDateFormat.format(calendar.getTime());
        stringBuffer.append(string);
        int n2 = calendar.get(13);
        if (bl) {
            double d = (double)n2 * 1.0 + (double)n / 1.0E9;
            DecimalFormat decimalFormat = new DecimalFormat("00.#########");
            stringBuffer.append(decimalFormat.format(d));
        } else {
            stringBuffer.append(n2);
        }
        return stringBuffer.toString();
    }

    public boolean isOracle() {
        Connection connection = this.getWrapper().getConnection();
        Connections connections = Connections.getInstance();
        return connections.isOracle(connection);
    }

    public boolean isTimesTen() {
        Connection connection = this.getWrapper().getConnection();
        Connections connections = Connections.getInstance();
        return connections.isTimesTen(connection);
    }

    private static String convertBinaryField(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(BuiltInProcedure.toHexString(byArray));
        return stringBuffer.toString();
    }

    public String getLineTerminator() {
        String string = System.getProperty("line.separator");
        if (string == null) {
            return super.getLineTerminator();
        }
        return string;
    }

    public void setTableName(String string) {
    }

    public void start() throws IOException {
    }

    public void startRow() throws IOException {
    }

    public void printColumn(Object object, int n, int n2) throws IOException {
    }

    public void endRow() throws IOException {
    }

    public void end() throws IOException {
    }

    public boolean allowsLobs() {
        return true;
    }
}

