/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.timesten.editors.TTTableViewer;
import oracle.dbtools.raptor.utils.DBObject;

public class SequenceMetaDataViewer
extends TTTableViewer {
    private static final Logger _logger = Logger.getLogger(SequenceMetaDataViewer.class.getPackage().getName());
    private SequenceTableModel _model;

    @Override
    protected final String GetPurposeTxt() {
        return "sequence details";
    }

    @Override
    protected void createTableModel() throws Exception {
        if (this._model == null) {
            this._model = new SequenceTableModel(this._dbObject);
            this._table.setModel(this._model);
        } else {
            this._model.init(this._dbObject);
        }
        this._model.fireTableDataChanged();
    }

    public static SequenceTableModel getViewMetaData(Connection connection, String string, String string2) throws Exception {
        return new SequenceTableModel(connection, string, string2);
    }

    public static class SequenceTableModel
    extends AbstractTableModel {
        private final String CLASSIC_DBSQL = "select rtrim(owner) owner , rtrim(name) name, minval , maxval , increment , decode(cycle, 0x00, 'N', 'Y') cycle_flag, cachesize , lastnumber , decode(isreplicated, 0x00, 'N', 'Y') replicated_flag from sys.sequences where name = ':OBJECT_NAME' and  owner = ':OBJECT_OWNER'";
        private final String GRID_DBSQL = "select rtrim(owner) owner, rtrim(name) name , minval , maxval , increment , decode(cycle, 0x00, 'N', 'Y') cycle_flag, cachesize , lastnumber , decode(isreplicated, 0x00, 'N', 'Y') replicated_flag, batchsize from sys.sequences where name = ':OBJECT_NAME' and  owner = ':OBJECT_OWNER'";
        private String[] MAIN_COLUMN_NAMES = new String[]{Messages.getString("TimesTen.common.name"), Messages.getString("TimesTen.common.value")};
        private List<Object> values = new ArrayList<Object>(32);
        private String[] CLASSIC_COLUMNS_NAMES = new String[]{Messages.getString("TimesTen.common.owner"), Messages.getString("TimesTen.common.name"), Messages.getString("TimesTen.sequence.minValue"), Messages.getString("TimesTen.sequence.maxValue"), Messages.getString("TimesTen.sequence.incrementBy"), Messages.getString("TimesTen.sequence.cycleFlag"), Messages.getString("TimesTen.sequence.cacheSize"), Messages.getString("TimesTen.sequence.lastNumber"), Messages.getString("TimesTen.sequence.decode")};
        private String[] GRID_COLUMNS_NAMES = new String[]{Messages.getString("TimesTen.common.owner"), Messages.getString("TimesTen.common.name"), Messages.getString("TimesTen.sequence.minValue"), Messages.getString("TimesTen.sequence.maxValue"), Messages.getString("TimesTen.sequence.incrementBy"), Messages.getString("TimesTen.sequence.cycleFlag"), Messages.getString("TimesTen.sequence.cacheSize"), Messages.getString("TimesTen.sequence.lastNumber"), Messages.getString("TimesTen.sequence.decode"), Messages.getString("TimesTen.sequence.batchValue")};
        private String queryToRun;
        private String[] columnNames;

        private SequenceTableModel(DBObject dBObject) throws Exception {
            try {
                this.init(dBObject);
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process view information " + sQLException.toString());
                throw sQLException;
            }
        }

        private SequenceTableModel(Connection connection, String string, String string2) throws Exception {
            try {
                this.init(connection, string, string2);
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process view information " + sQLException.toString());
                throw sQLException;
            }
        }

        private void setupGridObjects(Connection connection, String string, String string2) {
            if (TimesTenPlugInDatabaseImpl.isGridDatabase(connection)) {
                this.columnNames = this.GRID_COLUMNS_NAMES;
                this.queryToRun = "select rtrim(owner) owner, rtrim(name) name , minval , maxval , increment , decode(cycle, 0x00, 'N', 'Y') cycle_flag, cachesize , lastnumber , decode(isreplicated, 0x00, 'N', 'Y') replicated_flag, batchsize from sys.sequences where name = ':OBJECT_NAME' and  owner = ':OBJECT_OWNER'";
            } else {
                this.columnNames = this.CLASSIC_COLUMNS_NAMES;
                this.queryToRun = "select rtrim(owner) owner , rtrim(name) name, minval , maxval , increment , decode(cycle, 0x00, 'N', 'Y') cycle_flag, cachesize , lastnumber , decode(isreplicated, 0x00, 'N', 'Y') replicated_flag from sys.sequences where name = ':OBJECT_NAME' and  owner = ':OBJECT_OWNER'";
            }
            this.queryToRun = this.queryToRun.replace(":OBJECT_NAME", string2).replace(":OBJECT_OWNER", string);
        }

        private void init(Connection connection, String string, String string2) throws SQLException {
            Statement statement = null;
            ResultSet resultSet = null;
            this.setupGridObjects(connection, string, string2);
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(this.queryToRun);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                this.values.clear();
                if (resultSet.next()) {
                    for (int i = 1; i <= this.columnNames.length; ++i) {
                        this.values.add(resultSet.getObject(i));
                    }
                }
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process index information " + sQLException.toString());
                throw sQLException;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }

        private void init(DBObject dBObject) throws SQLException {
            String string = dBObject.getSchemaName();
            String string2 = dBObject.getObjectName();
            Connection connection = dBObject.getConnection();
            this.init(connection, string, string2);
        }

        @Override
        public final int getColumnCount() {
            return this.MAIN_COLUMN_NAMES.length;
        }

        @Override
        public final int getRowCount() {
            if (this.values != null && !this.values.isEmpty()) {
                return this.values.size();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.columnNames[n];
                }
                case 1: {
                    return this.values.get(n);
                }
            }
            return null;
        }

        @Override
        public final String getColumnName(int n) {
            return this.MAIN_COLUMN_NAMES[n];
        }
    }
}

