/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.AnalysisData;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.AnalysisParam;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Constraint;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.IndexInfo;
import oracle.dbtools.raptor.utils.DBObject;

public class LoadTableRow
implements Comparable<LoadTableRow> {
    private String timesTenUser;
    private String timesTenTable;
    private String selectQuery;
    private String createTableStatement;
    private String oracleUser;
    private Integer parallelLoads;
    private Long rowCount = null;
    private Common.LoadStatus status;
    private long timestenRowCount;
    private long initialTTRowCount;
    private String error;
    private List<IndexInfo> indexes;
    private String idxImportError;
    private String oracleTable;
    private boolean enableParallelLoad;
    private AnalysisData analysisData = null;
    private String analysisLog = "";
    private String analysisDDL = "";
    private boolean alreadyExist;
    private LoadDataResult loadDataResult;
    private List<Constraint> constraints;
    private Constraint.TableDistribution tableDist;
    private List<Constraint.Column> availableColumns;
    private Pattern matcherPattern = Pattern.compile("\"([^\"]*)\"");
    private boolean childTable;
    private boolean parentTable;
    private boolean defaultDistribution;
    private Long oracleSCN;
    private boolean createTableOnly;
    private static Logger _logger = Logger.getLogger(LoadTableRow.class.getPackage().getName());
    private static String NEW_LINE = System.lineSeparator();

    public LoadTableRow(String string, String string2, String string3, String string4) {
        this.timesTenUser = string.toUpperCase();
        this.oracleUser = string;
        this.timesTenTable = string2.toUpperCase();
        this.selectQuery = string3;
        this.createTableStatement = string4;
        this.enableParallelLoad = Common.validQuery(string3);
        this.parallelLoads = 1;
        this.status = Common.LoadStatus.WAITING;
        this.idxImportError = "";
        this.oracleTable = "";
        if (Common.isGrid().booleanValue()) {
            this.defaultDistribution = true;
            this.tableDist = new Constraint.TableDistribution(Constraint.DistributionType.HASH);
        }
    }

    public String getTimesTenUser() {
        return this.timesTenUser;
    }

    public List<IndexInfo> getIndexes() {
        return this.indexes;
    }

    public int getCreatedIndexesCount() {
        int n = 0;
        for (IndexInfo indexInfo : this.indexes) {
            if (indexInfo.getIndexStatus() != IndexInfo.IndexStatus.CREATED) continue;
            ++n;
        }
        return n;
    }

    public String getIdxImportError() {
        return this.idxImportError;
    }

    public String getOracleTable() {
        return this.oracleTable;
    }

    public void setIdxImportError(String string) {
        this.idxImportError = string;
    }

    public void setIndexes(List<IndexInfo> list) {
        this.indexes = list;
    }

    public void setOracleTable(String string) {
        this.oracleTable = string;
    }

    public void setTimesTenUser(String string) {
        this.timesTenUser = string.toUpperCase();
        this.updateCreateTableOnUserNameUpdate(this.timesTenUser);
    }

    public String getTimesTenTable() {
        return this.timesTenTable;
    }

    public void setTimesTenTable(String string) {
        this.timesTenTable = string.toUpperCase();
        this.updateCreateTableOnTableNameUpdate(this.timesTenTable);
    }

    public String getSelectQuery() {
        return this.selectQuery;
    }

    public void setSelectQuery(String string) {
        this.selectQuery = string;
        this.enableParallelLoad = Common.validQuery(string);
    }

    public String getCreateTableStatement() {
        if (!this.analysisDDL.isEmpty()) {
            return this.analysisDDL;
        }
        return this.createTableStatement;
    }

    public String getCreateGridTableStatement() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.analysisDDL.isEmpty()) {
            stringBuilder.append(this.analysisDDL);
        } else {
            stringBuilder.append(this.createTableStatement);
        }
        stringBuilder.append(";");
        if (this.constraints != null && !this.constraints.isEmpty()) {
            stringBuilder.append(this.getConstraintDDL());
            stringBuilder.append(this.getUniqueConstraintDDL());
        }
        if (!(this.tableDist == null || this.tableDist.getDistributionType() == Constraint.DistributionType.HASH && this.tableDist.getHashColumns().isEmpty())) {
            stringBuilder.append(this.tableDist.getDDL().replace("#TABLE#", this.getTimesTenTable()));
        }
        return stringBuilder.toString();
    }

    public void setCreateTableStatement(String string) {
        this.createTableStatement = string;
    }

    public Long getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(Long l) {
        this.rowCount = l;
        if (!Common.isAcadia().booleanValue() && l != null && l > 500000L && !Common.isParallelLoadEnabled(this.parallelLoads)) {
            this.parallelLoads = 2;
        }
    }

    public Integer getParallelLoads() {
        return this.parallelLoads;
    }

    public void setParallelLoads(Integer n) {
        this.parallelLoads = n;
    }

    public boolean getEnableParallelLoad() {
        return this.enableParallelLoad;
    }

    public void setEnableParallelLoad(boolean bl) {
        this.enableParallelLoad = bl;
    }

    private void updateCreateTableOnTableNameUpdate(String string) {
        if (this.getTimesTenTable() != null && this.getTimesTenTable().length() > 0 && this.createTableStatement != null) {
            StringBuffer stringBuffer = new StringBuffer(this.createTableStatement);
            int n = stringBuffer.indexOf("\".\"");
            int n2 = stringBuffer.indexOf("\"", n + 3);
            if (n >= 0 && n2 >= 0) {
                stringBuffer.replace(n + 3, n2, string);
            }
            this.createTableStatement = stringBuffer.toString();
            if (!this.analysisDDL.isEmpty()) {
                this.analysisDDL = stringBuffer.toString();
            }
        }
    }

    private void updateCreateTableOnUserNameUpdate(String string) {
        if (this.getTimesTenTable() != null && this.getTimesTenTable().length() > 0 && this.createTableStatement != null) {
            StringBuffer stringBuffer = new StringBuffer(this.createTableStatement);
            int n = stringBuffer.indexOf("\"");
            int n2 = stringBuffer.indexOf("\"", n + 1);
            if (n >= 0 && n2 >= 0) {
                stringBuffer.replace(n + 1, n2, string);
            }
            this.createTableStatement = stringBuffer.toString();
            if (!this.analysisDDL.isEmpty()) {
                this.analysisDDL = stringBuffer.toString();
            }
        }
    }

    public void setStatus(Common.LoadStatus loadStatus) {
        this.status = loadStatus;
    }

    public Common.LoadStatus getStatusFromLoadResult() {
        Common.LoadStatus loadStatus = Common.LoadStatus.LOADED;
        if (this.loadDataResult.getErrorCode() == Common.LoadStatus.SQL_EXCEPTION.getValue()) {
            loadStatus = Common.LoadStatus.SQL_EXCEPTION;
        } else if (this.loadDataResult.getErrorCode() == Common.LoadStatus.FATAL_ERROR.getValue()) {
            loadStatus = Common.LoadStatus.FATAL_ERROR;
        } else if (this.loadDataResult.getErrorCode() == Common.LoadStatus.ERROR.getValue()) {
            loadStatus = Common.LoadStatus.ERROR;
        } else if ((this.loadDataResult.getErrorCode() != Common.LoadStatus.LOADED.getValue() || loadStatus != Common.LoadStatus.LOADED) && this.loadDataResult.getErrorCode() == Common.LoadStatus.LOADED_ERROR.getValue()) {
            loadStatus = Common.LoadStatus.LOADED_ERROR;
        }
        return loadStatus;
    }

    public Common.LoadStatus getStatus() {
        return this.status;
    }

    public String getStatusText() {
        if (this.status != Common.LoadStatus.SQL_EXCEPTION) {
            return this.status.getStatusMessage();
        }
        return this.error;
    }

    public String getIndexMsgs() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.indexes != null) {
            if (this.idxImportError.equals("")) {
                int n = this.indexes.size();
                String string = "";
                string = n == 1 ? Messages.getString("LoadTablesFromOracle.indexCreationOneIndex") : Messages.getString("LoadTablesFromOracle.indexCreationSeveralIndexes");
                stringBuilder.append(MessageFormat.format(string, n, this.oracleTable));
                n = 1;
                for (IndexInfo indexInfo : this.indexes) {
                    stringBuilder.append(NEW_LINE + "* ");
                    stringBuilder.append(indexInfo.getStatusMsg());
                }
            } else {
                stringBuilder.append(this.idxImportError);
            }
        }
        return stringBuilder.toString();
    }

    public void setError(String string) {
        this.error = string;
    }

    public void setTimestenRowCount(long l) {
        this.timestenRowCount = l;
    }

    public long getTimestenRowCount() {
        return this.timestenRowCount;
    }

    public void setInitialTTRowCount(long l) {
        this.initialTTRowCount = l;
    }

    public long getInitialTTRowCount() {
        return this.initialTTRowCount;
    }

    public String getTimestenTableCountSQL() {
        return "SELECT count(*) from " + this.timesTenUser + "." + this.timesTenTable;
    }

    public String getSelectCountSQL() {
        return "SELECT count(*) FROM (" + this.selectQuery + ")";
    }

    public AnalysisData getAnalysisData() {
        return this.analysisData;
    }

    public void setAnalysisData(AnalysisData analysisData) {
        this.analysisData = analysisData;
    }

    public String getAnalysisLog() {
        StringBuilder stringBuilder = new StringBuilder(this.analysisLog != null ? this.analysisLog + NEW_LINE : "");
        if (this.analysisData != null) {
            stringBuilder.append(this.analysisData.getWarningStr());
        }
        return stringBuilder.toString();
    }

    public void setAnalysisLog(String string) {
        this.analysisLog = string;
    }

    public String getOracleUser() {
        return this.oracleUser;
    }

    public void setOracleUser(String string) {
        this.oracleUser = string;
    }

    public void setAnalysisDDL(AnalysisParam analysisParam) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        if (this.analysisData != null && this.analysisData.getTableInfo() != null && this.analysisData.getColumnData() != null) {
            AnalysisData.TableInfo tableInfo = this.analysisData.getTableInfo();
            stringBuilder.append("CREATE TABLE ");
            stringBuilder.append("\"" + this.timesTenUser + "\"");
            stringBuilder.append(".");
            stringBuilder.append("\"" + this.timesTenTable + "\"");
            stringBuilder.append(NEW_LINE);
            stringBuilder.append("(" + NEW_LINE);
            for (AnalysisData.ColumnData columnData : this.analysisData.getColumnData()) {
                if (!columnData.getSkipped().equalsIgnoreCase("N") || !columnData.shouldBeMapped(analysisParam)) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append("," + NEW_LINE);
                }
                stringBuilder.append("    ");
                stringBuilder.append(columnData.getColumnName());
                for (int i = columnData.getColumnName().length(); i < 35; ++i) {
                    stringBuilder.append(" ");
                }
                switch (columnData.getTTTypeCode()) {
                    case 2: {
                        stringBuilder.append("VARCHAR2(");
                        stringBuilder.append(String.valueOf(columnData.getTTCharLength()));
                        stringBuilder.append(" ");
                        if (columnData.getLengthSemantics().equalsIgnoreCase("C")) {
                            stringBuilder.append("CHAR");
                        } else {
                            stringBuilder.append("BYTE");
                        }
                        stringBuilder.append(")");
                        if (columnData.getOutOfLineFlag().equalsIgnoreCase("Y")) {
                            stringBuilder.append(" NOT INLINE");
                            break;
                        }
                        if (!columnData.getOutOfLineFlag().equalsIgnoreCase("N")) break;
                        stringBuilder.append(" INLINE");
                        break;
                    }
                    case 3: {
                        stringBuilder.append("NVARCHAR2(");
                        stringBuilder.append(String.valueOf(columnData.getTTCharLength()));
                        stringBuilder.append(")");
                        if (columnData.getOutOfLineFlag().equalsIgnoreCase("Y")) {
                            stringBuilder.append(" NOT INLINE");
                            break;
                        }
                        if (!columnData.getOutOfLineFlag().equalsIgnoreCase("N")) break;
                        stringBuilder.append(" INLINE");
                        break;
                    }
                    case 4: {
                        stringBuilder.append("NUMBER");
                        if (columnData.getTTPrecision() != -999999999) {
                            stringBuilder.append("(");
                            stringBuilder.append(String.valueOf(columnData.getTTPrecision()));
                            if (columnData.getTTScale() != -999999999) {
                                stringBuilder.append(",");
                                stringBuilder.append(String.valueOf(columnData.getTTScale()));
                            }
                            stringBuilder.append(")");
                            break;
                        }
                        if (columnData.getTTScale() == -999999999) break;
                        stringBuilder.append("(");
                        stringBuilder.append(String.valueOf(38));
                        stringBuilder.append(",");
                        stringBuilder.append(String.valueOf(columnData.getTTScale()));
                        stringBuilder.append(")");
                        break;
                    }
                    case 5: {
                        stringBuilder.append("FLOAT(");
                        stringBuilder.append(String.valueOf(columnData.getTTPrecision()));
                        stringBuilder.append(")");
                        break;
                    }
                    case 6: {
                        stringBuilder.append("DATE");
                        break;
                    }
                    case 7: {
                        stringBuilder.append("BINARY_FLOAT");
                        break;
                    }
                    case 8: {
                        stringBuilder.append("BINARY_DOUBLE");
                        break;
                    }
                    case 9: {
                        stringBuilder.append("TIMESTAMP");
                        if (columnData.getTTScale() == -999999999) break;
                        stringBuilder.append("(");
                        stringBuilder.append(String.valueOf(columnData.getTTScale()));
                        stringBuilder.append(")");
                        break;
                    }
                    case 10: {
                        stringBuilder.append("CHAR(");
                        stringBuilder.append(String.valueOf(columnData.getTTCharLength()));
                        stringBuilder.append(" ");
                        if (columnData.getLengthSemantics().equalsIgnoreCase("C")) {
                            stringBuilder.append("CHAR");
                        } else {
                            stringBuilder.append("BYTE");
                        }
                        stringBuilder.append(")");
                        break;
                    }
                    case 11: {
                        stringBuilder.append("NCHAR(");
                        stringBuilder.append(String.valueOf(columnData.getTTCharLength()));
                        stringBuilder.append(")");
                        break;
                    }
                    case 12: {
                        stringBuilder.append("CLOB");
                        break;
                    }
                    case 13: {
                        stringBuilder.append("NCLOB");
                        break;
                    }
                    case 14: {
                        stringBuilder.append("BLOB");
                        break;
                    }
                    case 15: {
                        stringBuilder.append("TT_TINYINT");
                        break;
                    }
                    case 16: {
                        stringBuilder.append("TT_SMALLINT");
                        break;
                    }
                    case 17: {
                        stringBuilder.append("TT_INTEGER");
                        break;
                    }
                    case 18: {
                        stringBuilder.append("TT_BIGINT");
                        break;
                    }
                    case 19: {
                        stringBuilder.append("VARBINARY(");
                        stringBuilder.append(String.valueOf(columnData.getTTCharLength()));
                        stringBuilder.append(")");
                        if (columnData.getOutOfLineFlag().equalsIgnoreCase("Y")) {
                            stringBuilder.append(" NOT INLINE");
                            break;
                        }
                        if (!columnData.getOutOfLineFlag().equalsIgnoreCase("N")) break;
                        stringBuilder.append(" INLINE");
                    }
                }
                if (!columnData.getNullable().equalsIgnoreCase("N")) continue;
                stringBuilder.append(" NOT NULL");
            }
            stringBuilder.append(NEW_LINE);
            stringBuilder.append(")");
            stringBuilder.append(NEW_LINE);
            if (tableInfo.getCompressed().equalsIgnoreCase("Y") && analysisParam.getCompression() != 0) {
                bl = true;
                stringBuilder.append(NEW_LINE + "COMPRESS" + NEW_LINE + "(" + NEW_LINE);
                for (AnalysisData.ColumnData columnData : this.analysisData.getColumnData()) {
                    if (!columnData.getSkipped().equalsIgnoreCase("N") || columnData.getTTCompressionPointerSize() <= 0) continue;
                    long l = 0L;
                    if (analysisParam.getCompression() == 2) {
                        switch (columnData.getTTCompressionPointerSize()) {
                            case 1: {
                                l = 255L;
                                break;
                            }
                            case 2: {
                                l = 65535L;
                                break;
                            }
                            case 4: {
                                l = 0xFFFFFFFFL;
                                break;
                            }
                            default: {
                                l = 0L;
                            }
                        }
                    }
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append("," + NEW_LINE);
                    }
                    stringBuilder.append("    ");
                    stringBuilder.append(columnData.getColumnName());
                    for (int i = columnData.getColumnName().length(); i < 35; ++i) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append("BY DICTIONARY");
                    if (l <= 0L) continue;
                    stringBuilder.append(" MAXVALUES = ");
                    stringBuilder.append(String.valueOf(l));
                }
                stringBuilder.append(NEW_LINE + ")" + NEW_LINE + "OPTIMIZED FOR READ");
            }
            this.analysisDDL = stringBuilder.toString();
            this.setCreateTableStatement(this.analysisDDL);
        }
    }

    public boolean alreadyExist() {
        return this.alreadyExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlreadyExist(DBObject dBObject) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = dBObject.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT COUNT(1) FROM ALL_TABLES WHERE TABLE_NAME = UPPER('#TABLE#') AND OWNER = UPPER('#OWNER#')".replace("#TABLE#", this.timesTenTable).replace("#OWNER#", this.timesTenUser));
            this.alreadyExist = resultSet.next() ? resultSet.getInt(1) == 1 : false;
        }
        catch (SQLException sQLException) {
            this.alreadyExist = false;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public void addConstraint(Constraint constraint) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<Constraint>();
        }
        this.constraints.add(constraint);
    }

    public Constraint getConstraint(Constraint constraint) {
        for (Constraint constraint2 : this.constraints) {
            if (!constraint2.equals(constraint)) continue;
            return constraint2;
        }
        return null;
    }

    private String getConstraintDDL() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Constraint constraint : this.constraints) {
            if (!constraint.addConstraint()) continue;
            if (constraint.getConstraintType() == IndexInfo.ConstraintType.PRIMARY) {
                stringBuilder.append(NEW_LINE + "ALTER TABLE ");
                stringBuilder.append(this.getTimesTenTable());
                stringBuilder.append(" ADD CONSTRAINT ");
                stringBuilder.append(constraint.getName());
                stringBuilder.append(" PRIMARY KEY(");
                stringBuilder.append(constraint.getColumnStr());
                stringBuilder.append(")");
                stringBuilder.append(";");
                continue;
            }
            if (constraint.getConstraintType() != IndexInfo.ConstraintType.FOREIGN) continue;
            stringBuilder.append(NEW_LINE + "ALTER TABLE ");
            stringBuilder.append(this.getTimesTenTable());
            stringBuilder.append(NEW_LINE + " ADD CONSTRAINT ");
            stringBuilder.append(constraint.getName());
            stringBuilder.append(NEW_LINE + " FOREIGN KEY(");
            stringBuilder.append(constraint.getColumnStr());
            stringBuilder.append(")");
            stringBuilder.append(NEW_LINE + " REFERENCES ");
            stringBuilder.append(constraint.getRTableName() + "(");
            stringBuilder.append(constraint.getRConstraint().getColumnStr());
            stringBuilder.append(")");
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    private String getUniqueConstraintDDL() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Constraint constraint : this.constraints) {
            if (!constraint.addConstraint() || constraint.getConstraintType() != IndexInfo.ConstraintType.UNIQUE) continue;
            stringBuilder.append(NEW_LINE + "CREATE UNIQUE INDEX ");
            stringBuilder.append(this.getTimesTenUser() + "." + constraint.getName());
            stringBuilder.append(NEW_LINE + " ON ");
            stringBuilder.append(this.getTimesTenUser() + "." + this.getTimesTenTable());
            stringBuilder.append(NEW_LINE + " (");
            stringBuilder.append(constraint.getColumnStr());
            stringBuilder.append(")");
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    public Constraint.TableDistribution getTableDistribution() {
        return this.tableDist;
    }

    public void setTableDistribution(Constraint.TableDistribution tableDistribution) {
        this.defaultDistribution = this.defaultDistribution && this.tableDist.getDistributionType() == Constraint.DistributionType.HASH && this.tableDist.getHashColumns().isEmpty() && tableDistribution.getDistributionType() == Constraint.DistributionType.HASH && tableDistribution.getHashColumns().isEmpty();
        this.tableDist = tableDistribution;
    }

    public boolean isDefaultDistribution() {
        return this.defaultDistribution;
    }

    public List<Constraint.Column> getAvailableColumns() {
        this.availableColumns = new ArrayList<Constraint.Column>();
        Matcher matcher = this.matcherPattern.matcher(this.getCreateTableStatement());
        int n = 1;
        while (matcher.find()) {
            String string;
            String[] stringArray = matcher.group().split("\"");
            if (stringArray == null || (string = stringArray[1]).equalsIgnoreCase(this.getTimesTenUser()) || string.equalsIgnoreCase(this.getTimesTenTable())) continue;
            this.availableColumns.add(new Constraint.Column(string, n++));
        }
        return this.availableColumns;
    }

    public boolean isChildTable() {
        return this.childTable;
    }

    public void setChildTable(boolean bl) {
        this.childTable = bl;
    }

    public boolean isParentTable() {
        return this.parentTable;
    }

    public void setParentTable(boolean bl) {
        this.parentTable = bl;
    }

    public LoadDataResult getLoadDataResult() {
        return this.loadDataResult;
    }

    public void setLoadDataResult(LoadDataResult loadDataResult) {
        this.loadDataResult = loadDataResult;
    }

    public void setOracleSCN(Long l) {
        this.oracleSCN = l;
    }

    public Long getOracleSCN() {
        return this.oracleSCN;
    }

    public void setCreateTableOnly(boolean bl) {
        this.createTableOnly = bl;
    }

    public boolean getCreateTableOnly() {
        return this.createTableOnly;
    }

    @Override
    public int compareTo(LoadTableRow loadTableRow) {
        if (!(this.childTable || this.parentTable || loadTableRow.isChildTable() || loadTableRow.isParentTable())) {
            return 0;
        }
        if (this.childTable) {
            if (this.parentTable) {
                if (loadTableRow.isChildTable()) {
                    if (loadTableRow.isParentTable()) {
                        return 0;
                    }
                    return -1;
                }
                return 1;
            }
            if (loadTableRow.isChildTable()) {
                if (loadTableRow.isParentTable()) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }
        if (loadTableRow.isChildTable()) {
            if (loadTableRow.isParentTable()) {
                return -1;
            }
            return -1;
        }
        return 0;
    }

    static class LFOError {
        int errorCode;
        String errorMessage;

        public LFOError(int n, String string) {
            this.errorCode = n;
            this.errorMessage = string;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    static class LoadDataResult {
        private int errorCode;
        private long rowsLoaded;
        private long rowsWithErrors;
        private String additionalData;
        private List<LFOError> errors;
        private String started;
        private String ended;
        private String oracleSCN;
        private String errorStr;
        private String query;
        private int index;

        public LoadDataResult(String string, int n, long l, long l2, int n2, String string2) {
            this.query = string;
            this.index = n;
            this.rowsLoaded = l;
            this.rowsWithErrors = l2;
            this.errorCode = n2;
            this.additionalData = string2;
            this.errors = new ArrayList<LFOError>();
            this.setAdditionalData();
        }

        public LoadDataResult(String string, int n, String string2) {
            this.query = string;
            this.index = n;
            this.errors = new ArrayList<LFOError>();
            this.errorStr = string2;
        }

        public LoadDataResult(String string) {
            this.oracleSCN = string;
        }

        public String getQuery() {
            return this.query;
        }

        public int getIndex() {
            return this.index;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public long getRowsLoaded() {
            return this.rowsLoaded;
        }

        public long getRowsWithErrors() {
            return this.rowsWithErrors;
        }

        public String getAdditionalData() {
            return this.additionalData;
        }

        public void setAdditionalData() {
            String string = "Started=";
            int n = this.additionalData.indexOf(string);
            try {
                this.started = this.additionalData.substring(n + string.length(), this.additionalData.indexOf(";", n));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                _logger.log(Level.INFO, "'Started' not found in error message: " + this.additionalData);
            }
            string = "Ended=";
            n = this.additionalData.indexOf(string);
            try {
                this.ended = this.additionalData.substring(n + string.length(), this.additionalData.indexOf(";", n));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                _logger.log(Level.INFO, "'Ended' not found in error message: " + this.additionalData);
            }
            string = "OracleSCN=";
            n = this.additionalData.indexOf(string);
            try {
                this.oracleSCN = this.additionalData.substring(n + string.length(), this.additionalData.indexOf(";", n));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                _logger.log(Level.INFO, "'OracleSCN' not found in error message: " + this.additionalData);
            }
        }

        public String getStarted() {
            return this.started;
        }

        public String getEnded() {
            return this.ended;
        }

        public String getOracleSCN() {
            return this.oracleSCN;
        }

        public List<LFOError> getErrors() {
            return this.errors;
        }

        public String getErrorString() {
            return this.errorStr;
        }

        public void setErrors(List<LFOError> list) {
            this.errors = list;
            this.setErrorString();
        }

        private void setErrorString() {
            int n = 1;
            StringBuilder stringBuilder = new StringBuilder();
            for (LFOError lFOError : this.errors) {
                stringBuilder.append(n++ + ". ");
                stringBuilder.append(lFOError.getErrorMessage());
                stringBuilder.append(NEW_LINE);
            }
            this.errorStr = stringBuilder.toString();
        }
    }
}

