/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Common;

public class LoadOptions {
    private int numberOfThreads;
    private int parallelLoads;
    private int readers;
    private int errorThreshold;
    private boolean ignoreDuplicates;
    private Long resumeFromSCN;
    private boolean directLoad;
    private boolean localOnly;
    private IndexCreationPolicy idxCrtPolicy;
    private boolean createIdxsIfNoErrors;

    public LoadOptions() {
        this.setDefaultValues();
    }

    public LoadOptions(String string, int n, String string2, boolean bl) {
        this.setDefaultValues();
        this.numberOfThreads = n;
        if (string2.equalsIgnoreCase(Messages.getString("LoadTablesFromOracle.indexCreationOption2"))) {
            this.idxCrtPolicy = IndexCreationPolicy.COPY_UNIQUE_IDXS;
        } else if (string2.equalsIgnoreCase(Messages.getString("LoadTablesFromOracle.indexCreationOption3"))) {
            this.idxCrtPolicy = IndexCreationPolicy.NO_COPY_IDXS;
        }
        this.setCreateIndexesIfNoErrors(bl);
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            if (stringArray[i].contains("ErrorThreshold")) {
                stringArray2 = stringArray[i].split("=");
                if (stringArray2 == null || stringArray2.length <= 1) continue;
                this.setErrorThreshold(Integer.parseInt(stringArray2[1]));
                continue;
            }
            if (stringArray[i].contains("IgnoreDuplicates")) {
                stringArray2 = stringArray[i].split("=");
                if (stringArray2 == null || stringArray2.length <= 1) continue;
                this.setIgnoreDuplicates(stringArray2[1].equalsIgnoreCase("Y"));
                continue;
            }
            if (stringArray[i].contains("ResumeFromSCN")) {
                stringArray2 = stringArray[i].split("=");
                if (stringArray2 == null || stringArray2.length <= 1) continue;
                this.setResumeFromSCN(Long.parseLong(stringArray2[1]));
                continue;
            }
            if (stringArray[i].contains("LocalOnly")) {
                stringArray2 = stringArray[i].split("=");
                if (stringArray2 == null || stringArray2.length <= 1) continue;
                this.setLocalOnly(stringArray2[1].equalsIgnoreCase("Y"));
                continue;
            }
            if (stringArray[i].contains("DirectLoad")) {
                stringArray2 = stringArray[i].split("=");
                if (stringArray2 == null || stringArray2.length <= 1) continue;
                this.setDirectLoad(stringArray2[1].equalsIgnoreCase("Y"));
                continue;
            }
            if (!stringArray[i].contains("Readers") || (stringArray2 = stringArray[i].split("=")) == null || stringArray2.length <= 1) continue;
            this.setReaders(Integer.parseInt(stringArray2[1]));
        }
    }

    public void setDefaultValues() {
        if (Common.isAcadia().booleanValue()) {
            this.parallelLoads = 1;
            this.numberOfThreads = 3;
            this.errorThreshold = 1;
            this.ignoreDuplicates = false;
            this.resumeFromSCN = null;
            this.readers = 1;
            if (Common.isGrid().booleanValue()) {
                this.localOnly = false;
            } else {
                this.directLoad = true;
            }
        } else {
            this.numberOfThreads = 4;
            this.parallelLoads = 1;
        }
        this.idxCrtPolicy = IndexCreationPolicy.COPY_ALL_IDXS;
        this.createIdxsIfNoErrors = true;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int n) {
        this.numberOfThreads = n;
    }

    public int getParallelLoads() {
        return this.parallelLoads;
    }

    public void setParallelLoads(int n) {
        this.parallelLoads = n;
    }

    public int getReaders() {
        return this.readers;
    }

    public void setReaders(int n) {
        this.readers = n;
    }

    public int getErrorThreshold() {
        return this.errorThreshold;
    }

    public void setErrorThreshold(int n) {
        this.errorThreshold = n;
    }

    public boolean isIgnoreDuplicates() {
        return this.ignoreDuplicates;
    }

    public void setIgnoreDuplicates(boolean bl) {
        this.ignoreDuplicates = bl;
    }

    public Long getResumeFromSCN() {
        return this.resumeFromSCN;
    }

    public void setResumeFromSCN(Long l) {
        this.resumeFromSCN = l;
    }

    public boolean isDirectLoad() {
        return this.directLoad;
    }

    public void setDirectLoad(boolean bl) {
        this.directLoad = bl;
    }

    public boolean isLocalOnly() {
        return this.localOnly;
    }

    public void setLocalOnly(boolean bl) {
        this.localOnly = bl;
    }

    public IndexCreationPolicy getIndexCreationtPolicy() {
        return this.idxCrtPolicy;
    }

    public void setIndexCreationPolicy(IndexCreationPolicy indexCreationPolicy) {
        this.idxCrtPolicy = indexCreationPolicy;
    }

    public boolean createIndexesIfNoErrors() {
        return this.createIdxsIfNoErrors;
    }

    public void setCreateIndexesIfNoErrors(boolean bl) {
        this.createIdxsIfNoErrors = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ErrorThreshold=");
        stringBuilder.append(this.errorThreshold);
        stringBuilder.append(";");
        stringBuilder.append("IgnoreDuplicates=");
        stringBuilder.append(this.ignoreDuplicates ? "Y" : "N");
        stringBuilder.append(";");
        if (this.resumeFromSCN != null) {
            stringBuilder.append("ResumeFromSCN=");
            stringBuilder.append(this.resumeFromSCN);
            stringBuilder.append(";");
        }
        if (Common.isAcadia().booleanValue()) {
            if (Common.isGrid().booleanValue()) {
                stringBuilder.append("LocalOnly=");
                stringBuilder.append(this.localOnly ? "Y" : "N");
                stringBuilder.append(";");
            } else {
                stringBuilder.append("DirectLoad=");
                stringBuilder.append(this.directLoad ? "Y" : "N");
                stringBuilder.append(";");
            }
        }
        stringBuilder.append("Readers=");
        stringBuilder.append(this.readers);
        stringBuilder.append(";");
        return stringBuilder.toString();
    }

    public static enum IndexCreationPolicy {
        COPY_ALL_IDXS(Messages.getString("LoadTablesFromOracle.indexCreationOption1")),
        COPY_UNIQUE_IDXS(Messages.getString("LoadTablesFromOracle.indexCreationOption2")),
        NO_COPY_IDXS(Messages.getString("LoadTablesFromOracle.indexCreationOption3"));

        private final String policy;

        private IndexCreationPolicy(String string2) {
            this.policy = string2;
        }

        public String toString() {
            return this.policy;
        }
    }
}

