/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.connection.X10ConnectionProperties;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.AnalysisData;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.AnalysisParam;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTableRow;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OracleCallableStatement;

public class Analyzer {
    private Connection oracleConn = null;
    private OracleCallableStatement oCallableStatement;
    private DBObject _dbObject;
    private AnalysisParam parameters;
    private boolean initializedOraConn;
    private String analysisLogFile;
    private static final String EXT_ID = "oracle.sqldeveloper.timesten";
    private static final String LOG_FILENAME = "lfo_analysis.res";
    private static final String PLSQL_FILE = "tabanalyze.sql";
    private static final String ORCL_NET_TNS_ADMIN_PROP = "oracle.net.tns_admin";
    private static final String ORACLE_URL_PREFIX = "jdbc:oracle:thin:@";
    private static final String TNS_ENTRY_SID = "(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=#HOST#)(PORT=#PORT#))(CONNECT_DATA=(SID=#SID#))) ";
    private static final String TNS_ENTRY_SERVICE_NAME = "(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=#HOST#)(PORT=#PORT#))(CONNECT_DATA=(SERVICE_NAME=#SERVICE_NAME#))) ";
    private static Logger _logger = Logger.getLogger(Analyzer.class.getPackage().getName());

    public Analyzer(DBObject dBObject) {
        this._dbObject = dBObject;
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        URL uRL = extensionRegistry.getSystemDirectory(EXT_ID);
        URL uRL2 = URLFactory.newURL((URL)uRL, (String)LOG_FILENAME);
        this.analysisLogFile = uRL2.getFile();
    }

    public void setAnalysisParameters(AnalysisParam analysisParam) {
        this.parameters = analysisParam;
        this.saveAnalysisParameters();
    }

    public LoadTableRow getTable(String string, String string2, String string3, String string4) {
        LoadTableRow loadTableRow = null;
        if (!this.initializedOraConn) {
            this.initOracleConn();
        }
        if (!this.initializedOraConn) {
            return loadTableRow;
        }
        loadTableRow = new LoadTableRow(string, string2, string3, "");
        loadTableRow.setOracleUser(string4);
        this.analyzeTable(loadTableRow);
        return loadTableRow;
    }

    private void initOracleConn() {
        String string = Connections.getDisplayName((String)this._dbObject.getConnectionName());
        X10ConnectionProperties x10ConnectionProperties = X10ConnectionProperties.getTheInstance();
        String string2 = x10ConnectionProperties.getProperty(string, "ORANETSERVICENAME").toLowerCase();
        String string3 = x10ConnectionProperties.getProperty(string, "sys2");
        String string4 = x10ConnectionProperties.getProperty(string, "user");
        try {
            String string5;
            if (System.getProperty(ORCL_NET_TNS_ADMIN_PROP) == null) {
                string5 = System.getenv("TNS_ADMIN");
                if (string5 == null) {
                    throw new SQLRecoverableException(Messages.getString("LoadTablesFromOracle.noTNSADMINNotSet"));
                }
                System.setProperty(ORCL_NET_TNS_ADMIN_PROP, string5);
            }
            string5 = ORACLE_URL_PREFIX + string2;
            this.oracleConn = DriverManager.getConnection(string5, string4, string3);
            this.oCallableStatement = (OracleCallableStatement)this.oracleConn.prepareCall(this.getAnonymousBlock());
            this.initializedOraConn = true;
        }
        catch (SQLRecoverableException sQLRecoverableException) {
            this.initializedOraConn = this.showOracleInputDialog(string4, string3);
        }
        catch (Exception exception) {
            MessageDialog.error(null, (Object)exception.getMessage(), (String)Messages.getString("TimesTen.common.error"), null);
            this.initializedOraConn = false;
        }
    }

    private boolean showOracleInputDialog(final String string, final String string2) {
        final OracleDBDataPanel oracleDBDataPanel = new OracleDBDataPanel();
        final JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)oracleDBDataPanel, (String)Messages.getString("LoadTablesFromOracle.oracleDBInfo"), null);
        jEWTDialog.setButtonMask(2);
        JButton jButton = new JButton(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.OKButton")));
        jButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.OKButton")));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string3 = oracleDBDataPanel.isSIDSelected() ? Analyzer.ORACLE_URL_PREFIX + Analyzer.TNS_ENTRY_SID.replace("#HOST#", oracleDBDataPanel.getHost()).replace("#PORT#", oracleDBDataPanel.getPort()).replace("#SID#", oracleDBDataPanel.getService()) : Analyzer.ORACLE_URL_PREFIX + Analyzer.TNS_ENTRY_SERVICE_NAME.replace("#HOST#", oracleDBDataPanel.getHost()).replace("#PORT#", oracleDBDataPanel.getPort()).replace("#SERVICE_NAME#", oracleDBDataPanel.getService());
                    Analyzer.this.oracleConn = DriverManager.getConnection(string3, string, string2);
                    Analyzer.this.oCallableStatement = (OracleCallableStatement)Analyzer.this.oracleConn.prepareCall(Analyzer.this.getAnonymousBlock());
                }
                catch (Exception exception) {
                    MessageDialog.error(null, (Object)exception.getMessage(), (String)Messages.getString("TimesTen.common.error"), null);
                    return;
                }
                jEWTDialog.dispose();
            }
        });
        jEWTDialog.addCustomButton((Component)jButton);
        jEWTDialog.setPreferredSize(new Dimension(300, 250));
        jEWTDialog.runDialog();
        return !jEWTDialog.isCancelled();
    }

    private String getAnonymousBlock() throws Exception {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        InputStream inputStream = this.getClass().getResourceAsStream(PLSQL_FILE);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public void freeResources() {
        try {
            if (this.oCallableStatement != null) {
                this.oCallableStatement.close();
            }
            if (this.oracleConn != null) {
                this.oracleConn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private String getParamString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OnBadType");
        stringBuilder.append("=");
        stringBuilder.append(String.valueOf(this.parameters.getOnBadType()));
        stringBuilder.append(",");
        stringBuilder.append("NumMapping");
        stringBuilder.append("=");
        stringBuilder.append(String.valueOf(this.parameters.getNumberMapping()));
        stringBuilder.append(",");
        stringBuilder.append("VarMapping");
        stringBuilder.append("=");
        stringBuilder.append(String.valueOf(this.parameters.getVarchar2Mapping()));
        stringBuilder.append(",");
        stringBuilder.append("RawMapping");
        stringBuilder.append("=");
        stringBuilder.append(String.valueOf(this.parameters.getRawMapping()));
        stringBuilder.append(",");
        stringBuilder.append("LOBMapping");
        stringBuilder.append("=");
        stringBuilder.append(String.valueOf(this.parameters.getLOBMapping()));
        stringBuilder.append(",");
        stringBuilder.append("TSTZMapping");
        stringBuilder.append("=");
        stringBuilder.append(String.valueOf(this.parameters.getTimestampMapping()));
        stringBuilder.append(",");
        stringBuilder.append("TMPadding");
        stringBuilder.append("=");
        stringBuilder.append(String.valueOf(this.parameters.getTypeMappingPadding()));
        stringBuilder.append(",");
        stringBuilder.append("Compression");
        stringBuilder.append("=");
        stringBuilder.append(String.valueOf(this.parameters.getCompression()));
        stringBuilder.append(",");
        stringBuilder.append("CPadding");
        stringBuilder.append("=");
        stringBuilder.append(String.valueOf(this.parameters.getCompressionPadding()));
        stringBuilder.append(",");
        stringBuilder.append("CFactor");
        stringBuilder.append("=");
        stringBuilder.append(String.valueOf(this.parameters.getCompressionFactor()));
        stringBuilder.append(",");
        stringBuilder.append("CMinRows");
        stringBuilder.append("=");
        stringBuilder.append(String.valueOf(this.parameters.getCompressionMinimumRows()));
        stringBuilder.append(",");
        stringBuilder.append("InlineLimit");
        stringBuilder.append("=");
        stringBuilder.append(String.valueOf(this.parameters.getInlineLimit()));
        return stringBuilder.toString();
    }

    private void analyzeTable(LoadTableRow loadTableRow) {
        if (this.oCallableStatement != null) {
            try {
                this.oCallableStatement.setString(1, loadTableRow.getOracleUser());
                this.oCallableStatement.setString(2, Common.getOracleTableFromQuery(loadTableRow.getSelectQuery()));
                this.oCallableStatement.setString(3, this.getParamString());
                this.oCallableStatement.registerOutParameter(4, 4);
                this.oCallableStatement.registerOutParameter(5, 12);
                this.oCallableStatement.registerOutParameter(6, 12);
                this.oCallableStatement.registerOutParameter(7, 4);
                this.oCallableStatement.registerIndexTableOutParameter(8, 1000, 12, 512);
                this.oCallableStatement.registerOutParameter(9, 4);
                this.oCallableStatement.registerIndexTableOutParameter(10, 1000, 12, 512);
                this.oCallableStatement.execute();
                int n = this.oCallableStatement.getInt(4);
                String string = this.oCallableStatement.getString(5);
                String string2 = this.oCallableStatement.getString(6);
                int n2 = this.oCallableStatement.getInt(7);
                String[] stringArray = null;
                if (n2 > 0) {
                    stringArray = (String[])this.oCallableStatement.getPlsqlIndexTable(8);
                }
                int n3 = this.oCallableStatement.getInt(9);
                String[] stringArray2 = null;
                if (n3 > 0) {
                    stringArray2 = (String[])this.oCallableStatement.getPlsqlIndexTable(10);
                }
                loadTableRow.setAnalysisData(new AnalysisData(n, string, string2, n2, stringArray, n3, stringArray2));
                loadTableRow.setAnalysisDDL(this.parameters);
                this.saveAnalysisResults(loadTableRow);
            }
            catch (SQLException sQLException) {
                loadTableRow.setAnalysisLog(sQLException.getMessage());
            }
        }
    }

    private void saveAnalysisParameters() {
        try {
            FileWriter fileWriter = new FileWriter(this.analysisLogFile, true);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            PrintWriter printWriter = new PrintWriter(bufferedWriter);
            printWriter.println(this.getFileHeader('#'));
            printWriter.print("OnBadType");
            printWriter.print("=");
            printWriter.println(String.valueOf(this.parameters.getOnBadType()));
            printWriter.print("NumMapping");
            printWriter.print("=");
            printWriter.println(String.valueOf(this.parameters.getNumberMapping()));
            printWriter.print("VarMapping");
            printWriter.print("=");
            printWriter.println(String.valueOf(this.parameters.getVarchar2Mapping()));
            printWriter.print("RawMapping");
            printWriter.print("=");
            printWriter.println(String.valueOf(this.parameters.getRawMapping()));
            printWriter.print("LOBMapping");
            printWriter.print("=");
            printWriter.println(String.valueOf(this.parameters.getLOBMapping()));
            printWriter.print("TSTZMapping");
            printWriter.print("=");
            printWriter.println(String.valueOf(this.parameters.getTimestampMapping()));
            printWriter.print("TMPadding");
            printWriter.print("=");
            printWriter.println(String.valueOf(this.parameters.getTypeMappingPadding()));
            printWriter.print("Compression");
            printWriter.print("=");
            printWriter.println(String.valueOf(this.parameters.getCompression()));
            printWriter.print("CPadding");
            printWriter.print("=");
            printWriter.println(String.valueOf(this.parameters.getCompressionPadding()));
            printWriter.print("CFactor");
            printWriter.print("=");
            printWriter.println(String.valueOf(this.parameters.getCompressionFactor()));
            printWriter.print("CMinRows");
            printWriter.print("=");
            printWriter.println(String.valueOf(this.parameters.getCompressionMinimumRows()));
            printWriter.print("InlineLimit");
            printWriter.print("=");
            printWriter.println(String.valueOf(this.parameters.getInlineLimit()));
            printWriter.println();
            printWriter.close();
        }
        catch (Exception exception) {
            _logger.warning(MessageFormat.format(Messages.getString("LoadTablesFromOracle.saveFileError"), this.analysisLogFile) + "\n" + exception.getMessage());
        }
    }

    private String getFileHeader(char c) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        for (n = 0; n < 80; ++n) {
            stringBuilder.append(c);
        }
        stringBuilder.append("\n");
        stringBuilder.append(c);
        stringBuilder.append(c);
        stringBuilder.append(" Generated by SQL Developer ");
        stringBuilder.append(String.valueOf(Ide.getVersion()));
        stringBuilder.append(" - ");
        stringBuilder.append(simpleDateFormat.format(calendar.getTime()));
        stringBuilder.append("\n");
        for (n = 0; n < 80; ++n) {
            stringBuilder.append(c);
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private void saveAnalysisResults(LoadTableRow loadTableRow) {
        try {
            FileWriter fileWriter = new FileWriter(this.analysisLogFile, true);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            PrintWriter printWriter = new PrintWriter(bufferedWriter);
            printWriter.println();
            if (loadTableRow.getAnalysisData() != null) {
                printWriter.println("#### " + loadTableRow.getOracleUser() + "." + Common.getOracleTableFromQuery(loadTableRow.getSelectQuery()) + " ####");
                printWriter.println(loadTableRow.getAnalysisData().getTableInfo().toString());
                printWriter.println();
                printWriter.println(loadTableRow.getAnalysisData().getColumnDataStr());
                printWriter.println();
            }
            printWriter.close();
        }
        catch (Exception exception) {
            _logger.warning(MessageFormat.format(Messages.getString("LoadTablesFromOracle.saveFileError"), this.analysisLogFile) + "\n" + exception.getMessage());
        }
    }

    static class OracleDBDataPanel
    extends JPanel
    implements ItemListener {
        private static final long serialVersionUID = 1L;
        private JLabel _hostLabel;
        private JLabel _portLabel;
        private JRadioButton _sidRadioButton;
        private JRadioButton _serviceNameRadioButton;
        private ButtonGroup _group1;
        private JTextField _hostTxtField;
        private JTextField _portTxtField;
        private JTextField _sidTxtField;
        private JTextField _serviceNameTxtField;

        public OracleDBDataPanel() {
            this.init();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(Messages.getString("LoadTablesFromOracle.oracleDBInfo")));
            this._hostTxtField = new JTextField();
            this._portTxtField = new JTextField();
            this._sidTxtField = new JTextField();
            this._serviceNameTxtField = new JTextField();
            this._hostLabel = new JLabel(Messages.getString("LoadTablesFromOracle.hostnameLabel"));
            this._hostLabel.setLabelFor(this._hostTxtField);
            this._portLabel = new JLabel(Messages.getString("LoadTablesFromOracle.portLabel"));
            this._portLabel.setLabelFor(this._portTxtField);
            this._sidRadioButton = new JRadioButton("SID:");
            this._sidRadioButton.addItemListener(this);
            this._serviceNameRadioButton = new JRadioButton(Messages.getString("LoadTablesFromOracle.serviceNameLabel"));
            this._serviceNameRadioButton.addItemListener(this);
            this._sidRadioButton.setSelected(true);
            this._group1 = new ButtonGroup();
            this._group1.add(this._sidRadioButton);
            this._group1.add(this._serviceNameRadioButton);
            this.add((Component)this._hostLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._hostTxtField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._portLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._portTxtField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._sidRadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._sidTxtField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._serviceNameRadioButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._serviceNameTxtField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        }

        public String getHost() {
            return this._hostTxtField.getText().trim();
        }

        public String getPort() {
            return this._portTxtField.getText().trim();
        }

        public boolean isSIDSelected() {
            return this._sidRadioButton.isSelected();
        }

        public String getService() {
            return this._sidRadioButton.isSelected() ? this._sidTxtField.getText().trim() : this._serviceNameTxtField.getText().trim();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == this._sidRadioButton) {
                this._serviceNameTxtField.setEnabled(!this._sidRadioButton.isSelected());
                if (this._sidRadioButton.isSelected()) {
                    this._serviceNameTxtField.setText("");
                }
            } else if (itemEvent.getSource() == this._serviceNameRadioButton) {
                this._sidTxtField.setEnabled(!this._serviceNameRadioButton.isSelected());
                if (this._serviceNameRadioButton.isSelected()) {
                    this._sidTxtField.setText("");
                }
            }
        }
    }
}

