/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.countrows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.dialogs.table.computesize.ComputeTableSize;
import oracle.dbtools.raptor.timesten.dialogs.table.countrows.CountTableRowsGraph;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;

public class CountTableRowsReportPanel
extends JPanel
implements ActionListener {
    private static Logger _logger = Logger.getLogger(ComputeTableSize.class.getPackage().getName());
    private LinkedHashMap<String, Long[]> linkedMap;
    private String[] keys;
    private JTable table;
    private TableRowCountModel model;
    private DBObject dbObject;
    private JLabel totalLabel;
    private JLabel totalNumber;
    private String query;
    private long count;
    private final String HISTOGRAM = Messages.getString("CountTableRows.histogram");
    private final String PIE = Messages.getString("CountTableRows.pie");
    private final String RING = Messages.getString("CountTableRows.ring");
    private CountTableRowsGraph graph;
    private JScrollPane tableScrollPane;
    private JSplitPane splitPane;
    private JComboBox<String> graphFormat;
    private boolean isGrid;

    public CountTableRowsReportPanel(DBObject dBObject, String string, boolean bl) {
        this.query = string;
        this.dbObject = dBObject;
        this.isGrid = bl;
        if (bl) {
            this.buildGridCountPanel();
        } else {
            this.buildRegularCountPanel();
        }
    }

    private void buildRegularCountPanel() {
        this.setLayout(new BorderLayout());
        this.totalLabel = new JLabel(Messages.getString("CountTableRows.totalRows"));
        this.totalNumber = new JLabel(Long.toString(this.count));
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.totalLabel);
        jPanel.add(this.totalNumber);
        this.add((Component)jPanel, "Center");
        this.performRegularRowCount();
    }

    private void buildGridCountPanel() {
        this.setLayout(new BorderLayout());
        this.linkedMap = new LinkedHashMap();
        this.model = new TableRowCountModel();
        this.table = new JTable(this.model);
        this.totalLabel = new JLabel(Messages.getString("CountTableRows.totalRows"));
        this.totalNumber = new JLabel(Long.toString(this.count));
        this.graphFormat = new JComboBox<String>(new String[]{this.HISTOGRAM, this.PIE, this.RING});
        this.graph = new CountTableRowsGraph();
        this.graphFormat.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.graphFormat);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(this.totalLabel);
        jPanel2.add(this.totalNumber);
        this.tableScrollPane = new JScrollPane(this.table);
        this.add((Component)jPanel, "North");
        this.splitPane = new JSplitPane(0, (Component)((Object)this.graph), this.tableScrollPane);
        this.splitPane.setDividerLocation(200);
        this.splitPane.setOneTouchExpandable(true);
        this.add((Component)this.splitPane, "Center");
        this.add((Component)jPanel2, "South");
        this.performGridRowCount();
    }

    private void performRegularRowCount() {
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void doInBackground() throws Exception {
                Connection connection = CountTableRowsReportPanel.this.dbObject.getConnection();
                CountTableRowsReportPanel.this.count = 0L;
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement(CountTableRowsReportPanel.this.query);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        long l = resultSet.getLong(1);
                        CountTableRowsReportPanel.this.count = CountTableRowsReportPanel.this.count + l;
                    }
                    for (Long[] longArray : CountTableRowsReportPanel.this.linkedMap.values()) {
                        longArray[1] = longArray[0] * 100L / CountTableRowsReportPanel.this.count;
                    }
                }
                catch (SQLException sQLException) {
                    _logger.log(Level.SEVERE, "Couldn't get table info", sQLException);
                    MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(connection, preparedStatement.toString(), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
                }
                finally {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (SQLException sQLException) {
                            _logger.log(Level.SEVERE, "Couldn't close statement", sQLException);
                        }
                    }
                }
                return null;
            }

            @Override
            protected void done() {
            }
        };
        swingWorker.execute();
    }

    private void performGridRowCount() {
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void doInBackground() throws Exception {
                Connection connection = CountTableRowsReportPanel.this.dbObject.getConnection();
                CountTableRowsReportPanel.this.count = 0L;
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement(CountTableRowsReportPanel.this.query);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        long l = resultSet.getLong(1);
                        long l2 = resultSet.getLong(2);
                        CountTableRowsReportPanel.this.count = CountTableRowsReportPanel.this.count + l2;
                        CountTableRowsReportPanel.this.linkedMap.put(Long.toString(l), new Long[]{l2, null});
                    }
                    for (Long[] longArray : CountTableRowsReportPanel.this.linkedMap.values()) {
                        longArray[1] = longArray[0] * 100L / CountTableRowsReportPanel.this.count;
                    }
                }
                catch (SQLException sQLException) {
                    _logger.log(Level.SEVERE, "Couldn't get table info", sQLException);
                    MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(connection, preparedStatement.toString(), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
                }
                finally {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (SQLException sQLException) {
                            _logger.log(Level.SEVERE, "Couldn't close statement", sQLException);
                        }
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                CountTableRowsReportPanel.access$602(CountTableRowsReportPanel.this, CountTableRowsReportPanel.this.linkedMap.keySet().toArray(new String[0]));
                CountTableRowsReportPanel.this.graph.setData(CountTableRowsReportPanel.this.linkedMap, CountTableRowsReportPanel.this.keys);
                CountTableRowsReportPanel.this.totalNumber.setText(Long.toString(CountTableRowsReportPanel.this.count));
                CountTableRowsReportPanel.this.model.fireTableDataChanged();
            }
        };
        swingWorker.execute();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.graphFormat.getSelectedItem();
        if (string.equals(this.HISTOGRAM)) {
            this.graph.changeGraphFormatBars();
        } else if (string.equals(this.PIE)) {
            this.graph.changeGraphFormatPie();
        } else if (string.equals(this.RING)) {
            this.graph.changeGraphFormatRing();
        }
    }

    static /* synthetic */ String[] access$602(CountTableRowsReportPanel countTableRowsReportPanel, String[] stringArray) {
        countTableRowsReportPanel.keys = stringArray;
        return stringArray;
    }

    private class TableRowCountModel
    extends AbstractTableModel {
        String PARTITION = Messages.getString("CountTableRows.elemenId");
        String ROW_COUNT = Messages.getString("CountTableRows.rowCount");
        String DISTRIBUTION = Messages.getString("CountTableRows.distribution");

        private TableRowCountModel() {
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return this.PARTITION;
                }
                case 1: {
                    return this.ROW_COUNT;
                }
                case 2: {
                    return this.DISTRIBUTION;
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            if (CountTableRowsReportPanel.this.linkedMap != null) {
                return CountTableRowsReportPanel.this.linkedMap.size();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (CountTableRowsReportPanel.this.linkedMap != null && CountTableRowsReportPanel.this.keys != null) {
                switch (n2) {
                    case 0: {
                        return CountTableRowsReportPanel.this.keys[n];
                    }
                    case 1: {
                        return ((Long[])CountTableRowsReportPanel.this.linkedMap.get(CountTableRowsReportPanel.this.keys[n]))[0];
                    }
                    case 2: {
                        return ((Long[])CountTableRowsReportPanel.this.linkedMap.get(CountTableRowsReportPanel.this.keys[n]))[1];
                    }
                }
            }
            return null;
        }
    }
}

