/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.countrows;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.table.countrows.CountTableRowsSQLPanel;
import oracle.dbtools.raptor.utils.DBObject;

public class CountTableRowsPanel
extends JPanel {
    private JLabel _owner;
    private JLabel _table;
    private JTextField _ownerField;
    private JTextField _tableField;
    private static final String SELECT_ROW_COUNT_GRID = "SELECT  ELEMENTID# , count(*)  from #owner#.#table# GROUP BY ELEMENTID# ORDER BY  ELEMENTID#;";
    private static final String SELECT_ROW_COUNT = "SELECT count(*)  from #owner#.#table#;";
    private boolean _isGrid;
    private CountTableRowsSQLPanel _sqlPanel;
    private DBObject _dbObject;

    public CountTableRowsPanel(DBObject dBObject, CountTableRowsSQLPanel countTableRowsSQLPanel, boolean bl) {
        this._dbObject = dBObject;
        this._sqlPanel = countTableRowsSQLPanel;
        this._isGrid = bl;
        this._owner = new JLabel(Messages.getString("TimesTen.common.owner"));
        this._table = new JLabel(Messages.getString("TimesTen.common.name"));
        this._ownerField = new JTextField(dBObject.getSchemaName(), 30);
        this._tableField = new JTextField(dBObject.getObjectName(), 30);
        this._ownerField.setEditable(false);
        this._tableField.setEditable(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)this._owner, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._ownerField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._table, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._tableField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this._sqlPanel.setSQLText(this.getSql());
    }

    private String getSql() {
        return this.getSQLHelper().replace("#owner#", this._dbObject.getSchemaName()).replace("#table#", this._dbObject.getObjectName());
    }

    private String getSQLHelper() {
        if (this._isGrid) {
            return SELECT_ROW_COUNT_GRID;
        }
        return SELECT_ROW_COUNT;
    }
}

