/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.computesize;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.dialogs.table.computesize.ComputeTableSize;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;

public class ComputeSizeReportPanel
extends JPanel {
    private static Logger _logger = Logger.getLogger(ComputeTableSize.class.getPackage().getName());
    private HashMap<String, String> textMap;
    private LinkedHashMap<String, Object> values;
    private final String GET_SIZE_INFO = "select * from all_tab_sizes where owner = ? and table_name =?";
    private Object[] keys;
    private JTable tableSizeTable;
    private TableSizeTableModel tableModel;
    private DBObject dbObject;

    public ComputeSizeReportPanel(DBObject dBObject) {
        this.fillTextMap();
        this.dbObject = dBObject;
        this.values = new LinkedHashMap();
        this.tableModel = new TableSizeTableModel();
        this.tableSizeTable = new JTable(this.tableModel);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.tableSizeTable);
        jScrollPane.setPreferredSize(new Dimension(400, 150));
        this.add((Component)jScrollPane, "Center");
        this.getSizeInfo();
    }

    private void getSizeInfo() {
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void doInBackground() throws Exception {
                Connection connection = ComputeSizeReportPanel.this.dbObject.getConnection();
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement("select * from all_tab_sizes where owner = ? and table_name =?");
                    preparedStatement.setString(1, ComputeSizeReportPanel.this.dbObject.getSchemaName());
                    preparedStatement.setString(2, ComputeSizeReportPanel.this.dbObject.getObjectName());
                    ResultSet resultSet = preparedStatement.executeQuery();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n = resultSet.getMetaData().getColumnCount();
                    for (int i = 1; i <= n; ++i) {
                        String string = resultSetMetaData.getColumnName(i);
                        if (string.equals("TABLE_NAME") || string.equals("OWNER")) continue;
                        ComputeSizeReportPanel.this.values.put(resultSetMetaData.getColumnName(i), null);
                    }
                    ComputeSizeReportPanel.access$202(ComputeSizeReportPanel.this, ComputeSizeReportPanel.this.values.keySet().toArray());
                    while (resultSet.next()) {
                        for (String string : ComputeSizeReportPanel.this.values.keySet()) {
                            Object object = resultSet.getObject(string);
                            ComputeSizeReportPanel.this.values.put(string, object);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    _logger.log(Level.SEVERE, "Couldn't get table info", sQLException);
                    MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(connection, preparedStatement.toString(), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
                }
                finally {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (SQLException sQLException) {
                            _logger.log(Level.SEVERE, "Couldn't close statement", sQLException);
                        }
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                ComputeSizeReportPanel.this.tableModel.fireTableDataChanged();
            }
        };
        swingWorker.execute();
    }

    private void fillTextMap() {
        this.textMap = new HashMap();
        this.textMap.put("INLINE_ALLOC_BYTES", Messages.getString("ComputeTableSize.inlineAllocBytes"));
        this.textMap.put("NUM_USED_ROWS", Messages.getString("ComputeTableSize.numberOfUsedRows"));
        this.textMap.put("NUM_FREE_ROWS", Messages.getString("ComputeTableSize.numberOfFreeRows"));
        this.textMap.put("AVG_ROW_LEN", Messages.getString("ComputeTableSize.averageOfRowLenght"));
        this.textMap.put("OUT_OF_LINE_BYTES", Messages.getString("ComputeTableSize.outOfLineBytes"));
        this.textMap.put("METADATA_BYTES", Messages.getString("ComputeTableSize.metadataBytes"));
        this.textMap.put("TOTAL_BYTES", Messages.getString("ComputeTableSize.totalOfBytes"));
        this.textMap.put("LAST_UPDATED", Messages.getString("ComputeTableSize.lastUpdated"));
    }

    static /* synthetic */ Object[] access$202(ComputeSizeReportPanel computeSizeReportPanel, Object[] objectArray) {
        computeSizeReportPanel.keys = objectArray;
        return objectArray;
    }

    public class TableSizeTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return ComputeSizeReportPanel.this.values.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                if (ComputeSizeReportPanel.this.textMap.containsKey(ComputeSizeReportPanel.this.keys[n])) {
                    return ComputeSizeReportPanel.this.textMap.get(ComputeSizeReportPanel.this.keys[n]);
                }
                return ComputeSizeReportPanel.this.keys[n];
            }
            return ComputeSizeReportPanel.this.values.get(ComputeSizeReportPanel.this.keys[n]);
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("IndexAdvisor.property");
            }
            return Messages.getString("IndexAdvisor.value");
        }
    }
}

