/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.OracleTypeModeImpl;
import oracle.dbtools.raptor.timesten.dialogs.TTJPanel;
import oracle.dbtools.raptor.timesten.dialogs.sql.ISqlPromptPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.SimpleCreateTablePanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.dialogs.MessageDialog;

public final class AlterTablePanel
extends TTJPanel
implements ISqlPromptPanel {
    private Map<String, Object> _dict;
    private List<JComponent> _textValues = new ArrayList<JComponent>();
    private DataType[] _supportedDataTypes;
    private JTextField _columnNameField;
    private JComboBox _dataTypeComboBox;
    private JCheckBox _inlinecb;
    private JTextField _inlinetxt;
    private JTextField _precisionField;
    private JTextField _scaleField;
    private JComboBox _unitComboBox;
    private JTextField _dataTypeAttributeField;
    private String _conn;
    private int row = 0;
    private Database _database;
    private DBObject _dbObject;
    private static Table _table = new Table();
    private DataType _currentDataType;
    private String _currentAlterSql;
    private static final String[] alterSql = new String[]{"alter table \"#OBJECT_OWNER#\".\"#OBJECT_NAME#\"\n  add(#0# #1#) #5#", "alter table \"#OBJECT_OWNER#\".\"#OBJECT_NAME#\"\n  add(#0# #1#(#2#) )", "alter table \"#OBJECT_OWNER#\".\"#OBJECT_NAME#\"\n  add(#0# #1#(#2#,#3#) )", "alter table \"#OBJECT_OWNER#\".\"#OBJECT_NAME#\"\n  add(#0# #1#(#2# #4#) #5#)"};
    private ActionListener _checkboxListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            boolean bl = jCheckBox.isSelected();
            AlterTablePanel.this._inlinetxt.setText(bl ? " inline" : "");
        }
    };
    private ItemListener _comboListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                AlterTablePanel.this._currentDataType = (DataType)AlterTablePanel.this._dataTypeComboBox.getSelectedItem();
                String string = AlterTablePanel.this._currentDataType.toString();
                boolean bl = string.matches(".*VARCHAR.*") || string.matches(".*VARBINARY.*");
                AlterTablePanel.this._inlinecb.setEnabled(bl);
                if (!bl) {
                    AlterTablePanel.this._inlinecb.setSelected(false);
                }
                AlterTablePanel.this._inlinetxt.setText(bl && AlterTablePanel.this._inlinecb.isSelected() ? " inline" : "");
                if (AlterTablePanel.this._currentDataType.hasDataTypeAttribute("precision") || AlterTablePanel.this._currentDataType.hasDataTypeAttribute("size")) {
                    AlterTablePanel.this._precisionField.setEnabled(true);
                    AlterTablePanel.this._precisionField.setEditable(true);
                } else {
                    AlterTablePanel.this._precisionField.setText("");
                    AlterTablePanel.this._precisionField.setEditable(false);
                    AlterTablePanel.this._precisionField.setEnabled(false);
                    AlterTablePanel.this._precisionField.setEditable(false);
                }
                if (AlterTablePanel.this._currentDataType.hasDataTypeAttribute("scale")) {
                    AlterTablePanel.this._scaleField.setEnabled(true);
                    AlterTablePanel.this._scaleField.setEditable(true);
                } else {
                    AlterTablePanel.this._scaleField.setText("");
                    AlterTablePanel.this._scaleField.setEditable(false);
                    AlterTablePanel.this._scaleField.setEnabled(false);
                    AlterTablePanel.this._scaleField.setEditable(false);
                }
                if (AlterTablePanel.this._currentDataType.hasDataTypeAttribute("unit")) {
                    AlterTablePanel.this._unitComboBox.setEnabled(true);
                } else {
                    AlterTablePanel.this._unitComboBox.setEnabled(false);
                }
            }
        }
    };

    public AlterTablePanel(DBObject dBObject, String string) {
        this._dbObject = dBObject;
        this._dict = dBObject.getDictionary();
        this._conn = dBObject.getConnectionName();
        this._database = dBObject.getDatabase();
        this.sortDataTypes();
        this.initGUI();
    }

    private void sortDataTypes() {
        this._supportedDataTypes = this._database.listSupportedDataTypes();
        ArrayList<DataType> arrayList = new ArrayList<DataType>(this._supportedDataTypes.length);
        for (DataType dataType : this._supportedDataTypes) {
            arrayList.add(dataType);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                DataType dataType = (DataType)object;
                DataType dataType2 = (DataType)object2;
                return dataType.getName().compareTo(dataType2.getName());
            }

            @Override
            public boolean equals(Object object) {
                return super.equals(object);
            }
        });
        this._supportedDataTypes = arrayList.toArray(this._supportedDataTypes);
    }

    private void initGUI() {
        String[] stringArray;
        this.setLayout(new GridBagLayout());
        String string = null;
        if (this._dict.get("OBJECT_OWNER") != null && this._dict.get("OBJECT_NAME") != null) {
            stringArray = this._dict.get("OBJECT_OWNER").toString();
            String string2 = this._dict.get("OBJECT_NAME").toString();
            this.addRow(new JLabel(Messages.getString("TimesTen.common.owner")), (Component)new JLabel((String)stringArray));
            this.addRow(new JLabel(Messages.getString("TimesTen.common.name")), (Component)new JLabel(string2));
            SchemaObject schemaObject = this._dbObject.getSchemaObject();
            if (schemaObject instanceof Table) {
                Table table = (Table)schemaObject;
                DefaultListModel<Column> defaultListModel = new DefaultListModel<Column>();
                for (Column column : table.getColumns()) {
                    defaultListModel.addElement(column);
                }
                string = SimpleCreateTablePanel.getUniqueNameEnh("COLUMN", defaultListModel);
            }
        }
        this._columnNameField = new JTextField(25);
        this.addRow(new JLabel(Messages.getString("TimesTen.common.columnName")), (Component)this._columnNameField);
        if (string != null) {
            this._columnNameField.setText(string);
        }
        this._textValues.add(this._columnNameField);
        stringArray = new String[this._supportedDataTypes.length];
        int n = 0;
        for (Column[] columnArray : this._supportedDataTypes) {
            stringArray[n++] = columnArray.getName();
        }
        this._dataTypeComboBox = new JComboBox<DataType>(this._supportedDataTypes);
        this.addRow(new JLabel(Messages.getString("AlterTablePanel.dataType")), (Component)this._dataTypeComboBox);
        this._textValues.add(this._dataTypeComboBox);
        this._dataTypeComboBox.addItemListener(this._comboListener);
        this._inlinecb = new JCheckBox();
        this.addRow(new JLabel(Messages.getString("TimesTen.common.inline")), (Component)this._inlinecb);
        this._inlinecb.addActionListener(this._checkboxListener);
        this._inlinetxt = new JTextField();
        this._precisionField = new JTextField(25);
        this.addRow(new JLabel(Messages.getString("AlterTablePanel.precisionSize")), (Component)this._precisionField);
        this._textValues.add(this._precisionField);
        this._scaleField = new JTextField(25);
        this.addRow(new JLabel(Messages.getString("AlterTablePanel.scale")), (Component)this._scaleField);
        this._textValues.add(this._scaleField);
        this._unitComboBox = new JComboBox<String>(new String[]{"", "BYTE", "CHAR"});
        this._unitComboBox.setSelectedIndex(0);
        this.addRow(new JLabel(Messages.getString("AlterTablePanel.unit")), (Component)this._unitComboBox);
        this._textValues.add(this._unitComboBox);
        this._dataTypeAttributeField = new JTextField(25);
        this._textValues.add(this._inlinetxt);
        this.evalDefaults();
        this.add(Box.createGlue(), new GridBagConstraints(0, this.row, 1, 1, 0.0, 10.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.setSize(this.getPreferredSize());
        this.setBackground(UIManager.getColor("EWTDialog.background"));
    }

    private void evalDefaults() {
        if (this._database instanceof OracleTypeModeImpl) {
            this._dataTypeComboBox.setSelectedItem(this._database.getDataType("VARCHAR2"));
            this._dataTypeAttributeField.setText("4000");
        } else {
            this._dataTypeComboBox.setSelectedItem(this._database.getDataType("CHAR"));
            this._dataTypeAttributeField.setText("32");
        }
    }

    @Override
    public void addRow(Component component, Component component2) {
        this.add(component, new GridBagConstraints(0, this.row, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(component2, new GridBagConstraints(1, this.row, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0));
        ++this.row;
    }

    @Override
    public String getSql() {
        if (this._currentDataType.hasDataTypeAttribute("unit")) {
            if (this._precisionField.getText().trim().length() > 0) {
                return alterSql[3];
            }
            return alterSql[0];
        }
        if (this._precisionField.getText().trim().length() > 0) {
            if (this._scaleField.getText().trim().length() > 0) {
                return alterSql[2];
            }
            return alterSql[1];
        }
        return alterSql[0];
    }

    @Override
    public boolean validateValues() {
        String string;
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this._columnNameField.getText().trim().equals("")) {
            stringBuffer.append(Messages.getString("AlterTablePanel.columnNameCannotBeEmpty"));
        }
        DataType dataType = (DataType)this._dataTypeComboBox.getSelectedItem();
        DataTypeUsage dataTypeUsage = dataType.createDefaultUsage();
        DataTypeAttribute dataTypeAttribute = dataType.getDataTypeAttribute("size");
        if (dataTypeAttribute != null) {
            string = this._precisionField.getText().trim();
            if (string.length() == 0) {
                if (dataTypeAttribute.isMandatory()) {
                    stringBuffer.append(Messages.getString("AlterTablePanel.sizeCannotBeEmpty"));
                }
            } else {
                dataTypeUsage.putAttributeValue("size", (Object)DataTypeHelper.toLong((Object)string));
            }
        }
        if ((dataTypeAttribute = dataType.getDataTypeAttribute("precision")) != null) {
            string = this._precisionField.getText().trim();
            if (string.length() == 0) {
                if (dataTypeAttribute.isMandatory()) {
                    stringBuffer.append(Messages.getString("AlterTablePanel.precisionCannotBeEmpty"));
                }
            } else {
                dataTypeUsage.putAttributeValue("precision", (Object)DataTypeHelper.toLong((Object)string));
            }
        }
        if (dataType.hasDataTypeAttribute("scale") && (string = this._scaleField.getText().trim()).length() > 0) {
            dataTypeUsage.putAttributeValue("scale", (Object)DataTypeHelper.toLong((Object)string));
        }
        if (dataType.hasDataTypeAttribute("unit") && this._unitComboBox.getSelectedIndex() > 0) {
            dataTypeUsage.putAttributeValue("unit", (Object)this._unitComboBox.getSelectedItem().toString());
        }
        try {
            dataType.validateUsage(dataTypeUsage, (oracle.javatools.db.DBObject)_table);
        }
        catch (DataTypeValidationException dataTypeValidationException) {
            stringBuffer.append(MessageFormat.format(Messages.getString("AlterTablePanel.dataTypeDef"), dataTypeValidationException.toString()));
        }
        if (stringBuffer.length() > 0) {
            MessageDialog.error((Component)this, (Object)stringBuffer.toString(), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> getDictionary() {
        return this._dict;
    }

    @Override
    public List<JComponent> getTextValues() {
        return this._textValues;
    }

    @Override
    public List<String> getValues() {
        String string;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this._columnNameField.getText();
        if (string2 != null) {
            arrayList.add(string2);
        }
        if ((object = this._dataTypeComboBox.getSelectedItem()) != null) {
            arrayList.add(object.toString());
        }
        if ((string = this._dataTypeAttributeField.getText()) != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public DBObject getDbObject() {
        return this._dbObject;
    }
}

