/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.plsql;

import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class CompileInvalid
extends DialogBase {
    private int theRow;
    private JCheckBox theInvCmdCheckBox;
    private boolean theInvCmdFlag;
    DBObject _dbobject;
    private String sqlText;
    private static Logger _logger = Logger.getLogger(CompileInvalid.class.getPackage().getName());

    public CompileInvalid(DBObject dBObject) {
        super(dBObject, null, "CompileInvalidPanel");
        this._dbobject = dBObject;
    }

    @Override
    protected void initGUI() {
        this.setLayout(this.gridbag);
        this.addRow(Messages.getString("plsql.package.invalid"));
        this._textValues.add(new JTextField());
        this.setSize(this.getPreferredSize());
        this.setBackground(UIManager.getColor("EWTDialog.background"));
        this.getSQLText();
    }

    @Override
    public List<String> getValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(new String(" "));
        return arrayList;
    }

    @Override
    public String getSql() {
        if (this.sqlText == null) {
            return "";
        }
        return this.sqlText;
    }

    private void getSQLText() {
        final IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor((Component)this, Messages.getString("TimesTen.common.pleaseWait"));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void doInBackground() throws Exception {
                indeterminateProgressMonitor.display();
                String string = "PACKAGE', 'PACKAGE BODY";
                if (CompileInvalid.this._dbObject.getObjectType().startsWith("PROCEDURE")) {
                    string = "PROCEDURE";
                } else if (CompileInvalid.this._dbObject.getObjectType().startsWith("FUNCTION")) {
                    string = "FUNCTION";
                }
                String string2 = CompileInvalid.this._dbObject.getSchemaName();
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append("SELECT OBJECT_NAME, OBJECT_TYPE, owner FROM all_objects WHERE object_type in");
                stringBuffer.append("('");
                stringBuffer.append(string);
                stringBuffer.append("')and owner = '");
                stringBuffer.append(string2);
                stringBuffer.append("' AND status = 'INVALID'");
                StringBuffer stringBuffer2 = new StringBuffer(256);
                Statement statement = null;
                ResultSet resultSet = null;
                Connection connection = null;
                try {
                    connection = CompileInvalid.this._dbObject.getConnection();
                    Connections.getInstance().lock(connection);
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(stringBuffer.toString());
                    while (resultSet.next()) {
                        String string3 = resultSet.getString("OBJECT_NAME");
                        String string4 = resultSet.getString("OBJECT_TYPE");
                        String string5 = resultSet.getString("owner");
                        if (string4.equalsIgnoreCase("PACKAGE BODY")) {
                            stringBuffer2.append("alter ");
                            stringBuffer2.append("PACKAGE \"");
                            stringBuffer2.append(string5);
                            stringBuffer2.append("\".\"");
                            stringBuffer2.append(string3);
                            stringBuffer2.append("\" compile body;\n");
                            continue;
                        }
                        stringBuffer2.append("alter ");
                        stringBuffer2.append(string4);
                        stringBuffer2.append(" \"");
                        stringBuffer2.append(string5);
                        stringBuffer2.append("\".\"");
                        stringBuffer2.append(string3);
                        stringBuffer2.append("\" compile;\n");
                    }
                }
                catch (SQLException sQLException) {
                    _logger.log(Level.SEVERE, "Can't get sql for compile invalid", sQLException);
                    MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(CompileInvalid.this._conn, stringBuffer.toString(), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
                }
                finally {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception) {}
                    if (connection != null) {
                        Connections.getInstance().unlock(connection);
                    }
                }
                CompileInvalid.this.sqlText = stringBuffer2.toString();
                return null;
            }

            @Override
            protected void done() {
                indeterminateProgressMonitor.close();
            }
        };
        swingWorker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConfirmMessage() {
        String string = "PACKAGE', 'PACKAGE BODY";
        String string2 = "Packages";
        if (this._dbObject.getObjectType().startsWith("PROCEDURE")) {
            string = "PROCEDURE";
            string2 = "Procedures";
        } else if (this._dbObject.getObjectType().startsWith("FUNCTION")) {
            string = "FUNCTION";
            string2 = "Functions";
        }
        String string3 = this._dbObject.getSchemaName();
        StringBuffer stringBuffer = new StringBuffer(256);
        StringBuffer stringBuffer2 = new StringBuffer(256);
        stringBuffer.append("select count(name) objs ,count(1) cnt from all_errors WHERE type in");
        stringBuffer.append("('");
        stringBuffer.append(string);
        stringBuffer.append("') and attribute = 'ERROR' and owner = '");
        stringBuffer.append(string3);
        stringBuffer.append("'");
        stringBuffer2.append("select distinct name objs from all_errors WHERE type in");
        stringBuffer2.append("('");
        stringBuffer2.append(string);
        stringBuffer2.append("') and attribute = 'ERROR' and owner = '");
        stringBuffer2.append(string3);
        stringBuffer2.append("'");
        String string4 = "";
        Statement statement = null;
        ResultSet resultSet = null;
        String string5 = "0";
        String string6 = "0";
        Connection connection = null;
        int n = 0;
        try {
            connection = this._dbobject.getConnection();
            Connections.getInstance().lock(connection);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                string5 = resultSet.getString("cnt");
            }
            resultSet.close();
            statement.close();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer2.toString());
            while (resultSet.next()) {
                String string7 = resultSet.getString("objs");
                ++n;
            }
            string6 = Integer.toString(n);
            string4 = MessageFormat.format(Messages.getString("TimesTen.compileall.message"), string6, string2, string5);
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            _logger.log(Level.SEVERE, "Can't confirm message compile invalid", sQLException);
            MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(this._conn, stringBuffer.toString(), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "Can't close statement", exception);
            }
            if (connection != null) {
                Connections.getInstance().unlock(connection);
            }
        }
        return string4;
    }
}

