/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.dbtools.raptor.timesten.CacheInfo;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.SimpleQuery;
import oracle.dbtools.raptor.timesten.dialogs.TTJPanel;
import oracle.dbtools.raptor.timesten.dialogs.sql.ISqlPromptPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;

public final class CacheAgentPanel
extends TTJPanel
implements ItemListener,
ISqlPromptPanel {
    private JTextField confMsg;
    private JTextField gui_uid;
    private JPasswordField gui_pwd;
    private int _mode;
    private int _sqlIdx;
    private Hashtable<String, String> _model = null;
    private static final int START_STOP = 0;
    private static final int SET_UID = 1;
    private static final String UID = "uid";
    private int _agentStatus = -1;
    private Map<String, Object> _dict = new HashMap<String, Object>();
    private DBObject _dbObject;
    private Database _database;
    private String _conn;
    private List<JComponent> _textValues = new ArrayList<JComponent>();
    private Hashtable<String, String> _hash = null;
    private static final String[] actionSql = new String[]{"", "call ttCacheStart()", "call ttCacheStop()", "call ttCacheUidPwdSet('#1#','#2#')"};

    private void initModel(DBObject dBObject) {
        String[] stringArray;
        this._model = new Hashtable();
        if (this._mode == 0) {
            this._agentStatus = CacheInfo.cacheAgentIsRunning(dBObject);
        }
        if ((stringArray = SimpleQuery.nStringColQuery(dBObject, "call ttCacheUidGet()", 1)) != null) {
            // empty if block
        }
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            this._model.put(UID, stringArray[0]);
        }
    }

    @Override
    public boolean applicable(DBObject dBObject) {
        if (this._mode == 1) {
            boolean bl = false;
            try {
                String string = dBObject.getConnection().getMetaData().getURL().toString();
                bl = string.indexOf(":client:") != -1;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                MessageDialog.error(null, (Object)Messages.getString("TimesTen.common.notAvailableInClient"), (String)Messages.getString("TimesTen.common.error"), null);
                return false;
            }
            boolean bl2 = CacheInfo.okToResetCacheAdminID(dBObject);
        } else if (this._agentStatus == -1) {
            MessageDialog.error(null, (Object)Messages.getString("CGWherePanel.unknownCacheAgentStatus"), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        return true;
    }

    public CacheAgentPanel(DBObject dBObject, String string) {
        this._dbObject = dBObject;
        this._dict = dBObject.getDictionary();
        this._conn = dBObject.getConnectionName();
        this._database = dBObject.getDatabase();
        this._mode = string.startsWith("Start") ? 0 : 1;
        this.initModel(dBObject);
        this._applicable = this.applicable(dBObject);
        if (this._applicable) {
            this.initGUI();
        }
    }

    private void initGUI() {
        this.confMsg = new JTextField();
        this._textValues.add(this.confMsg);
        String string = this._model.get(UID);
        if (this._mode == 0) {
            JCheckBox jCheckBox;
            if (this._agentStatus == 1) {
                this.addRow(Messages.getString("CacheAgentPanel.theCacheAgentIsCurrentlyRunning"));
                jCheckBox = new JCheckBox(Messages.getString("CacheAgentPanel.stopAgent"));
                this.addRow(jCheckBox);
            } else {
                this.addRow(Messages.getString("CacheAgentPanel.theCacheAgentIsCurrentlyNotRunning"));
                jCheckBox = new JCheckBox(Messages.getString("CacheAgentPanel.startAgent"));
                this.addRow(jCheckBox);
            }
            jCheckBox.addItemListener(this);
            this.resetMsgs();
            this.addRow();
        }
        if (string != null) {
            this.addRow(MessageFormat.format(Messages.getString("CacheAgentPanel.theCurrentCacheAdminIs"), string));
        } else {
            string = "";
        }
        if (this._mode == 1) {
            this.gui_uid = new JTextField(string);
            this.addRow(Messages.getString("CacheAgentPanel.cacheAdminID"), (Component)this.gui_uid);
            this._textValues.add(this.gui_uid);
            this.gui_pwd = new JPasswordField();
            this.addRow(Messages.getString("CacheAgentPanel.cacheAdminPwd"), (Component)this.gui_pwd);
            this._textValues.add(this.gui_pwd);
            this._sqlIdx = 3;
            this.confMsg.setText(Messages.getString("CacheAgentPanel.cacheAdminUserHasBeenChanged"));
        }
        this.setSize(this.getPreferredSize());
        this.setBackground(UIManager.getColor("EWTDialog.background"));
    }

    private void resetMsgs() {
        this.confMsg.setText(Messages.getString("CacheAgentPanel.noActionWasPerformedSinceNoneWasSpecified"));
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.resetMsgs();
        if (itemEvent.getStateChange() == 2) {
            this._sqlIdx = 0;
            return;
        }
        if (this._mode == 0) {
            if (this._agentStatus == 0) {
                this._sqlIdx = 1;
                this.confMsg.setText(Messages.getString("CacheAgentPanel.cacheAgentHasBeenStarted"));
            } else {
                this._sqlIdx = 2;
                this.confMsg.setText(Messages.getString("CacheAgentPanel.cacheAgentHasBeenStopped"));
            }
        } else {
            this._sqlIdx = 3;
            this.confMsg.setText(Messages.getString("CacheAgentPanel.idOfCacheAdminHasBeenSet"));
        }
    }

    @Override
    public String getSql() {
        return actionSql[this._sqlIdx];
    }

    @Override
    public boolean validateValues() {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this._mode == 1) {
            this.gui_uid.setText(this.gui_uid.getText().trim());
            if (this.gui_pwd.getPassword().length == 0 && this.gui_uid.getText().length() != 0) {
                stringBuffer.append(Messages.getString("CacheAgentPanel.passwordCannotBeBlankWhenIDIsNotBlank"));
            }
        }
        if (stringBuffer.length() > 0) {
            MessageDialog.error((Component)this, (Object)stringBuffer.toString(), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> getDictionary() {
        return this._dict;
    }

    @Override
    public List<JComponent> getTextValues() {
        return this._textValues;
    }

    @Override
    public List<String> getValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("x");
        arrayList.add("x");
        return arrayList;
    }

    @Override
    public DBObject getDbObject() {
        return this._dbObject;
    }
}

